/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.SelectDBObjectsPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.dictionary.DictionaryDatabase;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;

public abstract class BaseSQLQueryPickerPanel
extends SelectDBObjectsPanel {
    private String[] m_types;
    private SQLQueryBuilder m_builder;
    private boolean m_nondecl;
    private SchemaObject m_sObj;
    private boolean m_canAlwaysNext;

    private void $init$() {
        this.m_canAlwaysNext = true;
    }

    protected BaseSQLQueryPickerPanel() {
        this.$init$();
    }

    protected BaseSQLQueryPickerPanel(boolean canAlwaysNext) {
        this.$init$();
        this.m_canAlwaysNext = canAlwaysNext;
    }

    protected final SQLQueryBuilder getBuilder() {
        return this.m_builder;
    }

    protected final SchemaObject getSchemaObject() {
        return this.m_sObj;
    }

    protected final String[] getAvailableTypes() {
        if (this.m_types == null) {
            this.m_types = new String[]{"TABLE", "VIEW"};
        }
        return this.m_types;
    }

    public final void init(boolean providerChanged, TraversableContext dataContext) {
        Object newObject = dataContext.get("NewObject");
        this.m_sObj = newObject instanceof SchemaObject ? (SchemaObject)newObject : null;
        this.m_builder = (SQLQueryBuilder)dataContext.get("SQLQueryBuilder");
        Schema schema = this.m_sObj != null ? this.m_sObj.getSchema() : (Schema)dataContext.get("Schema");
        super.init(providerChanged, dataContext);
        if (this.m_builder == null) {
            SQLQuery query = null;
            if (newObject instanceof SQLQueryOwner) {
                query = ((SQLQueryOwner)newObject).getSQLQuery();
            } else if (newObject instanceof SQLQuery) {
                query = (SQLQuery)newObject;
            }
            try {
                this.m_builder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)this.getProvider(), (Schema)schema, (SQLQuery)query);
                AbstractSQLQuery newQuery = this.m_builder.getSQLQuery();
                TemporaryObjectID id = (TemporaryObjectID)TemporaryObjectID.createID((DBObject)newQuery);
                newQuery.setID((DBObjectID)id);
                dataContext.put("SQLQueryBuilder", (Object)this.m_builder);
                if (newObject instanceof SQLQueryOwner) {
                    ((SQLQueryOwner)newObject).setSQLQuery((SQLQuery)newQuery);
                } else if (newObject instanceof SQLQuery) {
                    dataContext.put("NewObject", (Object)newQuery);
                }
            }
            catch (SQLQueryException sqe) {
                // empty catch block
            }
        }
        if (this.m_builder == null || this.m_builder.getSQLQuery() instanceof NonDeclarativeSQLQuery) {
            this.clearToPicker();
            this.m_shuttle.setEnabled(false);
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add((Component)new JWrappedLabel(UIArb.getString(627)), "North");
            this.m_nondecl = true;
        } else {
            if (this.m_nondecl) {
                this.removeAll();
                this.layoutComponents();
                this.m_nondecl = false;
            }
            this.m_shuttle.setEnabled(true);
            this.initToPicker(this.m_builder, this.getProvider(), schema);
            Object pro = dataContext.get("DBObjectProvider");
            if (pro instanceof DictionaryDatabase) {
                ((DictionaryDatabase)pro).suspendTimestampQueries("DBObjectProvider");
            }
        }
    }

    protected abstract void clearToPicker();

    protected abstract void initToPicker(SQLQueryBuilder var1, DBObjectProvider var2, Schema var3);

    public final void commit(TraversableContext dataContext) throws TraversalException {
        Object pro;
        if (this.m_builder != null) {
            this.commitToPicker(dataContext);
        }
        if ((pro = dataContext.get("DBObjectProvider")) instanceof DictionaryDatabase) {
            ((DictionaryDatabase)pro).resumeTimestampQueries("DBObjectProvider");
        }
    }

    protected abstract void commitToPicker(TraversableContext var1) throws TraversalException;

    protected boolean canFinish() {
        return true;
    }

    protected boolean canAlwaysNext() {
        return this.m_canAlwaysNext;
    }
}

