/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JTextPane;
import oracle.ide.db.UIArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;

public abstract class BaseSQLQueryBuilderPanel
extends DefaultTraversablePanel {
    private boolean m_canFinish;
    protected WizardCallbacks m_wc;
    protected DialogCallbacks m_dc;
    protected Namespace m_namespace;
    protected DBObjectProvider m_pro;
    protected SchemaObject m_sObj;
    protected Schema m_defaultSchema;
    protected String m_parseMessage;
    private boolean m_noBuilderLayout;
    private Object m_object;

    private void $init$() {
        this.m_canFinish = true;
    }

    protected BaseSQLQueryBuilderPanel() {
        this.$init$();
    }

    protected abstract void layoutComponents();

    protected void layoutNoBuilder() {
        this.layoutMessageOnly(UIArb.getString(627));
    }

    protected void layoutMessageOnly(String text) {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JTextPane message = new JTextPane();
        message.setText(text);
        message.getAccessibleContext().setAccessibleName(text);
        message.getAccessibleContext().setAccessibleDescription("");
        message.setEditable(false);
        message.setOpaque(false);
        message.setEnabled(true);
        message.setBorder(BorderFactory.createEmptyBorder());
        this.add(message, "Center");
    }

    public final void onEntry(TraversableContext tc) {
        AbstractSQLQuery newQuery;
        DBObjectProvider prov;
        this.m_namespace = tc;
        this.m_wc = tc.getWizardCallbacks();
        this.m_dc = tc.getDialogCallbacks();
        Schema currSchema = (Schema)tc.get("Schema");
        if (currSchema != null) {
            this.m_defaultSchema = currSchema;
        }
        if ((prov = (DBObjectProvider)tc.get("DBObjectProvider")) != null) {
            this.m_pro = prov;
        }
        this.m_object = tc.get("NewObject");
        this.m_sObj = this.m_object instanceof SchemaObject ? (SchemaObject)this.m_object : null;
        SQLQuery query = BaseSQLQueryBuilderPanel.findQuery((Namespace)tc);
        SQLQueryBuilder builder = (SQLQueryBuilder)tc.get("SQLQueryBuilder");
        if (!this.isQueryPanel() && builder == null && query != null) {
            try {
                builder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)this.m_pro, (Schema)this.m_defaultSchema, (SQLQuery)query);
                AbstractSQLQuery newQuery2 = builder.getSQLQuery();
                TemporaryObjectID id = (TemporaryObjectID)TemporaryObjectID.createID((DBObject)newQuery2);
                newQuery2.setID((DBObjectID)id);
                if (newQuery2 != null && this.m_object instanceof SQLQueryOwner) {
                    newQuery2.setParent((DBObject)this.m_object);
                }
            }
            catch (SQLQueryException sqe) {
                this.m_parseMessage = sqe.getMessage();
            }
            tc.put("SQLQueryBuilder", (Object)builder);
        }
        if (!this.isQueryPanel() && builder != null && (newQuery = builder.getSQLQuery()) != query) {
            if (this.m_object instanceof SQLQueryOwner) {
                ((SQLQueryOwner)this.m_object).setSQLQuery((SQLQuery)newQuery);
            } else if (this.m_object instanceof SQLQuery) {
                tc.put("NewObject", this.m_object);
            }
        }
        if ((builder == null || query instanceof NonDeclarativeSQLQuery) && this.invalidWithoutBuilder()) {
            this.removeAll();
            this.layoutNoBuilder();
            this.m_noBuilderLayout = true;
        } else {
            if (this.m_noBuilderLayout) {
                this.removeAll();
                this.layoutComponents();
                this.m_noBuilderLayout = false;
            }
            DBObject child = (DBObject)tc.get("DefaultChild");
            this.init(builder, child);
        }
        this.validate();
    }

    protected boolean isQueryPanel() {
        return false;
    }

    protected boolean invalidWithoutBuilder() {
        return true;
    }

    protected void enableButtons(boolean canAdvance) {
        if (this.m_wc != null) {
            this.m_wc.wizardEnableButtons(null, canAdvance ? Boolean.TRUE : Boolean.FALSE, this.m_canFinish ? Boolean.TRUE : Boolean.FALSE);
        } else if (this.m_dc != null) {
            // empty if block
        }
    }

    protected void setCanFinish(boolean canFinish) {
        this.m_canFinish = canFinish;
    }

    protected abstract void init(SQLQueryBuilder var1, DBObject var2);

    protected static SQLQuery findQuery(Namespace namespace) {
        Object newObject = namespace.get("NewObject");
        SQLQuery query = null;
        if (newObject instanceof SQLQuery) {
            query = (SQLQuery)newObject;
        } else if (newObject instanceof SQLQueryOwner) {
            query = ((SQLQueryOwner)newObject).getSQLQuery();
        }
        return query;
    }

    protected Object getObject() {
        return this.m_object;
    }
}

