/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.sql.SQLException;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.panels.DDLPanel;
import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.editor.EditorUtil;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;

public class PlSqlTabbedPanel
extends TabbedEditorPanel {
    public PlSqlTabbedPanel(Traversable top, Navigable[] navs) {
        super(top, navs, null);
    }

    protected void commitToProvider(TraversableContext tc) throws TraversalException {
        DBObjectProvider pro;
        SchemaObject obj = (SchemaObject)tc.find("NewObject");
        boolean create = tc.find("OriginalObject") == null;
        DDLGenerator gen = DDLPanel.getDDLGenerator(tc);
        String text = this.getBufferText(obj, gen);
        if ((create || obj instanceof Trigger) && obj instanceof PlSql) {
            ((PlSql)obj).setSource(text);
        }
        if (!((pro = (DBObjectProvider)tc.find("DBObjectProvider")) instanceof Database)) {
            super.commitToProvider(tc);
            return;
        }
        Schema schema = obj.getSchema();
        String name = obj.getName();
        String dbType = obj.getType();
        URL url = this.getNodeURL(obj, pro);
        Node node = null;
        try {
            node = NodeFactory.findOrCreate((URL)url);
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
        if (node instanceof DBObjectNode) {
            ((DBObjectNode)node).init((DBObject)obj, pro);
        }
        if (node instanceof TextNode) {
            TextNode cbn = (TextNode)node;
            cbn.addNodeListener((NodeListener)new 1(this, pro, dbType, schema, name, cbn));
            TextBuffer buf = null;
            try {
                buf = cbn.acquireTextBuffer();
                buf.beginEdit();
                buf.removeToEnd(0);
                if (text != null) {
                    buf.append(text.toCharArray());
                }
            }
            finally {
                if (buf != null) {
                    buf.endEdit();
                    cbn.releaseTextBuffer();
                }
            }
            EventQueue.invokeLater(new 2(this, cbn));
        }
    }

    protected String getBufferText(SchemaObject obj, DDLGenerator gen) {
        boolean disableTrigger = false;
        if (obj instanceof Trigger && !((Trigger)obj).isEnabled()) {
            disableTrigger = true;
            ((Trigger)obj).setEnabled(true);
        }
        DDLOptions options = new DDLOptions(true, false);
        String source = gen.getCreateDDL(options, new DBObject[]{obj}).toString(false);
        if (obj instanceof Trigger && disableTrigger) {
            ((Trigger)obj).setEnabled(false);
        }
        return source;
    }

    protected URL getNodeURL(SchemaObject obj, DBObjectProvider pro) {
        String subtype = obj instanceof SpecPlSql ? "Spec" : null;
        URL url = DBURLFactory.getURL(pro, obj, subtype);
        return url;
    }

    final class 1
    extends NodeListener {
        private final /* synthetic */ DBObjectProvider v$pro;
        private final /* synthetic */ String v$dbType;
        private final /* synthetic */ Schema v$schema;
        private final /* synthetic */ String v$name;
        private final /* synthetic */ TextNode v$cbn;
        final /* synthetic */ PlSqlTabbedPanel this$0;

        public void nodeSaved(NodeEvent e) {
            block7: {
                try {
                    try {
                        SchemaObject obj = this.v$pro.getObject(this.v$dbType, this.v$schema, this.v$name);
                        if (obj != null && this.v$pro instanceof AbstractDatabase) {
                            ((AbstractDatabase)this.v$pro).fireObjectsAdded(this.v$schema, new SchemaObject[]{obj});
                        }
                    }
                    catch (DBException ex) {
                        String title = UIArb.getString(687);
                        Throwable cause = ex.getCause();
                        if (cause instanceof SQLException) {
                            SQLErrorDialog.showErrorDialog((Component)((Object)this.this$0), title, (SQLException)cause);
                            break block7;
                        }
                        DBExceptionDialog.showErrorDialog((Component)((Object)this.this$0), title, ex);
                    }
                }
                finally {
                    this.v$cbn.removeNodeListener((NodeListener)this);
                }
            }
        }

        public void nodeClosed(NodeEvent e) {
            this.v$cbn.removeNodeListener((NodeListener)this);
        }

        public 1(PlSqlTabbedPanel plSqlTabbedPanel, DBObjectProvider dBObjectProvider, String string, Schema schema, String string2, TextNode textNode) {
            this.v$cbn = textNode;
            this.v$name = string2;
            this.v$schema = schema;
            this.v$dbType = string;
            this.v$pro = dBObjectProvider;
            this.this$0 = plSqlTabbedPanel;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ TextNode v$cbn;
        final /* synthetic */ PlSqlTabbedPanel this$0;

        public void run() {
            EditorUtil.openDefaultEditorInFrame((Node)this.v$cbn);
        }

        public 2(PlSqlTabbedPanel plSqlTabbedPanel, TextNode textNode) {
            this.v$cbn = textNode;
            this.this$0 = plSqlTabbedPanel;
        }
    }
}

