/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.plsql.ParamsModel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.PlSqlParametersVerifier;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.Function;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.icons.OracleIcons;

public class PlSqlParametersPanel
extends BaseInfoPanel {
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnUp;
    private JButton btnDown;
    private JScrollPane scrParams;
    private JTable tblParams;
    private DBObjectRenderer _renderer;
    private NonNullableComboBoxModel _mdlMode;
    private DefaultComboBoxModel _mdlType;
    private TableColumnModel _mdlCols;
    private ParamsModel _mdlParams;
    private L _listener;
    private static final String ADD_CMD = "ADD";
    private static final String REMOVE_CMD = "REMOVE";
    private static final String UP_CMD = "UP";
    private static final String DOWN_CMD = "DOWN";

    private void $init$() {
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.scrParams = new JScrollPane();
        this.tblParams = new JTable();
        this._mdlMode = new NonNullableComboBoxModel();
        this._mdlType = new DefaultComboBoxModel();
        this._mdlCols = new DefaultTableColumnModel();
        this._mdlParams = new ParamsModel();
        this._listener = new L(null);
    }

    public PlSqlParametersPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.init((DBObjectProvider)traversableContext.find("DBObjectProvider"), (DeclarativePlSql)traversableContext.find("NewObject"), (Verifier)traversableContext.find("SchemaObjectInfoVerifier"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit((DeclarativePlSql)traversableContext.find("NewObject"), (PlSqlParametersVerifier)traversableContext.find("SchemaObjectInfoVerifier"));
    }

    protected void init(DBObjectProvider prov, DeclarativePlSql plsql, Verifier ver) {
        super.init(prov, ver);
        this._mdlParams.init(prov, plsql, plsql instanceof Function);
    }

    protected void commit(DeclarativePlSql plsql, PlSqlParametersVerifier verifier) throws TraversalException {
        int currRow = this.tblParams.getSelectedRow();
        if (this.tblParams.isEditing() && currRow != -1) {
            int currCol = this.tblParams.getSelectedColumn();
            int tmpCol = currCol == 2 ? 4 : 2;
            this.tblParams.editCellAt(currRow, tmpCol);
            this.tblParams.editCellAt(currRow, currCol);
        }
        this._mdlParams.commit(plsql, verifier);
    }

    private void jbInit() throws Exception {
        TableColumn colName = new TableColumn(0);
        colName.setHeaderValue("Name");
        colName.setCellRenderer(this._renderer);
        this._mdlCols.addColumn(colName);
        this._mdlType.addElement("VARCHAR2");
        this._mdlType.addElement("NUMBER");
        this._mdlType.addElement("DATE");
        this._mdlType.addElement("CLOB");
        this._mdlType.addElement("BLOB");
        TableColumn colType = new TableColumn(1);
        colType.setHeaderValue("Type");
        JComboBox cmbType = new JComboBox(this._mdlType);
        cmbType.setName("PlSqlParametersPanel.cmbType");
        cmbType.setEditable(true);
        colType.setCellEditor(new DefaultCellEditor(cmbType));
        this._mdlCols.addColumn(colType);
        PlSqlParameter.Mode[] modeArray = PlSqlParameter.Mode.values();
        int n = 0;
        while (n < modeArray.length) {
            PlSqlParameter.Mode mode = modeArray[n];
            this._mdlMode.addElement((Object)mode);
            ++n;
        }
        this._mdlMode.addElement((Object)"");
        TableColumn colMode = new TableColumn(2);
        colMode.setHeaderValue("Mode");
        JComboBox cmbMode = new JComboBox(this._mdlMode);
        cmbMode.setName("PlSqlParametersPanel.cmbMode");
        colMode.setCellEditor(new DefaultCellEditor(cmbMode));
        this._mdlCols.addColumn(colMode);
        TableColumn colDefault = new TableColumn(3);
        colDefault.setHeaderValue("Default Value");
        this._mdlCols.addColumn(colDefault);
        this.tblParams.setModel(this._mdlParams);
        this.tblParams.setColumnModel(this._mdlCols);
        this.tblParams.getSelectionModel().addListSelectionListener(this._listener);
        this.setLayout(new BorderLayout());
        Dimension size = new Dimension(28, 25);
        this.btnUp.setPreferredSize(size);
        this.btnUp.setIcon(OracleIcons.getIcon((String)"previous.png"));
        DBObjectRenderer.setToolTipText(this.btnUp, UIArb.getString(756));
        this.btnUp.setActionCommand(UP_CMD);
        this.btnUp.addActionListener(this._listener);
        this.btnUp.setEnabled(false);
        this.btnDown.setPreferredSize(size);
        this.btnDown.setIcon(OracleIcons.getIcon((String)"next.png"));
        DBObjectRenderer.setToolTipText(this.btnDown, UIArb.getString(462));
        this.btnDown.setActionCommand(DOWN_CMD);
        this.btnDown.addActionListener(this._listener);
        this.btnDown.setEnabled(false);
        this.btnAdd.setPreferredSize(size);
        this.btnAdd.setIcon(OracleIcons.getIcon((String)"add.png"));
        DBObjectRenderer.setToolTipText(this.btnAdd, UIArb.getString(695));
        this.btnAdd.setActionCommand(ADD_CMD);
        this.btnAdd.addActionListener(this._listener);
        this.btnRemove.setPreferredSize(size);
        this.btnRemove.setIcon(OracleIcons.getIcon((String)"delete.png"));
        DBObjectRenderer.setToolTipText(this.btnRemove, UIArb.getString(849));
        this.btnRemove.setActionCommand(REMOVE_CMD);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(this._listener);
        JPanel pnlButtons = new JPanel(new GridBagLayout());
        pnlButtons.add((Component)this.btnAdd, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlButtons.add((Component)this.btnRemove, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        pnlButtons.add((Component)this.btnUp, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(15, 0, 0, 0), 0, 0));
        pnlButtons.add((Component)this.btnDown, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.tblParams.setSelectionMode(0);
        this.scrParams.getViewport().add((Component)this.tblParams, null);
        this.setLayout(new BorderLayout(5, 5));
        this.add(pnlButtons, "East");
        this.add(this.scrParams, "Center");
    }

    static JTable ra$tblParams(PlSqlParametersPanel plSqlParametersPanel) {
        return plSqlParametersPanel.tblParams;
    }

    static ParamsModel ra$_mdlParams(PlSqlParametersPanel plSqlParametersPanel) {
        return plSqlParametersPanel._mdlParams;
    }

    static JButton ra$btnRemove(PlSqlParametersPanel plSqlParametersPanel) {
        return plSqlParametersPanel.btnRemove;
    }

    static JButton ra$btnUp(PlSqlParametersPanel plSqlParametersPanel) {
        return plSqlParametersPanel.btnUp;
    }

    static JButton ra$btnDown(PlSqlParametersPanel plSqlParametersPanel) {
        return plSqlParametersPanel.btnDown;
    }

    private class L
    implements ListSelectionListener,
    ActionListener {
        public void valueChanged(ListSelectionEvent e) {
            int row = PlSqlParametersPanel.ra$tblParams(PlSqlParametersPanel.this).getSelectedRow();
            this.updateButtons(row);
        }

        private void updateButtons(int row) {
            PlSqlParametersPanel.ra$btnRemove(PlSqlParametersPanel.this).setEnabled(PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).canRemoveRow(row));
            PlSqlParametersPanel.ra$btnUp(PlSqlParametersPanel.this).setEnabled(PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).canMoveRowUp(row));
            PlSqlParametersPanel.ra$btnDown(PlSqlParametersPanel.this).setEnabled(PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).canMoveRowDown(row));
        }

        public void actionPerformed(ActionEvent e) {
            int sel = PlSqlParametersPanel.ra$tblParams(PlSqlParametersPanel.this).getSelectedRow();
            String cmd = e.getActionCommand();
            if (PlSqlParametersPanel.ADD_CMD.equals(cmd)) {
                if (sel >= 0) {
                    PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).addParameter(sel++);
                } else {
                    PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).addParameter();
                    sel = PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).getRowCount() - 1;
                }
            } else if (PlSqlParametersPanel.REMOVE_CMD.equals(cmd)) {
                PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).removeParameter(sel);
                if (sel >= PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).getRowCount()) {
                    sel = PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).getRowCount() - 1;
                }
            } else if (PlSqlParametersPanel.UP_CMD.equals(cmd)) {
                PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).moveUp(sel--);
            } else if (PlSqlParametersPanel.DOWN_CMD.equals(cmd)) {
                PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).moveDown(sel++);
            }
            if (sel > -1) {
                PlSqlParametersPanel.ra$tblParams(PlSqlParametersPanel.this).setRowSelectionInterval(sel, sel);
            }
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

