/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.mview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.table.StorageInfoPanel;
import oracle.ide.db.verifiers.MViewInfoVerifier;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleStorageProperties;

public class MViewRightPanel
extends JPanel
implements ActionListener {
    private final String[] _buildTypeStrings;
    private MViewInfoVerifier m_verifier;
    private JCheckBox _useindexCheckBox;
    private JButton _indexStorageButton;
    private JButton _storageButton;
    private JCheckBox _compressCheckBox;
    private JCheckBox _parallelCheckBox;
    private JTextField _parallelValue;
    private JPanel northPane;
    private JPanel centerPane;
    private JCheckBox _enableCacheCheckBox;
    private JLabel _buildTypeLabel;
    private JComboBox _buildTypeComboBox;
    private JCheckBox _queryRewriteCheck;
    private JCheckBox _prebuiltCheckBox;
    private ButtonGroup bgPrebuilt;
    private JRadioButton _reducedPrecisionRadio;
    private JRadioButton _noReducedRadio;
    private DBObjectProvider m_prov;
    private MaterializedView m_matView;
    private StorageInfoVerifier m_siVerifier;
    private String[] m_tablespaces;
    private boolean m_editting;
    private DBUIResourceHelper _resHelper;

    private void $init$() {
        this._buildTypeStrings = new String[]{UIArb.getString(760), UIArb.getString(779)};
        this.m_verifier = null;
        this._useindexCheckBox = new JCheckBox();
        this._indexStorageButton = new JButton();
        this._storageButton = new JButton();
        this._compressCheckBox = new JCheckBox();
        this._parallelCheckBox = new JCheckBox();
        this._parallelValue = new JTextField();
        this.northPane = new JPanel();
        this.centerPane = new JPanel();
        this._enableCacheCheckBox = new JCheckBox();
        this._buildTypeLabel = new JLabel();
        this._buildTypeComboBox = new JComboBox<String>(this._buildTypeStrings);
        this._queryRewriteCheck = new JCheckBox();
        this._prebuiltCheckBox = new JCheckBox();
        this.bgPrebuilt = new ButtonGroup();
        this._reducedPrecisionRadio = new JRadioButton();
        this._noReducedRadio = new JRadioButton();
        this._resHelper = new DBUIResourceHelper("MViewRightPanel");
    }

    public MViewRightPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getParallelCheck() {
        return this._parallelCheckBox.isSelected();
    }

    public void setParallelCheck(boolean b) {
        this._parallelCheckBox.setSelected(b);
    }

    public String getParallelValue() {
        return this._parallelValue.getText();
    }

    public void setParallelValue(String s) {
        this._parallelValue.setText(s);
    }

    public boolean getEnableCache() {
        return this._enableCacheCheckBox.isSelected();
    }

    public void setEnableCache(boolean b) {
        this._enableCacheCheckBox.setSelected(b);
    }

    public boolean getEnableQueryRewrite() {
        return this._queryRewriteCheck.isSelected();
    }

    public void setEnableQueryRewrite(boolean b) {
        this._queryRewriteCheck.setSelected(b);
    }

    public boolean getUseIndex() {
        return this._useindexCheckBox.isSelected();
    }

    public void setUseIndex(boolean b) {
        this._useindexCheckBox.setSelected(b);
    }

    public String getBuildType() {
        return (String)this._buildTypeComboBox.getSelectedItem();
    }

    public void setBuildType(String s) {
        this._buildTypeComboBox.setSelectedItem(s);
    }

    protected void init(DBObjectProvider prov, MaterializedView mview, MViewInfoVerifier verifier, StorageInfoVerifier siVerifier, Schema[] schemas, String[] tablespaces, boolean editting, boolean isEditable) {
        this.m_verifier = verifier;
        this.m_prov = prov;
        this.m_matView = mview;
        this.m_siVerifier = siVerifier;
        this.m_tablespaces = tablespaces;
        this.m_editting = editting;
        this._compressCheckBox.setSelected(mview.isCompression());
        int parallel = mview.getParallel();
        if (parallel == 0) {
            this._parallelValue.setText(null);
            this._parallelCheckBox.setSelected(true);
            this._parallelCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
            this._parallelValue.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
        } else if (parallel < 2) {
            this._parallelValue.setText(null);
            this._parallelCheckBox.setSelected(false);
            this._parallelCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
            this._parallelValue.setEnabled(false);
        } else {
            this._parallelValue.setText(Integer.toString(parallel));
            this._parallelCheckBox.setSelected(true);
            this._parallelCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
            this._parallelValue.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
        }
        this._enableCacheCheckBox.setSelected(mview.isCache());
        this._enableCacheCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOEnableCache());
        this._queryRewriteCheck.setSelected(mview.isRewrite());
        this._queryRewriteCheck.setEnabled(this.m_verifier == null || this.m_verifier.canMVOQueryRewrite());
        if (mview.getBuildType() == MaterializedView.BuildType.IMMEDIATE) {
            this._buildTypeComboBox.setSelectedItem(UIArb.getString(760));
        } else if (mview.getBuildType() == MaterializedView.BuildType.DEFERRED) {
            this._buildTypeComboBox.setSelectedItem(UIArb.getString(779));
        }
        this._buildTypeComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
        this._buildTypeLabel.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
        this._prebuiltCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
        if (mview.getOnPrebuilt() != MaterializedView.PrebuiltType.NONE) {
            this._prebuiltCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
            this._prebuiltCheckBox.setSelected(true);
            this._reducedPrecisionRadio.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
            this._noReducedRadio.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
            if (MaterializedView.PrebuiltType.WITHOUT_REDUCED_PRECISION == mview.getOnPrebuilt()) {
                this._noReducedRadio.setSelected(true);
            } else {
                this._reducedPrecisionRadio.setSelected(true);
            }
        } else {
            this._prebuiltCheckBox.setSelected(false);
            this._reducedPrecisionRadio.setEnabled(false);
            this._noReducedRadio.setEnabled(false);
        }
        this._useindexCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canUseIndex());
        this._useindexCheckBox.setSelected(mview.isUseNoIndex() ^ true);
        this._indexStorageButton.setEnabled(mview.isUseNoIndex() ^ true);
        if (!isEditable) {
            this.disableAll();
        }
    }

    public void commit(MaterializedView mview, Schema[] schema, boolean isForward) throws TraversalException {
        mview.setCompression(this._compressCheckBox.isSelected());
        int parallelValue = 1;
        if (this._parallelCheckBox.isSelected()) {
            String textIn = this._parallelValue.getText();
            try {
                parallelValue = textIn == null || textIn.equals("") ? 0 : Integer.parseInt(textIn);
            }
            catch (NumberFormatException e) {
                parallelValue = 0;
            }
        }
        mview.setParallel(parallelValue);
        mview.setCache(this._enableCacheCheckBox.isSelected());
        mview.setRewrite(this._queryRewriteCheck.isSelected());
        mview.setUseNoIndex(true);
        if (((String)this._buildTypeComboBox.getSelectedItem()).equals(UIArb.getString(760))) {
            mview.setBuildType(MaterializedView.BuildType.IMMEDIATE);
        } else if (((String)this._buildTypeComboBox.getSelectedItem()).equals(UIArb.getString(779))) {
            mview.setBuildType(MaterializedView.BuildType.DEFERRED);
        }
        if (this._useindexCheckBox.isSelected()) {
            mview.setUseNoIndex(false);
        } else {
            mview.setUseNoIndex(true);
            this.m_matView.getProperties().remove("MatViewIndexStorageProperties");
        }
        if (this._prebuiltCheckBox.isSelected()) {
            mview.setOnPrebuilt(this._reducedPrecisionRadio.isSelected() ? MaterializedView.PrebuiltType.WITH_REDUCED_PRECISION : MaterializedView.PrebuiltType.WITHOUT_REDUCED_PRECISION);
        } else {
            mview.setOnPrebuilt(MaterializedView.PrebuiltType.NONE);
        }
    }

    private void jbInit() throws Exception {
        this.northPane.setLayout(new GridBagLayout());
        int y = 0;
        this.northPane.add((Component)this._compressCheckBox, new GridBagConstraints(0, y, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.northPane.add((Component)this._parallelCheckBox, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.northPane.add((Component)this._parallelValue, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.northPane.add((Component)this._enableCacheCheckBox, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.northPane.add((Component)this._queryRewriteCheck, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.northPane.add((Component)this._prebuiltCheckBox, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.northPane.add((Component)this._reducedPrecisionRadio, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 15, 0, 5), 0, 0));
        this.northPane.add((Component)this._noReducedRadio, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 15, 0, 5), 0, 0));
        this.northPane.add((Component)this._buildTypeLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.northPane.add((Component)this._buildTypeComboBox, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.northPane.add((Component)this._storageButton, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.northPane.add(Box.createGlue(), new GridBagConstraints(4, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPane.setLayout(new GridBagLayout());
        this.centerPane.add((Component)this._useindexCheckBox, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.centerPane.add((Component)this._indexStorageButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 5), 2, 0));
        this.centerPane.add(Box.createGlue(), new GridBagConstraints(4, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.northPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.centerPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.northPane.setBorder(BorderFactory.createTitledBorder(UIArb.getString(660)));
        this.centerPane.setBorder(BorderFactory.createTitledBorder(UIArb.getString(757)));
        this._resHelper.resButton(this._enableCacheCheckBox, UIArb.getString(285), "_enableCacheCheckBox");
        this._enableCacheCheckBox.setToolTipText(UIArb.getString(227));
        this._enableCacheCheckBox.addActionListener(new 1());
        this._resHelper.resLabel(this._buildTypeLabel, this._buildTypeComboBox, UIArb.getString(659), "_buildTypeComboBox");
        this._resHelper.resButton(this._useindexCheckBox, UIArb.getString(816), "_useindexCheckBox");
        this._useindexCheckBox.setEnabled(true);
        this._useindexCheckBox.addActionListener(new 2());
        this._resHelper.resButton(this._compressCheckBox, UIArb.getString(359), "_compressCheckBox");
        this._resHelper.resButton(this._storageButton, UIArb.getString(843), "_storageButton");
        this._storageButton.addActionListener(this);
        this._resHelper.resButton(this._indexStorageButton, UIArb.getString(843), "_indexStorageButton");
        this._indexStorageButton.addActionListener(this);
        this._resHelper.resButton(this._parallelCheckBox, UIArb.getString(401), "_parallelCheckBox");
        this._parallelCheckBox.setToolTipText(UIArb.getString(817));
        this._parallelCheckBox.addActionListener(new 3());
        this._parallelValue.addActionListener(new 4());
        this._parallelValue.addKeyListener(new 5());
        this._parallelValue.setEnabled(this._parallelCheckBox.isEnabled());
        this._buildTypeComboBox.setSelectedIndex(0);
        this._resHelper.resButton(this._queryRewriteCheck, UIArb.getString(262), "_queryRewriteCheck");
        this._resHelper.resButton(this._prebuiltCheckBox, UIArb.getString(694), "_prebuiltCheckBox");
        this._prebuiltCheckBox.addActionListener(new 6());
        this._resHelper.resButton(this._reducedPrecisionRadio, UIArb.getString(246), "_reducedPrecisionRadio");
        this._resHelper.resButton(this._noReducedRadio, UIArb.getString(702), "_noReducedRadio");
        this.bgPrebuilt.add(this._noReducedRadio);
        this.bgPrebuilt.add(this._reducedPrecisionRadio);
        this._noReducedRadio.setEnabled(false);
        this._reducedPrecisionRadio.setEnabled(false);
    }

    private void _useindexCheckBox_actionPerformed(ActionEvent e) {
        this._indexStorageButton.setEnabled(this._useindexCheckBox.isSelected());
    }

    private void _parallelValue_actionPerformed(ActionEvent e) {
    }

    private void _parallelCheckBox_actionPerformed(ActionEvent e) {
        if (this._parallelCheckBox.isSelected()) {
            this._parallelValue.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
            if (this._parallelCheckBox.isSelected()) {
                this._parallelValue.setEditable(true);
            } else {
                this._parallelValue.setEditable(false);
            }
        } else {
            this._parallelValue.setEnabled(false);
            this._parallelValue.setEditable(false);
        }
    }

    private void _valueParallelRadio_actionPerformed(ActionEvent e) {
        this._parallelValue.setEditable(true);
    }

    private void _defaultParallelRadio_actionPerformed(ActionEvent e) {
        this._parallelValue.setEditable(false);
    }

    private void _cacheCheck_actionPerformed(ActionEvent e) {
    }

    private void jButton2_actionPerformed(ActionEvent e) {
    }

    private void jComboBox1_actionPerformed(ActionEvent e) {
    }

    private void _extentTextField_actionPerformed(ActionEvent e) {
    }

    private void _prebuiltCheckBox_actionPerformed(ActionEvent e) {
        if (this._prebuiltCheckBox.isSelected()) {
            this._reducedPrecisionRadio.setEnabled(true);
            this._noReducedRadio.setEnabled(true);
        } else {
            this._reducedPrecisionRadio.setEnabled(false);
            this._noReducedRadio.setEnabled(false);
        }
    }

    private void disableAll() {
        this._useindexCheckBox.setEnabled(false);
        this._storageButton.setEnabled(false);
        this._indexStorageButton.setEnabled(false);
        this._parallelCheckBox.setEnabled(false);
        this._parallelValue.setEnabled(false);
        this._enableCacheCheckBox.setEnabled(false);
        this._compressCheckBox.setEnabled(false);
        this._buildTypeLabel.setEnabled(false);
        this._buildTypeComboBox.setEnabled(false);
        this._queryRewriteCheck.setEnabled(false);
        this._prebuiltCheckBox.setEnabled(false);
        this._reducedPrecisionRadio.setEnabled(false);
        this._noReducedRadio.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._storageButton) {
            OracleStorageProperties osp = (OracleStorageProperties)this.m_matView.getProperty("OracleStorageProperties");
            if ((osp = StorageInfoPanel.edit(osp, StorageInfoPanel.StorageInfoFor.MATERIALIZED_VIEW, this.m_prov, (DBObject)this.m_matView, null, this.m_siVerifier, this.m_tablespaces, this)) != null) {
                this.m_matView.setProperty("OracleStorageProperties", (Object)osp);
            } else {
                this.m_matView.getProperties().remove("OracleStorageProperties");
            }
        } else if (source == this._indexStorageButton) {
            OracleStorageProperties osp = (OracleStorageProperties)this.m_matView.getProperty("MatViewIndexStorageProperties");
            if (this.m_editting && this.m_prov instanceof Database) {
                StorageInfoPanel.view(osp, StorageInfoPanel.StorageInfoFor.MATERIALIZED_VIEW_INDEX, this.m_prov, (DBObject)this.m_matView, null, this.m_siVerifier, this.m_tablespaces, this);
            } else if ((osp = StorageInfoPanel.edit(osp, StorageInfoPanel.StorageInfoFor.MATERIALIZED_VIEW_INDEX, this.m_prov, (DBObject)this.m_matView, null, this.m_siVerifier, this.m_tablespaces, this)) != null) {
                this.m_matView.setProperty("MatViewIndexStorageProperties", (Object)osp);
            } else {
                this.m_matView.getProperties().remove("MatViewIndexStorageProperties");
            }
        }
    }

    static void mav$_cacheCheck_actionPerformed(MViewRightPanel mViewRightPanel, ActionEvent actionEvent) {
        mViewRightPanel._cacheCheck_actionPerformed(actionEvent);
    }

    static void mav$_useindexCheckBox_actionPerformed(MViewRightPanel mViewRightPanel, ActionEvent actionEvent) {
        mViewRightPanel._useindexCheckBox_actionPerformed(actionEvent);
    }

    static void mav$_parallelCheckBox_actionPerformed(MViewRightPanel mViewRightPanel, ActionEvent actionEvent) {
        mViewRightPanel._parallelCheckBox_actionPerformed(actionEvent);
    }

    static void mav$_parallelValue_actionPerformed(MViewRightPanel mViewRightPanel, ActionEvent actionEvent) {
        mViewRightPanel._parallelValue_actionPerformed(actionEvent);
    }

    static void mav$_prebuiltCheckBox_actionPerformed(MViewRightPanel mViewRightPanel, ActionEvent actionEvent) {
        mViewRightPanel._prebuiltCheckBox_actionPerformed(actionEvent);
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MViewRightPanel.mav$_cacheCheck_actionPerformed(MViewRightPanel.this, e);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MViewRightPanel.mav$_useindexCheckBox_actionPerformed(MViewRightPanel.this, e);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MViewRightPanel.mav$_parallelCheckBox_actionPerformed(MViewRightPanel.this, e);
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MViewRightPanel.mav$_parallelValue_actionPerformed(MViewRightPanel.this, e);
        }
    }

    final class 5
    extends KeyAdapter {
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                MViewRightPanel.this.getToolkit().beep();
                e.consume();
            }
        }
    }

    final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MViewRightPanel.mav$_prebuiltCheckBox_actionPerformed(MViewRightPanel.this, e);
        }
    }
}

