/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.mview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.StorageInfoPanel;
import oracle.ide.db.verifiers.MViewLogInfoVerifier;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObjectListener;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.util.ModelUtil;

public class MViewLogPanel
extends BaseInfoPanel
implements ItemListener,
FocusListener,
SchemaObjectListener,
ActionListener {
    MaterializedViewLog _model;
    MaterializedViewLog _orig;
    DBObjectProvider _prov;
    MViewLogInfoVerifier _verifier;
    boolean _create;
    boolean _firstInit;
    private JPanel _pnlSubTop;
    private JPanel _pnlSubBot;
    private GridLayout _layPnl;
    private GridBagLayout _laySubTop;
    private GridBagLayout _laySubBot;
    private JLabel _lblCache;
    private JLabel _lblPK;
    private JLabel _lblROWID;
    private JLabel _lblNewValues;
    private JLabel _lblSequence;
    private JComboBox _cmbCache;
    private JComboBox _cmbPK;
    private JComboBox _cmbROWID;
    private JComboBox _cmbNewValues;
    private JComboBox _cmbSequence;
    private JTextField _parallelValue;
    private JCheckBox _cbxParallel;
    private JButton _storageButton;
    private JLabel _lblAvail;
    private JList _lstAvail;
    private ListPicker _pckAvail;
    private JLabel _lblSel;
    private JList _lstSel;
    private MVLListPicker _pckSel;
    private Shuttle _shtCols;
    private DBObjectID _lastMasterTableID;
    private Schema _lastSchema;
    private boolean m_listening;
    private StorageInfoVerifier m_siVerifier;
    private String[] m_tablespaces;
    private DBUIResourceHelper m_resHelper;
    private static final String CACHE = "CACHE";
    private static final String NOCACHE = "NOCACHE";
    private static final String INCLUDING = "INCLUDING";
    private static final String EXCLUDING = "EXCLUDING";

    private void $init$() {
        this._model = null;
        this._orig = null;
        this._prov = null;
        this._verifier = null;
        this._create = true;
        this._firstInit = true;
        this._pnlSubTop = new JPanel();
        this._pnlSubBot = new JPanel();
        this._layPnl = new GridLayout();
        this._laySubTop = new GridBagLayout();
        this._laySubBot = new GridBagLayout();
        this._lblCache = new JLabel();
        this._lblPK = new JLabel();
        this._lblROWID = new JLabel();
        this._lblNewValues = new JLabel();
        this._lblSequence = new JLabel();
        this._cmbCache = new JComboBox();
        this._cmbPK = new JComboBox();
        this._cmbROWID = new JComboBox();
        this._cmbNewValues = new JComboBox();
        this._cmbSequence = new JComboBox();
        this._parallelValue = new JTextField();
        this._cbxParallel = new JCheckBox();
        this._storageButton = new JButton();
        this._lblAvail = new JLabel();
        this._lstAvail = new JList();
        this._pckAvail = new ListPicker(this._lstAvail);
        this._lblSel = new JLabel();
        this._lstSel = new JList();
        this._pckSel = new MVLListPicker(this._lstSel);
        this._shtCols = new Shuttle();
        this._lastMasterTableID = null;
        this._lastSchema = null;
        this.m_listening = false;
        this.m_resHelper = new DBUIResourceHelper("MViewLogPanel");
    }

    public MViewLogPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layPnl);
        this._pnlSubTop.setLayout(this._laySubTop);
        this._pnlSubBot.setLayout(this._laySubBot);
        this._layPnl.setColumns(1);
        this._layPnl.setRows(2);
        this._layPnl.setVgap(10);
        this.m_resHelper.resLabel(this._lblCache, this._cmbCache, UIArb.getString(561), "_cmbCache");
        this.m_resHelper.resButton(this._cbxParallel, UIArb.getString(784), "_cbxParallel");
        this._cbxParallel.addActionListener(new 1());
        this._parallelValue.addKeyListener(new 2());
        this.m_resHelper.resLabel(this._lblROWID, this._cmbROWID, UIArb.getString(672), "_cmbROWID");
        this.m_resHelper.resLabel(this._lblPK, this._cmbPK, UIArb.getString(428), "_cmbPK");
        this.m_resHelper.resLabel(this._lblNewValues, this._cmbNewValues, UIArb.getString(72), "_cmbNewValues");
        this.m_resHelper.resLabel(this._lblSequence, this._cmbSequence, UIArb.getString(46), "_cmbSequence");
        this.m_resHelper.resButton(this._storageButton, UIArb.getString(843), "_storageButton");
        this._storageButton.addActionListener(this);
        this._pnlSubTop.add((Component)this._lblROWID, new GridBagConstraints(10, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        this._pnlSubTop.add((Component)this._cmbROWID, new GridBagConstraints(20, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 12, 0, 0), 0, 0));
        this._pnlSubTop.add((Component)this._lblCache, new GridBagConstraints(30, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 24, 0, 0), 0, 0));
        this._pnlSubTop.add((Component)this._cmbCache, new GridBagConstraints(40, 10, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 12, 0, 0), 0, 0));
        this._pnlSubTop.add((Component)this._lblPK, new GridBagConstraints(10, 20, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        this._pnlSubTop.add((Component)this._cmbPK, new GridBagConstraints(20, 20, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 12, 0, 0), 0, 0));
        this._pnlSubTop.add((Component)this._cbxParallel, new GridBagConstraints(30, 20, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 24, 0, 0), 0, 0));
        this._pnlSubTop.add((Component)this._parallelValue, new GridBagConstraints(40, 20, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 12, 0, 0), 0, 0));
        this._pnlSubTop.add((Component)this._lblNewValues, new GridBagConstraints(10, 30, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        this._pnlSubTop.add((Component)this._cmbNewValues, new GridBagConstraints(20, 30, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 12, 0, 0), 0, 0));
        this._pnlSubTop.add((Component)this._lblSequence, new GridBagConstraints(30, 30, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 24, 0, 0), 0, 0));
        this._pnlSubTop.add((Component)this._cmbSequence, new GridBagConstraints(40, 30, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 12, 0, 0), 0, 0));
        this._pnlSubTop.add((Component)this._storageButton, new GridBagConstraints(40, 40, 1, 1, 1.0, 0.0, 13, 0, new Insets(8, 12, 0, 0), 0, 0));
        this.m_resHelper.resLabel(this._lblAvail, this._lstAvail, UIArb.getString(411), "_lstAvail");
        this._shtCols.setFromPicker((ItemPicker)this._pckAvail);
        this._lstAvail.addFocusListener(this);
        this.m_resHelper.resLabel(this._lblSel, this._lstSel, UIArb.getString(799), "_lstSel");
        this._shtCols.setToPicker((ItemPicker)this._pckSel);
        this._lstSel.addFocusListener(this);
        this._shtCols.add((Component)this._lblAvail, (Object)"FromHeader");
        this._shtCols.add((Component)this._lblSel, (Object)"ToHeader");
        this._pnlSubBot.add((Component)this._shtCols, new GridBagConstraints(10, 10, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._pnlSubTop, null);
        this.add(this._pnlSubBot, null);
        this._cmbCache.addItem(null);
        this._cmbCache.addItem(CACHE);
        this._cmbCache.addItem(NOCACHE);
        this._cmbNewValues.addItem(null);
        this._cmbNewValues.addItem(INCLUDING);
        this._cmbNewValues.addItem(EXCLUDING);
        this._cmbPK.addItem(null);
        this._cmbPK.addItem(UIArb.getString(444));
        this._cmbPK.addItem(UIArb.getString(792));
        this._cmbROWID.addItem(null);
        this._cmbROWID.addItem(UIArb.getString(444));
        this._cmbROWID.addItem(UIArb.getString(792));
        this._cmbSequence.addItem(null);
        this._cmbSequence.addItem(UIArb.getString(444));
        this._cmbSequence.addItem(UIArb.getString(792));
    }

    public void onEntry(TraversableContext dataContext) {
        this._prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this._model = (MaterializedViewLog)dataContext.find("NewObject");
        this._orig = (MaterializedViewLog)dataContext.find("OriginalObject");
        this._verifier = (MViewLogInfoVerifier)dataContext.find("SchemaObjectInfoVerifier");
        this._create = this._orig == null;
        this.m_siVerifier = (StorageInfoVerifier)dataContext.find("StorageInfoVerifier");
        this.m_tablespaces = this.getTablespaces(dataContext, this._prov);
        this.init();
        boolean isEditable = (Boolean)dataContext.find("DBObjectIsEditable");
        if (!isEditable) {
            this._lblCache.setEnabled(false);
            this._lblPK.setEnabled(false);
            this._lblROWID.setEnabled(false);
            this._lblNewValues.setEnabled(false);
            this._lblSequence.setEnabled(false);
            this._cmbCache.setEnabled(false);
            this._cmbPK.setEnabled(false);
            this._cmbROWID.setEnabled(false);
            this._cmbNewValues.setEnabled(false);
            this._cmbSequence.setEnabled(false);
            this._parallelValue.setEnabled(false);
            this._cbxParallel.setEnabled(false);
            this._lblAvail.setEnabled(false);
            this._lstAvail.setEnabled(false);
            this._lblSel.setEnabled(false);
            this._lstSel.setEnabled(false);
            this._shtCols.setEnabled(false);
            this._storageButton.setEnabled(false);
        }
    }

    protected void init() {
        super.init(this._prov, this._verifier);
        if (!this.m_listening) {
            this._model.addObjectListener((SchemaObjectListener)this);
            this.m_listening = true;
        }
        if (this._firstInit) {
            Boolean caching;
            if (this._prov instanceof OracleDatabase && !this._create) {
                this._cmbCache.removeItem(null);
                this._cmbNewValues.removeItem(null);
                this._cmbPK.removeItem(null);
                this._cmbROWID.removeItem(null);
                this._cmbSequence.removeItem(null);
            }
            if ((caching = this._model.getCache()) != null) {
                if (caching.booleanValue()) {
                    this._cmbCache.setSelectedItem(CACHE);
                } else {
                    this._cmbCache.setSelectedItem(NOCACHE);
                }
            } else {
                this._cmbCache.setSelectedItem(null);
            }
            Boolean newVals = this._model.getNewValues();
            if (newVals != null) {
                if (newVals.booleanValue()) {
                    this._cmbNewValues.setSelectedItem(INCLUDING);
                } else {
                    this._cmbNewValues.setSelectedItem(EXCLUDING);
                }
            } else {
                this._cmbNewValues.setSelectedItem(null);
            }
            Boolean pkLogged = this._model.getPrimaryKeyLogged();
            if (pkLogged != null) {
                if (pkLogged.booleanValue()) {
                    this._cmbPK.setSelectedItem(UIArb.getString(444));
                } else {
                    this._cmbPK.setSelectedItem(UIArb.getString(792));
                }
            } else {
                this._cmbPK.setSelectedItem(null);
            }
            Boolean rowid = this._model.getRowidLogged();
            if (rowid != null) {
                if (rowid.booleanValue()) {
                    this._cmbROWID.setSelectedItem(UIArb.getString(444));
                } else {
                    this._cmbROWID.setSelectedItem(UIArb.getString(792));
                }
            } else {
                this._cmbROWID.setSelectedItem(null);
            }
            Boolean seq = this._model.getSequenceLogged();
            if (seq != null) {
                if (seq.booleanValue()) {
                    this._cmbSequence.setSelectedItem(UIArb.getString(444));
                } else {
                    this._cmbSequence.setSelectedItem(UIArb.getString(792));
                }
            } else {
                this._cmbSequence.setSelectedItem(null);
            }
            if (this._model.getParallel() == 0) {
                this._parallelValue.setText("");
                this._parallelValue.setEnabled(true);
                this._cbxParallel.setSelected(true);
            } else if (this._model.getParallel() <= 1) {
                this._parallelValue.setText("");
                this._parallelValue.setEnabled(false);
                this._cbxParallel.setSelected(false);
            } else {
                this._parallelValue.setText(String.valueOf(this._model.getParallel()));
                this._parallelValue.setEnabled(true);
                this._cbxParallel.setSelected(true);
            }
            Table tab = null;
            if (this._model.getMasterTableID() != null) {
                try {
                    tab = (Table)this._model.getMasterTableID().resolveID();
                }
                catch (DBException dbe) {
                    tab = null;
                }
            }
            boolean tabNotIOT = true;
            if (tab != null) {
                Object type = tab.getProperty("TableType");
                tabNotIOT = type != Table.TableType.INDEX_ORGANIZED;
                this._cmbROWID.setEnabled(tabNotIOT);
                this.setupColShuttle();
            }
            if (this._verifier != null) {
                this._cmbROWID.setEnabled(this._verifier.canChangeRowID(this._model.getRowidLogged()) && tabNotIOT);
                this._cmbPK.setEnabled(this._verifier.canChangePK(this._model.getPrimaryKeyLogged()));
                this._cmbSequence.setEnabled(this._verifier.canChangeSequence(this._model.getSequenceLogged()));
            }
            this._firstInit = false;
            this._lastSchema = this._model.getSchema();
            this._lastMasterTableID = this._model.getMasterTableID();
        } else if (this._lastMasterTableID != null && !this._lastMasterTableID.equals(this._model.getMasterTableID()) || this._lastSchema != this._model.getSchema()) {
            this._lastSchema = this._model.getSchema();
            this.schemaObjectUpdated(null);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit((MaterializedViewLog)dataContext.find("NewObject"), (Schema[])dataContext.find("SchemaList"), dataContext.getDirection() != 2, dataContext);
        if (this.m_listening) {
            this._model.removeObjectListener((SchemaObjectListener)this);
            this.m_listening = false;
        }
    }

    protected void commit(MaterializedViewLog mviewlog, Schema[] schema, boolean isForward, TraversableContext dataContext) throws TraversalException {
        if (this._model.getMasterTableID() == null) {
            throw new TraversalException(UIArb.getString(711));
        }
        this._model.setCache(this.getBooleanValue(this._cmbCache, CACHE));
        this._model.setNewValues(this.getBooleanValue(this._cmbNewValues, INCLUDING));
        this._model.setPrimaryKeyLogged(this.getBooleanValueYesNo(this._cmbPK));
        this._model.setRowidLogged(this.getBooleanValueYesNo(this._cmbROWID));
        this._model.setSequenceLogged(this.getBooleanValueYesNo(this._cmbSequence));
        if (this._cbxParallel.isSelected()) {
            if (ModelUtil.hasLength((String)this._parallelValue.getText())) {
                this._model.setParallel(Integer.parseInt(this._parallelValue.getText()));
            } else {
                this._model.setParallel(0);
            }
        } else {
            this._model.setParallel(1);
        }
        Table tab = null;
        try {
            tab = (Table)this._model.getMasterTableID().resolveID();
        }
        catch (DBException e) {
            // empty catch block
        }
        ArrayList<DBObjectID> colIDs = new ArrayList<DBObjectID>();
        if (this._lstSel.getModel().getSize() > 0) {
            ListModel model = this._lstSel.getModel();
            int count = model.getSize();
            int i = 0;
            while (i < count) {
                colIDs.add(tab.getColumn((String)model.getElementAt(i)).getID());
                ++i;
            }
        }
        this._model.setColumnIDs(colIDs.toArray(new DBObjectID[colIDs.size()]));
    }

    private void setupColShuttle() {
        Column[] cols;
        DefaultListModel _availModel = new DefaultListModel();
        DefaultListModel<String> _selModel = new DefaultListModel<String>();
        ArrayList<String> availableCols = new ArrayList<String>();
        Table masterTab = null;
        try {
            masterTab = (Table)this._prov.getObject("TABLE", this._model.getSchema(), this._model.getName());
        }
        catch (DBException e) {
            // empty catch block
        }
        if (masterTab == null) {
            try {
                masterTab = (Table)this._prov.getObject("MATERIALIZED VIEW", this._model.getSchema(), this._model.getName());
            }
            catch (DBException e) {
                // empty catch block
            }
        }
        if (masterTab != null && (cols = masterTab.getColumns()).length > 0) {
            int i = 0;
            while (i < cols.length) {
                availableCols.add(cols[i].getName());
                ++i;
            }
            Constraint[] cons = masterTab.getConstraints();
            PKConstraint pk = null;
            i = 0;
            while (i < cons.length) {
                if (cons[i].getConstraintType().equals("PKConstraint")) {
                    pk = (PKConstraint)cons[i];
                    break;
                }
                ++i;
            }
            if (pk != null) {
                Column[] pkCols = pk.getColumns();
                i = 0;
                while (i < pkCols.length) {
                    availableCols.remove(pkCols[i].getName());
                    ++i;
                }
            }
            DBObjectID[] selColIDs = this._model.getColumnIDs();
            i = 0;
            while (i < selColIDs.length) {
                String colName = DBUtil.getDBObjectName((DBObjectID)selColIDs[i]);
                availableCols.remove(colName);
                _selModel.addElement(colName);
                ++i;
            }
            i = 0;
            while (i < availableCols.size()) {
                _availModel.addElement(availableCols.get(i));
                ++i;
            }
            this._lstAvail.setModel(_availModel);
            this._lstSel.setModel(_selModel);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._storageButton) {
            OracleStorageProperties osp = (OracleStorageProperties)this._model.getProperty("OracleStorageProperties");
            if ((osp = StorageInfoPanel.edit(osp, StorageInfoPanel.StorageInfoFor.MATERIALIZED_VIEW_LOG, this._prov, (DBObject)this._model, null, this.m_siVerifier, this.m_tablespaces, (Component)((Object)this))) != null) {
                this._model.setProperty("OracleStorageProperties", (Object)osp);
            } else {
                this._model.getProperties().remove("OracleStorageProperties");
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public void focusGained(FocusEvent fe) {
        int idx;
        JList list;
        Object src = fe.getSource();
        if (src instanceof JList && (list = (JList)src).getSelectedIndex() == -1 && (idx = list.getFirstVisibleIndex()) != -1) {
            list.setSelectedIndex(idx);
        }
    }

    public void focusLost(FocusEvent fe) {
    }

    private void _cmbMasterTable_actionPerformed(ActionEvent e) {
    }

    private void _cbxParallel_actionPerformed(ActionEvent e) {
        if (this._cbxParallel.isSelected()) {
            this._parallelValue.setEnabled(true);
        } else {
            this._parallelValue.setText("");
            this._parallelValue.setEnabled(false);
        }
    }

    private Boolean getBooleanValue(JComboBox cmb, String trueVal) {
        String selectedVal = (String)cmb.getSelectedItem();
        if (selectedVal == null) {
            return null;
        }
        return selectedVal.equals(trueVal);
    }

    private Boolean getBooleanValueYesNo(JComboBox cmb) {
        return this.getBooleanValue(cmb, UIArb.getString(444));
    }

    public void schemaObjectUpdated(DBObjectChange change) {
        this._lastMasterTableID = this._model.getMasterTableID();
        this._model.setColumnIDs(new DBObjectID[0]);
        this._cmbROWID.setSelectedItem(null);
        this._lstAvail.setModel(new DefaultListModel());
        this._lstSel.setModel(new DefaultListModel());
        Table tab = null;
        try {
            tab = (Table)this._prov.getObject("TABLE", this._model.getSchema(), this._model.getName());
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (tab == null) {
            try {
                tab = (Table)this._prov.getObject("MATERIALIZED VIEW", this._model.getSchema(), this._model.getName());
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        if (tab != null) {
            Object type = tab.getProperty("TableType");
            this._cmbROWID.setEnabled(type != Table.TableType.INDEX_ORGANIZED);
        }
        this.setupColShuttle();
    }

    static void mav$_cbxParallel_actionPerformed(MViewLogPanel mViewLogPanel, ActionEvent actionEvent) {
        mViewLogPanel._cbxParallel_actionPerformed(actionEvent);
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MViewLogPanel.mav$_cbxParallel_actionPerformed(MViewLogPanel.this, e);
        }
    }

    final class 2
    extends KeyAdapter {
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                MViewLogPanel.this.getToolkit().beep();
                e.consume();
            }
        }
    }

    private class MVLListPicker
    extends ListPicker {
        private ArrayList<String> m_origColNameList;

        public MVLListPicker(JList list) {
            super(list);
            this.$init$();
        }

        public boolean isSelectableItemPresent() {
            return this.getAllSelectableItems().length > 0;
        }

        public Transferable[] getSelectedItems() {
            ArrayList<Transferable> trans = new ArrayList<Transferable>();
            Object[] selected = this.getList().getSelectedValues();
            if (selected != null) {
                int i = 0;
                while (i < selected.length) {
                    if (!this.nameInOriginalColumnList((String)selected[i])) {
                        trans.add(this.createTransferable(selected[i]));
                    }
                    ++i;
                }
                return trans.toArray(new Transferable[trans.size()]);
            }
            return null;
        }

        public Transferable[] getAllSelectableItems() {
            ArrayList<Transferable> trans = new ArrayList<Transferable>();
            int i = 0;
            while (i < this.getList().getModel().getSize()) {
                String colName = (String)this.getList().getModel().getElementAt(i);
                if (!this.nameInOriginalColumnList(colName)) {
                    trans.add(this.createTransferable(colName));
                }
                ++i;
            }
            return trans.toArray(new Transferable[trans.size()]);
        }

        public void removeAllSelectableItems() {
            int i = this.getList().getModel().getSize() - 1;
            while (i >= 0) {
                String colName = (String)this.getList().getModel().getElementAt(i);
                if (!this.nameInOriginalColumnList(colName)) {
                    ((DefaultListModel)this.getList().getModel()).removeElementAt(i);
                }
                --i;
            }
        }

        public void removeSelectedItems() {
            ListModel model = this.getList().getModel();
            if (!(model instanceof DefaultListModel)) {
                return;
            }
            DefaultListModel dModel = (DefaultListModel)model;
            ListSelectionModel sModel = this.getList().getSelectionModel();
            int[] selection = this.getList().getSelectedIndices();
            int i = selection.length;
            this.getList().setModel(new DefaultListModel());
            --i;
            while (i >= 0) {
                String colName = (String)dModel.getElementAt(selection[i]);
                if (!this.nameInOriginalColumnList(colName)) {
                    dModel.remove(selection[i]);
                }
                --i;
            }
            this.getList().setModel(dModel);
            int modelSize = dModel.getSize();
            int selLen = selection.length;
            if (modelSize > 0 && selLen > 0) {
                int highlight = selection[selLen - 1] - (selLen - 1);
                if (highlight >= modelSize) {
                    highlight = modelSize - 1;
                }
                sModel.setSelectionInterval(highlight, highlight);
                this.getList().ensureIndexIsVisible(highlight);
            }
        }

        private void $init$() {
            this.m_origColNameList = null;
        }

        private boolean nameInOriginalColumnList(String name) {
            if (this.m_origColNameList == null) {
                this.m_origColNameList = new ArrayList();
                if (MViewLogPanel.this._orig != null && MViewLogPanel.this._prov instanceof Database) {
                    int j = 0;
                    while (j < MViewLogPanel.this._orig.getColumnIDs().length) {
                        String colname = DBUtil.getDBObjectName((DBObjectID)MViewLogPanel.this._orig.getColumnIDs()[j]);
                        this.m_origColNameList.add(colname);
                        ++j;
                    }
                }
            }
            return this.m_origColNameList.contains(name);
        }
    }
}

