/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.mview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaObjectComboBox;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.DBTraversablePanel;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.MaterializedViewLogBuilder;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class MViewLogHeader
extends DBTraversablePanel
implements ActionListener {
    private List<PanelLibrary.HeaderPanelListener> m_list;
    private final SchemaPicker m_cmbOwner;
    private SchemaObjectComboBox m_cmbMasterTable;
    private boolean m_create;
    private boolean m_firstInit;
    private boolean m_listening;
    private SchemaObject m_originalObject;
    private Schema[] m_schemas;
    private MaterializedViewLog m_schemaObject;
    private DBObjectProvider m_pro;
    private SchemaObjectInfoVerifier m_verifier;
    private HashMap m_tableNameAndIdHash;
    private DBUIResourceHelper m_resHelper;

    private void $init$() {
        this.m_list = new ArrayList<PanelLibrary.HeaderPanelListener>();
        this.m_cmbOwner = new SchemaPicker();
        this.m_cmbMasterTable = new SchemaObjectComboBox();
        this.m_create = true;
        this.m_firstInit = true;
        this.m_schemaObject = null;
        this.m_verifier = null;
        this.m_tableNameAndIdHash = new HashMap();
        this.m_resHelper = new DBUIResourceHelper("MViewLogHeader");
    }

    public MViewLogHeader() {
        this.$init$();
        this.buildPanel((JPanel)((Object)this));
    }

    private void buildPanel(JPanel pnlInfo) {
        pnlInfo.setLayout(new GridBagLayout());
        JLabel lblOwner = new JLabel();
        this.m_cmbOwner.addActionListener(this);
        this.m_resHelper.resLabel(lblOwner, this.m_cmbOwner, UIArb.getString(474), "_cmbOwner");
        pnlInfo.add((Component)lblOwner, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        pnlInfo.add((Component)this.m_cmbOwner, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblName = new JLabel();
        this.m_cmbMasterTable.addActionListener(this);
        this.m_resHelper.resLabel(lblName, this.m_cmbMasterTable, UIArb.getString(807), "_cmbMasterTable");
        pnlInfo.add((Component)lblName, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15), 0, 0));
        pnlInfo.add((Component)this.m_cmbMasterTable, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        pnlInfo.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private Schema[] validateSchemaPermissions(Schema[] schemas) {
        if (this.m_pro instanceof Database) {
            ArrayList<Schema> retval = new ArrayList<Schema>();
            String type = this.m_schemaObject.getType();
            int i = 0;
            while (i < schemas.length) {
                if (this.m_pro.hasPriviledge(type, schemas[i], this.isEditing() ? "MODIFY" : "CREATE")) {
                    retval.add(schemas[i]);
                }
                ++i;
            }
            return retval.toArray(new Schema[retval.size()]);
        }
        return schemas;
    }

    protected SchemaObjectInfoVerifier getVerifier() {
        return this.m_verifier;
    }

    protected SchemaPicker getSchemaPicker() {
        return this.m_cmbOwner;
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected SchemaObject getSchemaObject() {
        return this.m_schemaObject;
    }

    protected boolean isEditing() {
        return this.m_originalObject != null;
    }

    protected void init(SchemaObject obj, SchemaObject origObj, SchemaObjectInfoVerifier verifier, DBObjectProvider pro, Schema[] schemas) {
        this.m_originalObject = origObj;
        this.m_pro = pro;
        this.m_schemaObject = (MaterializedViewLog)obj;
        this.m_schemas = schemas;
        this.m_verifier = verifier;
        boolean bl = this.m_create = origObj == null;
        if (this.m_create) {
            this.m_cmbOwner.init(this.m_pro, obj.getSchema(), this.validateSchemaPermissions(this.m_schemas));
        } else {
            Schema[] thisSchema = new Schema[]{this.m_schemaObject.getSchema()};
            this.m_cmbOwner.init(this.m_pro, obj.getSchema(), thisSchema);
        }
        this.setupMasterTable();
        this.m_cmbOwner.setEditable(false);
        this.m_cmbMasterTable.setEditable(false);
        if (this.m_cmbMasterTable.getModel().getSize() != 0) {
            try {
                this.commit();
            }
            catch (TraversalException e) {
                // empty catch block
            }
        }
        this.m_listening = true;
        this.m_firstInit = false;
    }

    public void commit() throws TraversalException {
        String name;
        this.m_listening = false;
        Schema oldSchema = this.m_schemaObject.getSchema();
        Schema schema = this.m_cmbOwner.getSchema();
        String oldName = this.m_schemaObject.getName();
        SchemaObjectDescriptor sod = (SchemaObjectDescriptor)this.m_cmbMasterTable.getSelectedItem();
        String string = name = sod == null ? null : sod.getName();
        if (oldSchema != schema) {
            HashMap<String, PropertyChangeEvent> props = new HashMap<String, PropertyChangeEvent>(2);
            this.m_schemaObject.setSchema(schema);
            PropertyChangeEvent spce = new PropertyChangeEvent(this.m_schemaObject, "schema", oldSchema, schema);
            props.put(spce.getPropertyName(), spce);
            this.setupMasterTable();
            sod = (SchemaObjectDescriptor)this.m_cmbMasterTable.getSelectedItem();
            if (sod != null) {
                name = sod.getName();
                this.m_schemaObject.setName(name);
                this.m_schemaObject.setMasterTableID((DBObjectID)this.m_tableNameAndIdHash.get(name));
                name = ((SchemaObjectDescriptor)this.m_cmbMasterTable.getSelectedItem()).getName();
                PropertyChangeEvent npce = new PropertyChangeEvent(this.m_schemaObject, "name", oldName, name);
                props.put(npce.getPropertyName(), npce);
            }
            DBObjectChange.firePropertiesChanged((SchemaObject)this.m_schemaObject, props);
        } else if (name != null && !name.equals(oldName)) {
            name = ((SchemaObjectDescriptor)this.m_cmbMasterTable.getSelectedItem()).getName();
            this.m_schemaObject.setName(name);
            this.m_schemaObject.setMasterTableID((DBObjectID)this.m_tableNameAndIdHash.get(name));
            DBObjectChange.firePropertyChanged((SchemaObject)this.m_schemaObject, (PropertyChangeEvent[])new PropertyChangeEvent[]{new PropertyChangeEvent(this.m_schemaObject, "name", oldName, name)});
        }
    }

    public void onEntry(TraversableContext data) {
        DBObjectProvider pro = (DBObjectProvider)data.get("DBObjectProvider");
        Schema[] schemas = (Schema[])data.get("SchemaList");
        SchemaObject obj = (SchemaObject)data.get("NewObject");
        SchemaObject origObj = (SchemaObject)data.get("OriginalObject");
        if (this.m_firstInit) {
            this.init(obj, origObj, null, pro, schemas);
        }
        this.m_listening = true;
        boolean isEditable = (Boolean)data.find("DBObjectIsEditable");
        if (!isEditable) {
            this.m_cmbOwner.setEnabled(false);
            this.m_cmbMasterTable.setEnabled(false);
        }
    }

    public void onExit(TraversableContext data) throws TraversalException {
        this.commit();
    }

    public Component getDefaultFocusComponent() {
        return this.m_cmbMasterTable;
    }

    public void actionPerformed(ActionEvent ev) {
        if (this.m_listening) {
            try {
                this.commit();
            }
            catch (TraversalException traversalException) {
                // empty catch block
            }
            this.m_listening = true;
        }
    }

    public final void addHeaderPanelListener(PanelLibrary.HeaderPanelListener list) {
        this.m_list.add(list);
    }

    public final boolean removeHeaderPanelListener(PanelLibrary.HeaderPanelListener list) {
        return this.m_list.remove(list);
    }

    protected final void changePanels(String key, Navigable[] navs) throws TraversalException {
        for (PanelLibrary.HeaderPanelListener list : this.m_list) {
            list.panelSetChange(key, navs);
        }
    }

    private void setupMasterTable() {
        this.m_cmbMasterTable.removeAllItems();
        this.m_cmbMasterTable.setShowIcon(true);
        this.m_tableNameAndIdHash.clear();
        if (this.m_create) {
            this.m_schemaObject.setName(null);
            this.m_schemaObject.setMasterTableID(null);
            if (this.m_pro instanceof OracleDatabaseImpl) {
                QueryWrapper wrap = new QueryWrapper((Database)this.m_pro, MaterializedViewLogBuilder.getCandidateTablesQuery(), new Object[]{this.m_schemaObject.getSchema()});
                1 r = new 1(this, wrap);
                try {
                    wrap.executeQuery((QueryWrapper.QueryRunnable)r);
                }
                catch (DBException dbe) {
                    boolean debug = false;
                }
            } else {
                SchemaObject[] tables = null;
                String[] tabTypes = new String[]{"TABLE", "MATERIALIZED VIEW"};
                try {
                    tables = this.m_pro.listObjects(tabTypes, this.m_schemaObject.getSchema());
                }
                catch (DBException e) {
                    // empty catch block
                }
                SchemaObject[] mvls = null;
                String[] mvlType = new String[]{"MATERIALIZED VIEW LOG"};
                try {
                    mvls = this.m_pro.listObjects(mvlType, this.m_schemaObject.getSchema());
                }
                catch (DBException e) {
                    // empty catch block
                }
                int tabLoop = 0;
                while (tabLoop < tables.length) {
                    int mvlLoop = 0;
                    while (mvlLoop < mvls.length) {
                        if (tables[tabLoop].getID().equals(((MaterializedViewLog)mvls[mvlLoop]).getMasterTableID())) {
                            tables[tabLoop] = null;
                            break;
                        }
                        ++mvlLoop;
                    }
                    ++tabLoop;
                }
                int tabLoop2 = 0;
                while (tabLoop2 < tables.length) {
                    Object type;
                    Table tab;
                    if (tables[tabLoop2] != null && (tab = (Table)tables[tabLoop2]) != null && (type = tab.getProperty("TableType")) != Table.TableType.TRANSACTION_TEMP && type != Table.TableType.SESSION_TEMP && type != Table.TableType.EXTERNAL) {
                        SchemaObjectDescriptor sod = new SchemaObjectDescriptor(tab.getName(), tab.getType(), this.m_schemaObject.getSchema().getName());
                        this.m_cmbMasterTable.addItem(sod);
                        this.m_tableNameAndIdHash.put(tab.getName(), tab.getID());
                        if (this.m_schemaObject.getMasterTableID() == null) {
                            this.m_schemaObject.setMasterTableID(tab.getID());
                        }
                    }
                    ++tabLoop2;
                }
            }
            if (this.m_cmbMasterTable.getSelectedItem() != null) {
                this.m_schemaObject.setMasterTableID(null);
            }
        } else {
            DBObject tab = null;
            try {
                tab = this.m_schemaObject.getMasterTableID().resolveID();
            }
            catch (DBException e) {
                // empty catch block
            }
            if (tab != null) {
                SchemaObjectDescriptor sod = new SchemaObjectDescriptor(tab.getName(), tab.getType(), this.m_schemaObject.getSchema().getName());
                this.m_cmbMasterTable.addItem(sod);
            }
        }
    }

    static DBObjectProvider ra$m_pro(MViewLogHeader mViewLogHeader) {
        return mViewLogHeader.m_pro;
    }

    static MaterializedViewLog ra$m_schemaObject(MViewLogHeader mViewLogHeader) {
        return mViewLogHeader.m_schemaObject;
    }

    static SchemaObjectComboBox ra$m_cmbMasterTable(MViewLogHeader mViewLogHeader) {
        return mViewLogHeader.m_cmbMasterTable;
    }

    static HashMap ra$m_tableNameAndIdHash(MViewLogHeader mViewLogHeader) {
        return mViewLogHeader.m_tableNameAndIdHash;
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ MViewLogHeader this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    DBObjectID tableID = ((OracleDatabaseImpl)MViewLogHeader.ra$m_pro(this.this$0)).createID(MViewLogHeader.ra$m_schemaObject(this.this$0).getSchema(), rs.getString(1), rs.getString(2), (Object)rs.getString(3));
                    SchemaObjectDescriptor sod = new SchemaObjectDescriptor(rs.getString(1), rs.getString(2), MViewLogHeader.ra$m_schemaObject(this.this$0).getSchema().getName());
                    MViewLogHeader.ra$m_cmbMasterTable(this.this$0).addItem(sod);
                    MViewLogHeader.ra$m_tableNameAndIdHash(this.this$0).put(rs.getString(1), tableID);
                    if (MViewLogHeader.ra$m_schemaObject(this.this$0).getMasterTableID() != null) continue;
                    MViewLogHeader.ra$m_schemaObject(this.this$0).setMasterTableID(tableID);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException(ex);
            }
        }

        public 1(MViewLogHeader mViewLogHeader, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.this$0 = mViewLogHeader;
        }
    }
}

