/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaObjectComboBox;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateObjectsPanel
extends DefaultTraversablePanel
implements ListSelectionListener,
ActionListener,
ListCellRenderer {
    private DefaultListModel m_typeModel;
    private JScrollPane m_scrTypes;
    private JList m_typeList;
    private JLabel m_schemaLabel;
    private SchemaPicker m_templateSchemas;
    private JLabel m_templateLabel;
    private SchemaObjectComboBox m_templateObjects;
    private JCheckBox m_makeDefault;
    private HashMap<String, SchemaObject> m_defaultTemplates;
    private HashMap<String, Schema[]> m_availableSchemas;
    private DBObjectProvider m_pro;
    private int m_lastTypeIndex;
    private boolean m_pickOneMode;
    private boolean m_initialised;
    private DefaultListCellRenderer m_delegateLCR;
    private DBUIResourceHelper m_resHelper;

    private void $init$() {
        this.m_typeModel = new DefaultListModel();
        this.m_scrTypes = new JScrollPane();
        this.m_typeList = new JList(this.m_typeModel);
        this.m_schemaLabel = new JLabel();
        this.m_templateSchemas = new SchemaPicker(true);
        this.m_templateLabel = new JLabel();
        this.m_templateObjects = new SchemaObjectComboBox();
        this.m_makeDefault = new JCheckBox();
        this.m_defaultTemplates = new HashMap();
        this.m_availableSchemas = new HashMap();
        this.m_lastTypeIndex = -1;
        this.m_pickOneMode = false;
        this.m_initialised = false;
        this.m_delegateLCR = new DefaultListCellRenderer();
        this.m_resHelper = new DBUIResourceHelper("TemplateObjectsPanel");
    }

    public TemplateObjectsPanel() {
        this.$init$();
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_typeList.getSelectionModel().addListSelectionListener(this);
        this.m_typeList.setCellRenderer(this);
        this.m_templateSchemas.addActionListener(this);
        this.m_resHelper.resLabel(this.m_schemaLabel, this.m_templateSchemas, UIArb.getString(474), "m_templateSchemas");
        this.m_resHelper.resLabel(this.m_templateLabel, this.m_templateObjects, UIArb.getString(364), "m_templateObjects");
        this.m_resHelper.resButton(this.m_makeDefault, UIArb.getString(374), "m_makeDefault");
        this.m_scrTypes.setVerticalScrollBarPolicy(20);
        this.m_typeList.setSelectionMode(0);
        this.m_scrTypes.getViewport().add((Component)this.m_typeList, null);
        int y = 1;
        this.add(this.m_scrTypes, this.gbc(1, ++y, 1, 4, 0.0, 1.0, 18, 3, new Insets(10, 0, 0, 0)));
        this.add(this.m_schemaLabel, this.gbc(2, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0)));
        this.add(this.m_templateSchemas, this.gbc(3, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0)));
        this.add(this.m_templateLabel, this.gbc(2, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0)));
        this.add(this.m_templateObjects, this.gbc(3, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0)));
        this.add(this.m_makeDefault, this.gbc(3, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0)));
        this.add(Box.createVerticalGlue(), this.gbc(2, ++y, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0)));
    }

    public void init(DBObjectProvider pro, HashMap<String, SchemaObject> map, boolean pickOneMode) {
        if (!this.m_initialised) {
            this.m_pro = pro;
            this.m_defaultTemplates = map;
            this.m_pickOneMode = pickOneMode;
            if (!pickOneMode || pro instanceof Database) {
                this.m_makeDefault.setVisible(false);
            }
            try {
                Object[] types = new String[map.size()];
                int i = 0;
                for (String type : map.keySet()) {
                    types[i++] = type;
                }
                Arrays.sort(types);
                Object[] objectArray = types;
                int n = 0;
                while (n < objectArray.length) {
                    Object type = objectArray[n];
                    this.m_typeModel.addElement(type);
                    ArrayList<Schema> schemas = new ArrayList<Schema>();
                    Schema[] schemaArray = pro.listSchemas();
                    int n2 = 0;
                    while (n2 < schemaArray.length) {
                        Schema s = schemaArray[n2];
                        String[] stringArray = pro.listObjects((String)type, s);
                        int n3 = 0;
                        if (n3 < stringArray.length) {
                            String name = stringArray[n3];
                            schemas.add(s);
                        }
                        ++n2;
                    }
                    this.m_availableSchemas.put((String)type, schemas.toArray(new Schema[schemas.size()]));
                    ++n;
                }
            }
            catch (DBException e) {
                // empty catch block
            }
            this.m_initialised = true;
            this.m_typeList.setSelectedIndex(0);
            this.m_lastTypeIndex = 0;
            this.typeChange();
        }
    }

    public HashMap<String, SchemaObject> commit() {
        if (this.m_lastTypeIndex != -1) {
            String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
            this.m_defaultTemplates.put(type, this.m_templateObjects.getSchemaObject());
        }
        if (this.m_pickOneMode) {
            SchemaObject so = this.m_templateObjects.getSchemaObject();
            String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
            this.m_defaultTemplates.clear();
            this.m_defaultTemplates.put(type, so);
            if (!(this.m_pro instanceof Database) && this.m_makeDefault.isSelected()) {
                this.m_pro.setDefaultTemplateForType(type, so);
            }
        }
        return this.m_defaultTemplates;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            if (this.m_lastTypeIndex != -1) {
                String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
                this.m_defaultTemplates.put(type, this.m_templateObjects.getSchemaObject());
            }
            this.m_lastTypeIndex = ((ListSelectionModel)e.getSource()).getMinSelectionIndex();
            this.typeChange();
        }
    }

    private void typeChange() {
        String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
        Schema[] schemas = this.m_availableSchemas.get(type);
        SchemaObject template = this.m_defaultTemplates.get(type);
        Schema schema = null;
        if (template != null) {
            schema = template.getSchema();
        } else if (schemas != null && schemas.length > 0) {
            schema = schemas[0];
        }
        this.m_templateSchemas.init(this.m_pro, schema, schemas);
        this.m_templateSchemas.setSelectedItem(schema);
        this.m_templateObjects.init(this.m_pro, schema, true, type);
        int numberOfObjects = this.m_templateObjects.getModel().getSize();
        if (this.m_pickOneMode && template == null && numberOfObjects > 1) {
            this.m_templateObjects.setSelectedIndex(1);
        } else {
            this.m_templateObjects.setSchemaObject(template);
        }
        this.m_templateSchemas.setEnabled(this.m_templateSchemas.getModel().getSize() > 1);
        this.m_templateObjects.setEnabled(numberOfObjects > 1);
        this.m_makeDefault.setEnabled(numberOfObjects > 1);
        this.m_makeDefault.setSelected(false);
        String checkBoxLabel = UIArb.format(374, DBTypeDisplayRegistry.getDisplayName(type));
        this.m_resHelper.resButton(this.m_makeDefault, checkBoxLabel, "m_makeDefault");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_templateSchemas && this.m_lastTypeIndex != -1) {
            Schema schema = null;
            try {
                schema = this.m_templateSchemas.getSchema();
            }
            catch (TraversalException traversalException) {
                // empty catch block
            }
            String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
            this.m_templateSchemas.setSelectedItem(schema);
            this.m_templateObjects.init(this.m_pro, schema, true, type);
            int numberOfObjects = this.m_templateObjects.getModel().getSize();
            if (numberOfObjects == 1) {
                this.m_templateObjects.setSelectedIndex(0);
                this.m_templateObjects.setEnabled(false);
            } else {
                this.m_templateObjects.setSelectedIndex(1);
                this.m_templateObjects.setEnabled(true);
            }
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String type = (String)value;
        type = this.m_pickOneMode ? DBTypeDisplayRegistry.getSingularDisplayName(type) : DBTypeDisplayRegistry.getDisplayName(type);
        JLabel label = (JLabel)this.m_delegateLCR.getListCellRendererComponent((JList<?>)list, type, index, isSelected, cellHasFocus);
        label.setIcon(DBTypeDisplayRegistry.getNodeIcon((String)value));
        return label;
    }
}

