/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.DatabaseLinkInfoVerifier;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;

public class DatabaseLinkPanel
extends DefaultTraversablePanel
implements ActionListener {
    public static final String TABLESPACES_KEY = "Tablespaces";
    public static final String PUBLIC = "PUBLIC";
    private JLabel serviceNameLabel;
    private JTextArea serviceNameTextArea;
    private JRadioButton currentUserRadioBtn;
    private JRadioButton fixedUserRadioBtn;
    private JLabel fixedUserNameLabel;
    private JLabel fixedUserPasswordLabel;
    private JTextField userNameTextField;
    private JPasswordField passwordField;
    private JCheckBox sharedCheckBox;
    private JLabel authenUserNameLabel;
    private JLabel authenPasswordLabel;
    private JTextField authenTextFeild;
    private JPasswordField authenPasswordField;
    private JLabel jLabel1;
    private ButtonGroup userTypeButtonGroup;
    private HashMap m_loadingSchemas;
    private static final String[] DATABASELINK_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "DATABASE LINK"};
    private static final String ACMD_FIXEDUSER = "FixedUser";
    private static final String ACMD_SHARED = "Shared";
    protected DBObjectProvider m_prov;
    protected DatabaseLink m_dblink;
    protected Schema m_forSchema;
    protected String m_savedName;
    private JComboBox m_cmbObject;
    private static final DefaultComboBoxModel EMPTY_MDL_OBJECT = new NonNullableComboBoxModel();
    private Map m_schemaMap;
    private DatabaseLinkInfoVerifier m_verifier;
    private boolean m_isInit;
    private static final String DBLINK_CONNECT_STRING = UIArb.getString(622);
    private static final String DBLINK_HOST_NAME_TOOLTIP = UIArb.getString(187);
    private static final String DBLINK_CURRENT_USER = UIArb.getString(595);
    private static final String DBLINK_CURRENT_USER_TOOLTIP = UIArb.getString(510);
    private static final String DBLINK_FIXED_USER = UIArb.getString(455);
    private static final String DBLINK_FIXED_USER_TOOLTIP = UIArb.getString(487);
    private static final String DBLINK_FIXED_USER_NAME = UIArb.getString(267);
    private static final String DBLINK_FIXED_USER_PW = UIArb.getString(363);
    private static final String DBLINK_AUTHEN_USER_NAME = UIArb.getString(673);
    private static final String DBLINK_AUTHEN_USER_PW = UIArb.getString(115);
    private static final String DBLINK_SHARED = UIArb.getString(270);
    private static final String DBLINK_CONNECT_TO = UIArb.getString(485);

    private void $init$() {
        this.serviceNameLabel = new JLabel();
        this.serviceNameTextArea = new JTextArea();
        this.currentUserRadioBtn = new JRadioButton();
        this.fixedUserRadioBtn = new JRadioButton();
        this.fixedUserNameLabel = new JLabel();
        this.fixedUserPasswordLabel = new JLabel();
        this.userNameTextField = new JTextField();
        this.passwordField = new JPasswordField();
        this.sharedCheckBox = new JCheckBox();
        this.authenUserNameLabel = new JLabel();
        this.authenPasswordLabel = new JLabel();
        this.authenTextFeild = new JTextField();
        this.authenPasswordField = new JPasswordField();
        this.jLabel1 = new JLabel();
        this.userTypeButtonGroup = new ButtonGroup();
        this.m_loadingSchemas = new HashMap();
        this.m_prov = null;
        this.m_dblink = null;
        this.m_forSchema = null;
        this.m_savedName = null;
        this.m_cmbObject = new JComboBox();
        this.m_schemaMap = new HashMap();
        this.m_isInit = false;
    }

    public DatabaseLinkPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.userTypeButtonGroup.add(this.fixedUserRadioBtn);
        this.userTypeButtonGroup.add(this.currentUserRadioBtn);
        this.jLabel1.setText(DBLINK_CONNECT_TO);
        ResourceUtils.resLabel((JLabel)this.serviceNameLabel, (Component)this.serviceNameTextArea, (String)DBLINK_CONNECT_STRING);
        ResourceUtils.resLabel((JLabel)this.fixedUserNameLabel, (Component)this.userNameTextField, (String)DBLINK_FIXED_USER_NAME);
        ResourceUtils.resLabel((JLabel)this.fixedUserPasswordLabel, (Component)this.passwordField, (String)DBLINK_FIXED_USER_PW);
        ResourceUtils.resLabel((JLabel)this.authenUserNameLabel, (Component)this.authenTextFeild, (String)DBLINK_AUTHEN_USER_NAME);
        ResourceUtils.resLabel((JLabel)this.authenPasswordLabel, (Component)this.authenPasswordField, (String)DBLINK_AUTHEN_USER_PW);
        ResourceUtils.resButton((AbstractButton)this.fixedUserRadioBtn, (String)DBLINK_FIXED_USER);
        ResourceUtils.resButton((AbstractButton)this.currentUserRadioBtn, (String)DBLINK_CURRENT_USER);
        ResourceUtils.resButton((AbstractButton)this.sharedCheckBox, (String)DBLINK_SHARED);
        this.add(this.serviceNameLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.serviceNameTextArea, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 6, 0, 0), 0, 0));
        this.add(this.fixedUserRadioBtn, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.add(this.fixedUserNameLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 12, 0, 0), 0, 0));
        this.add(this.userNameTextField, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.add(this.fixedUserPasswordLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 12, 0, 0), 0, 0));
        this.add(this.passwordField, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.add(this.currentUserRadioBtn, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 18, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.add(this.sharedCheckBox, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 18, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.add(this.authenUserNameLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 12, 0, 0), 0, 0));
        this.add(this.authenTextFeild, new GridBagConstraints(2, 7, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.add(this.authenPasswordLabel, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 12, 0, 0), 0, 0));
        this.add(this.authenPasswordField, new GridBagConstraints(2, 8, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.serviceNameLabel.setToolTipText(DBLINK_HOST_NAME_TOOLTIP);
        this.currentUserRadioBtn.setToolTipText(DBLINK_CURRENT_USER_TOOLTIP);
        this.fixedUserRadioBtn.setToolTipText(DBLINK_FIXED_USER_TOOLTIP);
        this.serviceNameTextArea.setLineWrap(true);
        this.serviceNameTextArea.setWrapStyleWord(true);
        this.currentUserRadioBtn.setActionCommand(ACMD_FIXEDUSER);
        this.currentUserRadioBtn.addActionListener(this);
        this.fixedUserRadioBtn.setActionCommand(ACMD_FIXEDUSER);
        this.fixedUserRadioBtn.addActionListener(this);
        this.sharedCheckBox.setActionCommand(ACMD_SHARED);
        this.sharedCheckBox.addActionListener(this);
    }

    private void currentUserRadioBtn_actionPerformed(ActionEvent e) {
    }

    private void fixedUserRadioBtn_actionPerformed(ActionEvent e) {
    }

    public String getHeaderTitle() {
        return UIArb.getString(770);
    }

    public String getHeaderDescription() {
        return UIArb.getString(87);
    }

    protected boolean isDangling(DBObjectID ref) {
        return false;
    }

    protected String getDanglingBlather() {
        return null;
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this.m_dblink = (DatabaseLink)dataContext.find("NewObject");
        boolean edit = dataContext.find("OriginalObject") != null;
        this.m_verifier = (DatabaseLinkInfoVerifier)dataContext.find("SchemaObjectInfoVerifier");
        Schema[] schemas = (Schema[])dataContext.find("SchemaList");
        this.init(this.m_dblink, this.m_verifier, schemas, edit);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.find("OriginalObject") == null) {
            DatabaseLink databaselink = (DatabaseLink)dataContext.find("NewObject");
            if (databaselink == null) {
                databaselink = new DatabaseLink();
            }
            Schema[] schemas = (Schema[])dataContext.find("SchemaList");
            this.commit(databaselink, schemas, dataContext.getDirection() != 2);
        }
    }

    private void init(DatabaseLink model, DatabaseLinkInfoVerifier verifier, Schema[] schemas, boolean edit) {
        if (this.m_isInit) {
            return;
        }
        this.m_isInit = true;
        if (!edit) {
            model.setCurrentUser(false);
            model.setShared(false);
            this.currentUserRadioBtn.setSelected(false);
            this.fixedUserRadioBtn.setSelected(true);
            this.sharedCheckBox.setSelected(false);
            this.userNameTextField.setText("");
            this.passwordField.setText("");
            this.authenTextFeild.setText("");
            this.authenPasswordField.setText("");
            this.authenUserNameLabel.setEnabled(false);
            this.authenPasswordLabel.setEnabled(false);
            this.authenTextFeild.setEnabled(false);
            this.authenPasswordField.setEnabled(false);
        } else {
            this.serviceNameTextArea.setText(model.getHost());
            this.userNameTextField.setText(model.getUsername());
            this.sharedCheckBox.setSelected(model.isShared());
            this.authenTextFeild.setText(model.getAuthentificationUser());
            this.currentUserRadioBtn.setSelected(model.isCurrentUser());
            this.fixedUserRadioBtn.setSelected(model.isCurrentUser() ^ true);
            this.fixedUserNameLabel.setEnabled(false);
            this.fixedUserPasswordLabel.setEnabled(false);
            this.userNameTextField.setEnabled(false);
            this.passwordField.setEnabled(false);
            this.serviceNameLabel.setEnabled(false);
            this.serviceNameTextArea.setEnabled(false);
            this.fixedUserNameLabel.setEnabled(false);
            this.userNameTextField.setEnabled(false);
            this.fixedUserPasswordLabel.setEnabled(false);
            this.passwordField.setEnabled(false);
            this.fixedUserRadioBtn.setEnabled(false);
            this.currentUserRadioBtn.setEnabled(false);
            this.sharedCheckBox.setEnabled(false);
            this.authenUserNameLabel.setEnabled(false);
            this.authenPasswordLabel.setEnabled(false);
            this.authenTextFeild.setEnabled(false);
            this.authenPasswordField.setEnabled(false);
        }
    }

    private void commit(DatabaseLink databaselink, Schema[] schemas, boolean forward) throws TraversalException {
        DatabaseLinkInfoVerifier verifier = this.m_verifier;
        if (forward && verifier != null) {
            verifier.verifyDblink();
        }
        databaselink.setHost(this.serviceNameTextArea.getText());
        if (this.currentUserRadioBtn.isSelected()) {
            databaselink.setCurrentUser(true);
            databaselink.setUsername(null);
            databaselink.setPassword(null);
        } else {
            databaselink.setCurrentUser(false);
            databaselink.setUsername(this.userNameTextField.getText());
            databaselink.setPassword(new String(this.passwordField.getPassword()));
        }
        if (this.sharedCheckBox.isSelected()) {
            databaselink.setShared(true);
            databaselink.setAuthentificationPassword(new String(this.authenPasswordField.getPassword()));
            databaselink.setAuthentificationUsername(this.authenTextFeild.getText());
        } else {
            databaselink.setShared(false);
            databaselink.setAuthentificationPassword(null);
            databaselink.setAuthentificationUsername(null);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (ACMD_FIXEDUSER.equals(e.getActionCommand())) {
            if (this.fixedUserRadioBtn.isSelected()) {
                this.userNameTextField.setEnabled(true);
                this.passwordField.setEnabled(true);
                this.fixedUserNameLabel.setEnabled(true);
                this.fixedUserPasswordLabel.setEnabled(true);
            } else {
                this.userNameTextField.setEnabled(false);
                this.passwordField.setEnabled(false);
                this.fixedUserNameLabel.setEnabled(false);
                this.fixedUserPasswordLabel.setEnabled(false);
            }
        } else if (ACMD_SHARED.equals(e.getActionCommand())) {
            if (this.sharedCheckBox.isSelected()) {
                this.authenUserNameLabel.setEnabled(true);
                this.authenPasswordLabel.setEnabled(true);
                this.authenTextFeild.setEnabled(true);
                this.authenPasswordField.setEnabled(true);
            } else {
                this.authenUserNameLabel.setEnabled(false);
                this.authenPasswordLabel.setEnabled(false);
                this.authenTextFeild.setEnabled(false);
                this.authenPasswordField.setEnabled(false);
            }
        }
    }

    private void getAllDblinkObjects(Schema refSchema) {
        try {
            SchemaObject[] objects = this.m_prov.listObjects(DATABASELINK_TYPES, refSchema);
            SchemaObject originalDblink = this.m_verifier.getOriginalObject();
            String originalDblinkName = originalDblink != null ? originalDblink.getName() : null;
            Schema originalSchema = originalDblink != null ? originalDblink.getSchema() : null;
            NonNullableComboBoxModel objectModel = new NonNullableComboBoxModel();
            int i = 0;
            while (i < objects.length) {
                if (!(originalDblink != null && "DATABASE LINK".equals(objects[i].getType()) && ModelUtil.areEqual((Object)originalSchema, (Object)refSchema) && ModelUtil.areEqual((Object)originalDblinkName, (Object)objects[i].getName()))) {
                    objectModel.addElement(objects[i].getName());
                }
                ++i;
            }
            this.m_schemaMap.put(refSchema.getName(), objectModel);
        }
        catch (DBException e) {
            // empty catch block
        }
    }

    private boolean setObjectModel(Schema refSchema) {
        DefaultComboBoxModel objectModel = null;
        if (this.m_verifier == null || this.m_verifier.canChangeReference()) {
            objectModel = (DefaultComboBoxModel)this.m_schemaMap.get(refSchema.getName());
        } else if (this.m_dblink != null) {
            objectModel = new NonNullableComboBoxModel();
        }
        this.m_cmbObject.setModel(objectModel != null ? objectModel : EMPTY_MDL_OBJECT);
        return objectModel != null;
    }

    private SchemaObject findObject(String name) {
        SchemaObject result = null;
        if (name != null) {
            int i = 0;
            while (i < DATABASELINK_TYPES.length) {
                try {
                    result = this.m_prov.getObject(DATABASELINK_TYPES[i], this.m_forSchema, name);
                    if (result != null) {
                        break;
                    }
                }
                catch (DBException e) {
                    // empty catch block
                }
                ++i;
            }
        }
        return result;
    }

    private boolean populateObjectField() {
        Schema refSchema = this.m_forSchema;
        if (!this.m_schemaMap.containsKey(refSchema.getName())) {
            this.loadObjectModel(refSchema);
        }
        return this.setObjectModel(refSchema);
    }

    protected void setForSchemaAndName(DBObjectID refID) {
        if (refID instanceof ReferenceID) {
            ReferenceID sRefID = (ReferenceID)refID;
            String schemaName = sRefID.getSchemaName();
            if (schemaName != null) {
                try {
                    Schema forSchema = this.m_prov.getSchema(schemaName);
                    this.m_forSchema = forSchema == null ? new Schema(schemaName) : forSchema;
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
            this.m_savedName = sRefID.getName();
        }
    }

    private void loadObjectModel(Schema refSchema) {
        if (!this.m_loadingSchemas.containsKey(refSchema.getName())) {
            ObjectModelLoader objectModelLoader = new ObjectModelLoader(refSchema);
            this.m_loadingSchemas.put(refSchema.getName(), objectModelLoader);
            objectModelLoader.execute();
        } else {
            ObjectModelLoader objectModelLoader = (ObjectModelLoader)this.m_loadingSchemas.get(refSchema.getName());
            if (objectModelLoader != null) {
                objectModelLoader.execute();
            }
        }
    }

    public String getTitle() {
        return UIArb.getString(397);
    }

    public String getProgressText() {
        return UIArb.getString(625);
    }

    static HashMap ra$m_loadingSchemas(DatabaseLinkPanel databaseLinkPanel) {
        return databaseLinkPanel.m_loadingSchemas;
    }

    static void mav$getAllDblinkObjects(DatabaseLinkPanel databaseLinkPanel, Schema schema) {
        databaseLinkPanel.getAllDblinkObjects(schema);
    }

    private class ObjectModelLoader
    implements Runnable {
        private Schema m_schema;
        private ProgressBar m_bar;

        public ObjectModelLoader() {
        }

        public ObjectModelLoader(Schema schema) {
            this.m_schema = schema;
        }

        public void execute() {
            if (DatabaseLinkPanel.this.m_prov instanceof Database) {
                this.m_bar = new ProgressBar((Component)Ide.getMainWindow(), DatabaseLinkPanel.this.getTitle(), (Runnable)this, true);
                this.m_bar.start(DatabaseLinkPanel.this.getProgressText(), this.m_schema.getName());
            } else {
                this.m_bar = null;
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProgressBar bar = this.m_bar;
            ObjectModelLoader objectModelLoader = this;
            synchronized (objectModelLoader) {
                if (DatabaseLinkPanel.ra$m_loadingSchemas(DatabaseLinkPanel.this).containsKey(this.m_schema.getName())) {
                    try {
                        DatabaseLinkPanel.mav$getAllDblinkObjects(DatabaseLinkPanel.this, this.m_schema);
                    }
                    catch (Exception e) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)e.getMessage());
                    }
                    DatabaseLinkPanel.ra$m_loadingSchemas(DatabaseLinkPanel.this).remove(this.m_schema.getName());
                }
                if (bar != null) {
                    bar.setDoneStatus();
                }
            }
        }
    }
}

