/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.component.NewFilePanel;
import oracle.ide.db.UIArb;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectListener;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;

public class DDLPanel
extends DefaultTraversablePanel
implements ActionListener,
SchemaObjectListener {
    public static final String DDL_GENERATOR = "DDlGenerator";
    private static final String EXT = ".sql";
    private static URLFilter SQL_FILTER = new DefaultURLFilter(UIArb.getString(545), ".sql");
    private JButton m_btnSave;
    private final JTextArea m_txtSQL;
    private boolean m_showRadio;
    private ButtonGroup m_btnGrp;
    private JRadioButton m_rdbCreate;
    private JRadioButton m_rdbUpdate;
    private TraversableContext m_data;

    private void $init$() {
        this.m_txtSQL = new JTextArea();
    }

    public DDLPanel() {
        this(false);
    }

    public DDLPanel(boolean chooseCreateUpdate) {
        this.$init$();
        this.m_showRadio = chooseCreateUpdate;
        this.setHelpID("f1_odbviddl_html");
    }

    public void onEntry(TraversableContext data) {
        if (this.m_data == null) {
            this.m_data = data;
            SchemaObject orig = (SchemaObject)data.get("OriginalObject");
            this.getComponent();
            if (this.m_rdbUpdate != null) {
                if (orig == null || orig.getID() == null) {
                    this.m_rdbUpdate.setEnabled(false);
                    this.m_rdbCreate.setSelected(true);
                } else {
                    this.m_rdbUpdate.setEnabled(true);
                    this.m_rdbUpdate.setSelected(true);
                }
            }
        }
        SchemaObject sObject = (SchemaObject)data.get("NewObject");
        sObject.addObjectListener((SchemaObjectListener)this);
        this.updateSQL();
    }

    private void updateSQL() {
        String sql = this.getSQL(this.m_data);
        this.m_txtSQL.setText(sql);
    }

    public void onExit(TraversableContext data) throws TraversalException {
        SchemaObject obj = (SchemaObject)data.get("NewObject");
        obj.removeObjectListener((SchemaObjectListener)this);
    }

    public static DDLGenerator getDDLGenerator(TraversableContext data) {
        DBObjectProvider pro;
        DDLGenerator gen = (DDLGenerator)data.get(DDL_GENERATOR);
        if (gen == null && (pro = (DBObjectProvider)data.get("DBObjectProvider")) != null) {
            gen = pro.getDescriptor().getDDLGenerator(pro);
        }
        return gen;
    }

    protected String getSQL(TraversableContext data) {
        DDL ddl;
        DBObjectProvider pro = (DBObjectProvider)data.get("DBObjectProvider");
        SchemaObject sObject = (SchemaObject)data.get("NewObject");
        SchemaObject orig = (SchemaObject)data.get("OriginalObject");
        SchemaObject[] secondaryObjects = (SchemaObject[])data.get("NewSecondaryDBObjects");
        DDLGenerator gen = DDLPanel.getDDLGenerator(data);
        boolean replace = false;
        if (data.get("allowReplaceForUpdate") == Boolean.TRUE) {
            orig = null;
            replace = true;
        }
        if (orig == null || orig.getID() == null || this.m_rdbCreate != null && this.m_rdbCreate.isSelected()) {
            if (secondaryObjects != null && secondaryObjects.length > 0) {
                SchemaObject[] allObjects = new SchemaObject[secondaryObjects.length + 1];
                allObjects[0] = sObject;
                System.arraycopy(secondaryObjects, 0, allObjects, 1, secondaryObjects.length);
                ddl = gen.getCreateDDL(new DDLOptions(replace, false), (DBObject[])allObjects);
            } else {
                ddl = gen.getCreateDDL(new DDLOptions(replace, false), new DBObject[]{sObject});
            }
        } else {
            Object[] updateObjs;
            Object[] origObjs;
            if (secondaryObjects != null && secondaryObjects.length > 0) {
                origObjs = new SchemaObject[secondaryObjects.length + 1];
                updateObjs = new SchemaObject[secondaryObjects.length + 1];
                origObjs[0] = orig;
                updateObjs[0] = sObject;
                int i = 1;
                SchemaObject[] schemaObjectArray = secondaryObjects;
                int n = 0;
                while (n < schemaObjectArray.length) {
                    SchemaObject so = schemaObjectArray[n];
                    updateObjs[i] = so;
                    try {
                        origObjs[i] = DBUtil.getProviderDefinition((SchemaObject)so, (DBObjectProvider)pro);
                    }
                    catch (DBException e) {
                        DBLog.getLogger().log(Level.WARNING, "Error finding existing object", e);
                    }
                    ++n;
                }
            } else {
                origObjs = new SchemaObject[]{orig};
                updateObjs = new SchemaObject[]{sObject};
            }
            DDLOptions options = new DDLOptions();
            ddl = gen.getUpdateDDL(options, pro.getDiffEngine().diff(origObjs, updateObjs).getResult());
        }
        return ddl.toString();
    }

    public Component getComponent() {
        if (this.getComponentCount() == 0) {
            DBUIResourceHelper reshelp = new DBUIResourceHelper("DDLPanel");
            this.setLayout(new GridBagLayout());
            JLabel lblSQL = new JLabel();
            reshelp.resLabel(lblSQL, this.m_txtSQL, UIArb.getString(290), "SQL");
            this.m_btnSave = new JButton();
            this.m_btnSave.addActionListener(this);
            reshelp.resButton(this.m_btnSave, UIArb.getString(557), "Save");
            this.m_txtSQL.setEditable(false);
            JScrollPane scrSQL = new JScrollPane(this.m_txtSQL);
            int y = 0;
            this.add(lblSQL, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            if (this.m_showRadio) {
                this.m_rdbCreate = new JRadioButton();
                this.m_rdbCreate.addActionListener(this);
                reshelp.resButton(this.m_rdbCreate, UIArb.getString(494), "Create");
                this.m_rdbUpdate = new JRadioButton();
                this.m_rdbUpdate.addActionListener(this);
                reshelp.resButton(this.m_rdbUpdate, UIArb.getString(742), "Update");
                this.m_btnGrp = new ButtonGroup();
                this.m_btnGrp.add(this.m_rdbCreate);
                this.m_btnGrp.add(this.m_rdbUpdate);
                this.add(this.m_rdbCreate, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
                this.add(this.m_rdbUpdate, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            }
            this.add(scrSQL, new GridBagConstraints(0, y++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.add(this.m_btnSave, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        }
        return this;
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.m_btnSave) {
            URLChooser chooser = DialogUtil.newURLChooser();
            chooser.clearChooseableURLFilters();
            chooser.setURLFilter(SQL_FILTER);
            URL url = null;
            while (chooser.showSaveDialog((Component)((Object)this)) == 0) {
                url = chooser.getSelectedURL();
                if (!ModelUtil.hasLength((String)URLFileSystem.getSuffix((URL)url))) {
                    String path = URLFileSystem.getPath((URL)url);
                    url = URLFactory.replacePathPart((URL)url, (String)(path + EXT));
                }
                try {
                    url = NewFilePanel.validateURL((Component)((Object)this), (URL)url, (String)UIArb.getString(332), (boolean)true);
                }
                catch (TraversalException ex) {
                    ex.showMessageDialog((Component)((Object)this));
                    break;
                }
                if (url == null) continue;
            }
            if (url != null) {
                try {
                    OutputStream os = URLFileSystem.openOutputStream((URL)url);
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, IdeUtil.getIdeEncoding()));
                    writer.write(this.m_txtSQL.getText());
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (IOException ex) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)ex, (String)UIArb.getString(388), (String)UIArb.getString(406), null);
                }
            }
        } else {
            this.updateSQL();
        }
    }

    public void schemaObjectUpdated(DBObjectChange change) {
        this.updateSQL();
    }
}

