/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.QueryWrapper;

public abstract class BaseInfoPanel
extends DefaultTraversablePanel {
    public static final String TABLESPACES_KEY = "Tablespaces";
    private DBObjectProvider _prov;
    private Verifier _verifier;
    private static final String QUERY_USER_TABLESPACES = "select tablespace_name from sys.user_tablespaces where contents = 'PERMANENT' order by tablespace_name";

    protected BaseInfoPanel() {
    }

    protected final void init(DBObjectProvider prov, Verifier verifier) {
        this._prov = prov;
        this._verifier = verifier;
    }

    protected final DBObjectProvider getProvider() {
        return this._prov;
    }

    protected final Verifier getVerifier() {
        return this._verifier;
    }

    protected final String getInternalName(String name) throws TraversalException {
        if (this._verifier != null) {
            this._verifier.verifyName(name);
        }
        return this._prov.getInternalName(name);
    }

    protected final String getExternalName(String name) {
        return this._prov.getExternalName(name);
    }

    protected static String getUniqueName(String base, DefaultListModel model) {
        int size = model.size();
        HashSet<String> modelNames = new HashSet<String>();
        int i = 0;
        while (i < size) {
            Object element = model.getElementAt(i);
            modelNames.add(element.toString());
            ++i;
        }
        int i2 = 0;
        String name = null;
        while (modelNames.contains(name = base + ++i2)) {
        }
        return name;
    }

    protected String[] getTablespaces(TraversableContext dataContext, DBObjectProvider provider) {
        String[] tablespaces = (String[])dataContext.find(TABLESPACES_KEY);
        if (tablespaces == null) {
            ArrayList tablespaceNames = new ArrayList();
            if (provider instanceof Database) {
                QueryWrapper wrap = new QueryWrapper((Database)provider, QUERY_USER_TABLESPACES);
                1 r = new 1(this, tablespaceNames, wrap);
                try {
                    wrap.executeQuery((QueryWrapper.QueryRunnable)r);
                }
                catch (DBException dbe) {
                    DBLog.getLogger().log(Level.WARNING, "Cannot query tablespaces for database " + ((Database)provider).getConnectionName(), dbe);
                }
            }
            tablespaces = tablespaceNames.toArray(new String[tablespaceNames.size()]);
            dataContext.put(TABLESPACES_KEY, (Object)tablespaces);
        }
        return tablespaces;
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ List v$tablespaceNames;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ BaseInfoPanel this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    this.v$tablespaceNames.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                this.v$wrap.throwDBException(e);
            }
        }

        public 1(BaseInfoPanel baseInfoPanel, List list, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$tablespaceNames = list;
            this.this$0 = baseInfoPanel;
        }
    }
}

