/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.model;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import oracle.ide.db.model.ConnectionStoreNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectProviderNode;
import oracle.ide.db.model.DatabaseNode;

public final class DBObjectNodeUtil {
    private DBObjectNodeUtil() {
    }

    public static boolean isNodeOfType(String type, Object node) {
        if (node instanceof DBObjectNode) {
            return type.equals(((DBObjectNode)node).getObjectType());
        }
        return false;
    }

    public static boolean isOnlineNodeOfType(String type, Object node) {
        if (DBObjectNodeUtil.isNodeOfType(type, node)) {
            return DBObjectNodeUtil.isOnlineNode(node);
        }
        return false;
    }

    public static boolean isOnlineNode(Object node) {
        if (node instanceof DBObjectNode) {
            return ((DBObjectNode)node).getProviderIdentifier() instanceof String;
        }
        return false;
    }

    public static boolean isRelationNode(Object node) {
        if (node instanceof DBObjectNode) {
            String type = ((DBObjectNode)node).getObjectType();
            return "TABLE".equals(type) || "VIEW".equals(type) || "MATERIALIZED VIEW".equals(type);
        }
        return false;
    }

    public static boolean isOnlineRelationNode(Object node) {
        if (DBObjectNodeUtil.isRelationNode(node)) {
            return DBObjectNodeUtil.isOnlineNode(node);
        }
        return false;
    }

    public static String getStoreName(Object node) {
        if (node instanceof ConnectionStoreNode) {
            return ((ConnectionStoreNode)node).getStoreName();
        }
        if (node instanceof DatabaseNode) {
            return DBObjectNodeUtil.decode(((DatabaseNode)node).getConnectionName(), true);
        }
        return null;
    }

    public static String getConnectionName(Object node) {
        if (node instanceof DBObjectProviderNode) {
            Object ident = ((DBObjectProviderNode)node).getProviderIdentifier();
            if (ident instanceof String) {
                return (String)ident;
            }
        } else if (node instanceof DatabaseNode) {
            return DBObjectNodeUtil.decode(((DatabaseNode)node).getConnectionName(), false);
        }
        return null;
    }

    public static String decode(String name, boolean store) {
        int li;
        if (name.contains("%23")) {
            try {
                name = URLDecoder.decode(name, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if ((li = name.lastIndexOf(35)) >= 0) {
            if (store) {
                return name.substring(0, li);
            }
            return name.substring(li + 1);
        }
        if (store) {
            return null;
        }
        return name;
    }
}

