/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.model;

import java.util.logging.Level;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedViewLogBuilder;
import oracle.javatools.util.ModelUtil;

public abstract class BaseDBObjectNode
extends Node
implements DBObjectNode {
    public DBObject getDBObject() {
        return BaseDBObjectNode.findDBObject(this);
    }

    public DBObjectProvider getProvider() {
        return BaseDBObjectNode.findProvider(this);
    }

    public void init(DBObject obj, DBObjectProvider pro) {
    }

    static DBObject findDBObject(DBObjectNode node) {
        try {
            Schema s;
            DBObjectProvider pro = node.getProvider();
            if (pro != null && (s = pro.getSchema(node.getSchemaName())) != null) {
                String objectType = node.getObjectType();
                String objectName = node.getObjectName();
                if ("PACKAGE BODY".equals(objectType)) {
                    objectType = "PACKAGE";
                } else if ("TYPE BODY".equals(objectType)) {
                    objectType = "TYPE";
                }
                if (objectType != null && objectType.startsWith("PUBLIC_")) {
                    objectType = objectType.replaceFirst("PUBLIC_", "");
                }
                if (pro instanceof BaseOracleDatabase && "MATERIALIZED VIEW LOG".equals(objectType)) {
                    String masterTableName = MaterializedViewLogBuilder.getMasterTableFromLogTable((DBObjectProvider)pro, (Schema)s, (String)objectName);
                    if (masterTableName != null) {
                        SchemaObject schemaObject = pro.getObject(objectType, s, masterTableName);
                        return schemaObject;
                    }
                } else {
                    SchemaObject schemaObject = pro.getObject(objectType, s, objectName);
                    return schemaObject;
                }
                DBObject dBObject = null;
                return dBObject;
            }
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "could not retrieve object for node: " + node.getURL(), dbe);
        }
        return null;
    }

    static DBObjectProvider findProvider(DBObjectNode node) {
        try {
            DBObjectProvider dBObjectProvider = DBObjectProviderFactory.findOrCreateProvider((Object)node.getProviderIdentifier());
            return dBObjectProvider;
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "could not retrieve provider for node: " + node.getURL(), dbe);
            return null;
        }
    }

    public Icon getIcon() {
        Icon icon = DBTypeDisplayRegistry.getNodeIcon(this.getObjectType());
        if (icon != null) {
            return icon;
        }
        return super.getIcon();
    }

    public String getShortLabel() {
        String name = this.getObjectName();
        if (ModelUtil.hasLength((String)name)) {
            return name;
        }
        return super.getShortLabel();
    }
}

