/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.db.UIArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.BaseMessageDialog;
import oracle.javatools.util.SwingUtils;

public class SQLErrorDialog
extends JPanel
implements ActionListener {
    private static final String BACK_CMD = "BACK";
    private static final String FWD_CMD = "FWD";
    private BorderLayout m_layMain;
    private JMultiLineLabel m_lblMsg;
    private JButton m_btnBack;
    private JButton m_btnForward;
    private JLabel m_count;
    private JPanel m_pnlBottom;
    private GridBagLayout m_layBottom;
    private JPanel m_pnlButtons;
    private GridLayout m_layButtons;
    private List m_errs;
    private int m_idx;
    private BaseMessageDialog m_dialog;
    private int m_type;

    private void $init$() {
        this.m_layMain = new BorderLayout();
        this.m_lblMsg = new JMultiLineLabel();
        this.m_btnBack = new JButton();
        this.m_btnForward = new JButton();
        this.m_count = new JLabel();
        this.m_pnlBottom = new JPanel();
        this.m_layBottom = new GridBagLayout();
        this.m_pnlButtons = new JPanel();
        this.m_layButtons = new GridLayout();
    }

    protected SQLErrorDialog() {
        this.$init$();
    }

    protected boolean isConfirm() {
        return this.m_type == 4;
    }

    private void setError(SQLException error) {
        ArrayList<SQLException> errs = new ArrayList<SQLException>();
        while (error != null) {
            errs.add(error);
            error = error.getNextException();
        }
        this.setErrors(errs);
    }

    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if (BACK_CMD.equals(cmd)) {
            --this.m_idx;
            this.update();
        } else if (FWD_CMD.equals(cmd)) {
            ++this.m_idx;
            this.update();
        }
    }

    protected void setErrors(List errs) {
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_errs = errs;
        this.m_idx = this.m_errs.size() > 0 ? 0 : -1;
        this.m_pnlBottom.setVisible(this.m_errs.size() > 1);
        this.update();
    }

    private void update() {
        this.m_btnBack.setEnabled(this.m_idx > 0);
        this.m_btnForward.setEnabled(this.m_idx < this.m_errs.size() - 1);
        this.m_count.setText(UIArb.format(457, this.m_idx + 1, this.m_errs.size()));
        Exception err = this.m_idx != -1 ? (Exception)this.m_errs.get(this.m_idx) : null;
        this.updateExceptionComponent(err);
        this.validate();
        this.repaint();
    }

    protected void updateExceptionComponent(Exception e) {
        SQLException err = (SQLException)e;
        String errMsg = err.getLocalizedMessage();
        if (errMsg != null && !errMsg.endsWith("\n")) {
            errMsg = errMsg + '\n';
        }
        String msg = err != null ? UIArb.format(439, errMsg, Integer.toString(err.getErrorCode())) : UIArb.getString(352);
        this.m_lblMsg.setText(msg);
    }

    protected Component getExceptionComponent() {
        this.m_lblMsg.setPreferredAspectRatio(5.0f);
        return this.m_lblMsg;
    }

    private void layoutComponents() {
        this.setLayout(this.m_layMain);
        this.add(Box.createHorizontalStrut(300), "North");
        ResourceUtils.resButton((AbstractButton)this.m_btnBack, (String)UIArb.getString(280));
        this.m_btnBack.setActionCommand(BACK_CMD);
        this.m_btnBack.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_btnForward, (String)UIArb.getString(437));
        this.m_btnForward.setActionCommand(FWD_CMD);
        this.m_btnForward.addActionListener(this);
        this.m_pnlBottom.setLayout(this.m_layBottom);
        this.m_pnlBottom.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        this.m_layButtons.setColumns(2);
        this.m_layButtons.setHgap(5);
        this.add(this.getExceptionComponent(), "Center");
        this.m_pnlButtons.setLayout(this.m_layButtons);
        this.m_pnlButtons.add((Component)this.m_btnBack, null);
        this.m_pnlButtons.add((Component)this.m_btnForward, null);
        this.m_pnlBottom.add((Component)this.m_count, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlBottom.add((Component)this.m_pnlButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_pnlBottom, "South");
    }

    protected void runErrorDialog(Component parent, String title, String helpTopic) {
        this.runDialog(parent, title, helpTopic, 3);
    }

    protected boolean runConfirmDialog(Component parent, String title, String helpTopic) {
        return this.runDialog(parent, title, helpTopic, 4);
    }

    private boolean runDialog(Component parent, String title, String helptopic, int type) {
        this.m_dialog = BaseMessageDialog.createMessageDialogImpl((Component)(parent == null ? SwingUtils.getMainWindow() : parent), (String)title, (int)type);
        this.m_type = type;
        this.update();
        if (helptopic != null) {
            this.m_dialog.setHelpTopic(helptopic);
            this.m_dialog.setButtonMask(this.m_dialog.getButtonMask() + 4);
        }
        this.m_dialog.setDefaultButton(1);
        this.m_dialog.setResizable(true);
        this.m_dialog.setMessage((Object)this);
        this.m_dialog.setMinimumSize(new Dimension(400, 250));
        return this.m_dialog.runDialog();
    }

    public static void showErrorDialog(Component parent, String title, SQLException error) {
        SQLErrorDialog panel = new SQLErrorDialog();
        panel.setError(error);
        panel.runErrorDialog(parent, title, null);
    }
}

