/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import oracle.ide.controls.AbstractPicker;
import oracle.ide.db.UIArb;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;

public class TablePicker
extends AbstractPicker {
    private DBObjectProvider m_prov;
    private Schema m_schema;
    private Verifier m_verifier;

    public TablePicker() {
        Handler handler = new Handler(null);
        super.setEncoder((AbstractPicker.PickerValueEncoder)handler);
        super.setValidator((AbstractPicker.PickerResultValidator)handler);
        super.setEditor((ComboBoxEditor)new Editor(this.getEditor()));
        super.setRenderer((ListCellRenderer)new DBObjectRenderer());
    }

    public void setProvider(DBObjectProvider prov) {
        this.m_prov = prov;
    }

    public DBObjectProvider getProvider() {
        return this.m_prov;
    }

    public void setSchema(Schema schema) {
        this.m_schema = schema;
    }

    public Schema getSchema() {
        return this.m_schema;
    }

    public void setVerifier(Verifier verifier) {
        this.m_verifier = verifier;
    }

    public Verifier getVerifier() {
        return this.m_verifier;
    }

    protected void doBrowse() {
    }

    public void setSelectedItem(Object value) {
        if (value instanceof String) {
            MutableComboBoxModel model = (MutableComboBoxModel)this.getModel();
            int i = 0;
            while (i < model.getSize()) {
                String s = (String)model.getElementAt(i);
                if (s.equals(value)) {
                    value = s;
                    break;
                }
                ++i;
            }
        }
        super.setSelectedItem(value);
    }

    public Table getTable() throws TraversalException {
        String tableName = (String)this.getSelectedItem();
        Table table = null;
        if (this.m_schema != null) {
            try {
                table = (Table)this.m_prov.getObject("TABLE", this.m_schema, tableName);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (table == null) {
            throw new TraversalException(null, UIArb.getString(703));
        }
        return table;
    }

    static DBObjectProvider ra$m_prov(TablePicker tablePicker) {
        return tablePicker.m_prov;
    }

    private class Handler
    implements AbstractPicker.PickerValueEncoder,
    AbstractPicker.PickerResultValidator {
        public Object encodeValue(Object value) {
            Object result = null;
            if (value instanceof Table) {
                result = value;
            }
            return result;
        }

        public boolean isResultValid(Object result) {
            return result instanceof Table;
        }

        public String getInvalidValueMsg(Object value) {
            return "";
        }

        private Handler() {
        }

        Handler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Editor
    implements ComboBoxEditor {
        private ComboBoxEditor m_editor;

        public Editor(ComboBoxEditor i_editor) {
            this.m_editor = i_editor;
        }

        public Component getEditorComponent() {
            return this.m_editor.getEditorComponent();
        }

        public void setItem(Object anObject) {
            Component fieldEditor;
            this.m_editor.setItem(anObject);
            if (anObject != null && (fieldEditor = this.m_editor.getEditorComponent()) instanceof JTextField && TablePicker.ra$m_prov(TablePicker.this) != null) {
                String name = null;
                name = anObject instanceof DBObject ? TablePicker.ra$m_prov(TablePicker.this).getExternalName(((DBObject)anObject).getName()) : anObject.toString();
                ((JTextField)fieldEditor).setText(name);
            }
        }

        public Object getItem() {
            return this.m_editor.getItem();
        }

        public void selectAll() {
            this.m_editor.selectAll();
        }

        public void addActionListener(ActionListener l) {
            this.m_editor.addActionListener(l);
        }

        public void removeActionListener(ActionListener l) {
            this.m_editor.removeActionListener(l);
        }
    }
}

