/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.ModelUtil;

public class SearchableTextArea
extends JPanel {
    public static final String PREFS_KEY = "oracle.ide.db.controls.SearchableTextArea";
    public static final String PREFS_CASE_KEY = "oracle.ide.db.controls.SearchableTextArea.CASE";
    private final SearchField m_searchField;
    private final JTextArea m_textArea;

    private void $init$() {
        this.m_searchField = new SearchField();
        this.m_textArea = new JTextArea();
    }

    public SearchableTextArea() {
        this((String)null);
    }

    public SearchableTextArea(String text) {
        this.$init$();
        this.m_textArea.setText(text);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_searchField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createHorizontalStrut(200), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.m_textArea, 20, 31), new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(4, 0, 0, 0), 0, 0));
        this.m_searchField.setStyle(SearchField.Style.FIND);
        this.m_searchField.setAutoFind(true);
        this.m_searchField.addSearchListener((SearchListener)new 1());
    }

    public JTextComponent getTextComponent() {
        return this.m_textArea;
    }

    public void setName(String name) {
        super.setName(name);
        this.m_searchField.setName(name + "Search");
        this.m_textArea.setName(name + "Text");
    }

    static JTextArea ra$m_textArea(SearchableTextArea searchableTextArea) {
        return searchableTextArea.m_textArea;
    }

    static SearchField ra$m_searchField(SearchableTextArea searchableTextArea) {
        return searchableTextArea.m_searchField;
    }

    final class 1
    implements SearchListener {
        public void searchPerformed(SearchEvent se) {
            if (se.isFromClear()) {
                SearchableTextArea.ra$m_textArea(SearchableTextArea.this).setSelectionEnd(SearchableTextArea.ra$m_textArea(SearchableTextArea.this).getSelectionStart() - 1);
            } else {
                String searchFor = se.getSearchText();
                boolean forward = se.getDirection() == SearchEvent.Direction.FORWARD;
                boolean matchCase = false;
                try {
                    if (ModelUtil.hasLength((String)searchFor)) {
                        String realText = SearchableTextArea.ra$m_textArea(SearchableTextArea.this).getText();
                        if (!matchCase) {
                            searchFor = searchFor.toUpperCase();
                            realText = realText.toUpperCase();
                        }
                        int searchIndex = -1;
                        if (forward) {
                            int nudge = se.isTriggeredByKeypress() ? 0 : 1;
                            int start = SearchableTextArea.ra$m_textArea(SearchableTextArea.this).getSelectionStart();
                            if (start < 0) {
                                start = SearchableTextArea.ra$m_textArea(SearchableTextArea.this).getCaretPosition();
                            }
                            searchIndex = realText.indexOf(searchFor, start + nudge);
                        } else {
                            int start = SearchableTextArea.ra$m_textArea(SearchableTextArea.this).getSelectionStart() - 1;
                            if (start < 0) {
                                start = SearchableTextArea.ra$m_textArea(SearchableTextArea.this).getCaretPosition() - 1;
                            }
                            if (start >= 0) {
                                searchIndex = realText.lastIndexOf(searchFor, start);
                            }
                        }
                        if (searchIndex >= 0) {
                            SearchableTextArea.ra$m_textArea(SearchableTextArea.this).setSelectionStart(searchIndex);
                            SearchableTextArea.ra$m_textArea(SearchableTextArea.this).setSelectionEnd(searchIndex + searchFor.length());
                        } else {
                            SearchableTextArea.ra$m_searchField(SearchableTextArea.this).showSearchFailed();
                            SearchableTextArea.ra$m_textArea(SearchableTextArea.this).setSelectionEnd(SearchableTextArea.ra$m_textArea(SearchableTextArea.this).getSelectionStart() - 1);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void searchCategoryChanged(SearchEvent se) {
        }
    }
}

