/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;

public class SchemaObjectComboBox
extends JComboBox
implements ListCellRenderer {
    private DBObjectProvider _pro;
    private DefaultListCellRenderer _delegate;
    private boolean _showNull;
    private boolean _showIcon;

    private void $init$() {
        this._pro = null;
        this._delegate = new DefaultListCellRenderer();
        this._showNull = false;
        this._showIcon = false;
    }

    public SchemaObjectComboBox() {
        this.$init$();
        this.setRenderer(this);
    }

    public void init(DBObjectProvider pro, Schema schema, String ... types) {
        this.init(pro, schema, false, types);
    }

    public void init(DBObjectProvider pro, Schema schema, boolean showNull, String ... types) {
        this._pro = pro;
        this._showNull = showNull;
        this._showIcon = types.length > 1;
        this.removeAllItems();
        if (showNull) {
            String type = null;
            if (types.length == 1) {
                type = types[0];
            }
            SchemaObjectDescriptor sod = new SchemaObjectDescriptor(" ", type, null);
            this.addItem(sod);
        }
        SchemaObject[] objs = new SchemaObject[]{};
        try {
            objs = pro.listObjects(types, schema);
        }
        catch (DBException e) {
            // empty catch block
        }
        Arrays.sort(objs, DBUtil.getNameComparator());
        SchemaObject[] schemaObjectArray = objs;
        int n = 0;
        while (n < schemaObjectArray.length) {
            SchemaObject obj = schemaObjectArray[n];
            SchemaObjectDescriptor sod = new SchemaObjectDescriptor(obj);
            this.addItem(sod);
            ++n;
        }
    }

    public void initWithOneItem(SchemaObject so) {
        this.removeAllItems();
        SchemaObjectDescriptor sod = new SchemaObjectDescriptor(so);
        this.addItem(sod);
        this.setSelectedItem(sod);
    }

    public SchemaObject getSchemaObject() {
        if (this._showNull && this.getSelectedIndex() == 0) {
            return null;
        }
        SchemaObject so = null;
        SchemaObjectDescriptor sod = (SchemaObjectDescriptor)super.getSelectedItem();
        if (sod != null) {
            try {
                so = sod.unwrapDescriptor(this._pro);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return so;
    }

    public void setSchemaObject(SchemaObject so) {
        if (so == null && this._showNull) {
            this.setSelectedIndex(0);
            return;
        }
        String soName = so == null ? "" : so.getName();
        String soType = so == null ? "" : so.getType();
        ComboBoxModel model = this.getModel();
        boolean soFound = false;
        int i = 0;
        while (i < model.getSize()) {
            String sodType;
            SchemaObjectDescriptor sod = (SchemaObjectDescriptor)model.getElementAt(i);
            String sodName = sod == null ? "" : sod.getName();
            String string = sodType = sod == null ? "" : sod.getType();
            if (sodName.equals(soName) && sodType.equals(soType)) {
                soFound = true;
                break;
            }
            ++i;
        }
        SchemaObjectDescriptor sod = new SchemaObjectDescriptor(so);
        if (soFound) {
            this.removeItem(sod);
        }
        this.addItem(sod);
        this.setSelectedItem(sod);
    }

    public void setShowIcon(boolean showIcon) {
        this._showIcon = showIcon;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        SchemaObjectDescriptor sod = (SchemaObjectDescriptor)value;
        String name = sod == null ? null : sod.getName();
        JLabel label = (JLabel)this._delegate.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
        if (this._showIcon && sod != null) {
            label.setIcon(DBTypeDisplayRegistry.getNodeIcon(sod.getType()));
        }
        return label;
    }

    public void addItem(Object anObject) {
        super.addItem(anObject);
    }

    public void setModel(ComboBoxModel aModel) {
        super.setModel(aModel);
    }
}

