/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.UIArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ideri.util.Product;
import oracle.javatools.icons.OracleIcons;

class DefaultDBTypeRegistry
implements DBTypeDisplayRegistry.RegistryEntry {
    private static Map<String, TypeEntry> typeEntries = new HashMap<String, TypeEntry>();

    public String getDisplayName(String type) {
        TypeEntry entry = typeEntries.get(type);
        return entry != null ? entry.getDisplayName() : type;
    }

    public String getSingularDisplayName(String type) {
        TypeEntry entry = typeEntries.get(type);
        return entry != null ? entry.getSingularDisplayName() : type;
    }

    public Icon getNodeIcon(String type) {
        TypeEntry entry = typeEntries.get(type);
        return entry != null ? entry.getNodeIcon() : null;
    }

    public Icon getFolderIcon(String type) {
        TypeEntry entry = typeEntries.get(type);
        Icon icon = entry != null ? entry.getFolderIcon() : null;
        return icon;
    }

    public static void registerType(String typeName, String displayName, String singularDisplayName, Icon folderIcon, Icon nodeIcon) {
        typeEntries.put(typeName, new DefaultTypeEntry(displayName, singularDisplayName, folderIcon, nodeIcon));
    }

    public static void registerType(String typeName, String displayName, String singularDisplayName, ArrayResourceBundle folderBundle, int folderKey, ArrayResourceBundle nodeBundle, int nodeKey) {
        typeEntries.put(typeName, new DeferredTypeEntry(displayName, singularDisplayName, folderBundle, folderKey, nodeBundle, nodeKey));
    }

    static {
        DefaultDBTypeRegistry.registerType("TABLE", UIArb.getString(147), UIArb.getString(101), null, OracleIcons.getIcon((String)"table.png"));
        DefaultDBTypeRegistry.registerType("COLUMN", UIArb.getString(42), UIArb.getString(831), null, OracleIcons.getIcon((String)"column.png"));
        DefaultDBTypeRegistry.registerType("INDEX", UIArb.getString(21), UIArb.getString(350), null, OracleIcons.getIcon((String)"index.png"));
        DefaultDBTypeRegistry.registerType("CONSTRAINT", UIArb.getString(662), UIArb.getString(524), null, OracleIcons.getIcon((String)"constraint.png"));
        DefaultDBTypeRegistry.registerType("SCHEMA", UIArb.getString(277), UIArb.getString(348), null, OracleIcons.getIcon((String)"schema_folder.png"));
        DefaultDBTypeRegistry.registerType("FUNCTION", UIArb.getString(538), UIArb.getString(740), null, OracleIcons.getIcon((String)"function.png"));
        DefaultDBTypeRegistry.registerType("PROCEDURE", UIArb.getString(176), UIArb.getString(0), null, OracleIcons.getIcon((String)"plsql_proc.png"));
        DefaultDBTypeRegistry.registerType("PACKAGE", UIArb.getString(218), UIArb.getString(389), null, OracleIcons.getIcon((String)"package.png"));
        DefaultDBTypeRegistry.registerType("TYPE", UIArb.getString(276), UIArb.getString(503), null, OracleIcons.getIcon((String)"domain.png"));
        DefaultDBTypeRegistry.registerType("DATATYPE", UIArb.getString(132), UIArb.getString(260), null, OracleIcons.getIcon((String)"domain.png"));
        DefaultDBTypeRegistry.registerType("JAVA CLASS", UIArb.getString(818), UIArb.getString(725), null, OracleIcons.getIcon((String)"class.png"));
        DefaultDBTypeRegistry.registerType("JAVA SOURCE", UIArb.getString(105), UIArb.getString(391), null, OracleIcons.getIcon((String)"class.png"));
        DefaultDBTypeRegistry.registerType("JAVA RESOURCE", UIArb.getString(380), UIArb.getString(743), null, OracleIcons.getIcon((String)"file.png"));
        DefaultDBTypeRegistry.registerType("JAVA", UIArb.getString(818), UIArb.getString(725), null, OracleIcons.getIcon((String)"file.png"));
        DefaultDBTypeRegistry.registerType("SEQUENCE", UIArb.getString(736), UIArb.getString(85), null, OracleIcons.getIcon((String)"sequence.png"));
        DefaultDBTypeRegistry.registerType("SYNONYM", UIArb.getString(544), UIArb.getString(329), null, OracleIcons.getIcon((String)"synonym.png"));
        DefaultDBTypeRegistry.registerType("PUBLIC_SYNONYM", UIArb.getString(104), UIArb.getString(153), null, OracleIcons.getIcon((String)"publicsynonym.png"));
        DefaultDBTypeRegistry.registerType("TRIGGER", UIArb.getString(185), UIArb.getString(106), null, OracleIcons.getIcon((String)"trigger.png"));
        DefaultDBTypeRegistry.registerType("BLOCK", UIArb.getString(684), UIArb.getString(379), null, OracleIcons.getIcon((String)"plsql_proc.png"));
        DefaultDBTypeRegistry.registerType("VIEW", UIArb.getString(789), UIArb.getString(866), null, OracleIcons.getIcon((String)"view.png"));
        DefaultDBTypeRegistry.registerType("MATERIALIZED VIEW", UIArb.getString(568), UIArb.getString(16), null, OracleIcons.getIcon((String)"materialized_view.png"));
        DefaultDBTypeRegistry.registerType("MATERIALIZED VIEW LOG", UIArb.getString(497), UIArb.getString(479), null, OracleIcons.getIcon((String)"materialized_view_log.png"));
        DefaultDBTypeRegistry.registerType("RECYCLEBIN", UIArb.getString(447), UIArb.getString(161), OracleIcons.getIcon((String)"garbg.png"), OracleIcons.getIcon((String)"remove_file.png"));
        DefaultDBTypeRegistry.registerType("DATABASE LINK", UIArb.getString(811), UIArb.getString(749), null, OracleIcons.getIcon((String)"link.png"));
        DefaultDBTypeRegistry.registerType("DIRECTORY", UIArb.getString(570), UIArb.getString(883), null, OracleIcons.getIcon((String)"file.png"));
        DefaultDBTypeRegistry.registerType("XML SCHEMA", UIArb.getString(299), UIArb.getString(300), null, OracleIcons.getIcon((String)"file.png"));
        DefaultDBTypeRegistry.registerType("INDEXTYPE", UIArb.getString(231), UIArb.getString(640), null, OracleIcons.getIcon((String)"index.png"));
        DefaultDBTypeRegistry.registerType("Connections", Product.isRaptor() ? ModelArb.getString((int)35) : UIArb.getString(292), null, null, null);
    }

    private static interface TypeEntry {
        public String getDisplayName();

        public String getSingularDisplayName();

        public Icon getFolderIcon();

        public Icon getNodeIcon();
    }

    private static class DefaultTypeEntry
    implements TypeEntry {
        private String displayName;
        private String singularDisplayName;
        private Icon folderIcon;
        private Icon nodeIcon;

        DefaultTypeEntry(String displayName, String singularDisplayName, Icon folderIcon, Icon nodeIcon) {
            this.displayName = displayName;
            this.singularDisplayName = singularDisplayName;
            this.folderIcon = folderIcon;
            this.nodeIcon = nodeIcon;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getSingularDisplayName() {
            return this.singularDisplayName;
        }

        public Icon getFolderIcon() {
            return this.folderIcon;
        }

        public Icon getNodeIcon() {
            return this.nodeIcon;
        }
    }

    private static class DeferredTypeEntry
    implements TypeEntry {
        private String m_displayName;
        private String m_singularDisplayName;
        private ArrayResourceBundle m_folderBundle;
        private ArrayResourceBundle m_nodeBundle;
        private int m_folderKey;
        private int m_nodeKey;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = DeferredTypeEntry.class.desiredAssertionStatus() ^ true;
        }

        DeferredTypeEntry(String displayName, String singularDisplayName, ArrayResourceBundle folderBundle, int folderKey, ArrayResourceBundle nodeBundle, int nodeKey) {
            if (!$assertionsDisabled && folderBundle != null && folderKey < 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && nodeBundle != null && nodeKey < 0) {
                throw new AssertionError();
            }
            this.m_displayName = displayName;
            this.m_singularDisplayName = singularDisplayName;
            this.m_folderBundle = folderBundle;
            this.m_nodeBundle = nodeBundle;
            this.m_folderKey = folderKey;
            this.m_nodeKey = nodeKey;
        }

        public String getDisplayName() {
            return this.m_displayName;
        }

        public String getSingularDisplayName() {
            return this.m_singularDisplayName;
        }

        public Icon getFolderIcon() {
            return this.m_folderBundle != null ? this.m_folderBundle.getIconImpl(this.m_folderKey) : null;
        }

        public Icon getNodeIcon() {
            return this.m_nodeBundle != null ? this.m_nodeBundle.getIconImpl(this.m_nodeKey) : null;
        }
    }
}

