/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.templates;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.templates.DateTimeVarHandler;
import oracle.dbtools.raptor.templates.LoopVarHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateVariableHandler {
    public static final char VARIABLE_MARKER = '#';
    static Map<String, Class<? extends TemplateVariableHandler>> s_variablesMap = new LinkedHashMap<String, Class<? extends TemplateVariableHandler>>();
    private String _variableName;

    protected abstract String computeVariable(Object var1);

    public static Map<String, Class<? extends TemplateVariableHandler>> getVariablesMap() {
        return s_variablesMap;
    }

    public static Map<String, Class<? extends TemplateVariableHandler>> getHandlers() {
        return s_variablesMap;
    }

    public static TemplateVariableHandler getHandler(String string) {
        try {
            Class<? extends TemplateVariableHandler> clazz = s_variablesMap.get(string);
            if (clazz == null) {
                return null;
            }
            TemplateVariableHandler templateVariableHandler = clazz.newInstance();
            templateVariableHandler.setContextVariable(string);
            return templateVariableHandler;
        }
        catch (Exception exception) {
            Logger.getLogger(TemplateVariableHandler.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }

    private void setContextVariable(String string) {
        this._variableName = string;
    }

    public String getContextVariable() {
        return this._variableName;
    }

    public String getDescription() {
        return "Template Variable";
    }

    static {
        s_variablesMap.put("#time#", DateTimeVarHandler.class);
        s_variablesMap.put("#date#", DateTimeVarHandler.class);
        s_variablesMap.put("#for#", LoopVarHandler.class);
    }
}

