/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.scriptrunner.CommandListener;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;

public class AutoTrace
extends CommandListener {
    private static final String ctxTraceState = "AUTOTRACE_STATE";
    private static final String ctxTraceType = "AUTOTRACE_TYPE";
    private static final String SPACE = "                                                                                ";
    private String AUTO_EXPLAIN = "EXPLAIN";
    private String AUTO_STAT = "STATISTICS";
    private String AUTO_ALL = "ALL";
    private String AUTO_NONE = "NONE";
    private String statSql = "select ms.Statistic# stat,ms.value,sn.name from v$mystat ms, v$statname  sn where sn.statistic# = ms.statistic# and ms.Statistic# in (7,47,50,54,134,335,336,337,341,342) order by 1";
    private ResultSet _rset = null;
    private HashMap<Integer, stat> bStats;
    private HashMap<Integer, stat> aStats;

    private static String lpad(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(SPACE.substring(0, n - string.length()));
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void write(String string, ScriptRunnerContext scriptRunnerContext) {
        BufferedOutputStream bufferedOutputStream = scriptRunnerContext.getOutputStream();
        try {
            bufferedOutputStream.write(string.getBytes());
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        Boolean bl = (Boolean)scriptRunnerContext.getProperty(ctxTraceState);
        if (bl == null) {
            scriptRunnerContext.putProperty(ctxTraceState, false);
            scriptRunnerContext.putProperty(ctxTraceType, false);
            bl = false;
        }
        if (bl.booleanValue() && !sQLCommand.getStmtClass().equals("4")) {
            this.bStats = new HashMap();
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(this.statSql);
                this._rset = preparedStatement.executeQuery();
                while (this._rset.next()) {
                    stat stat2 = new stat(this._rset.getInt(2), this._rset.getString(3));
                    this.bStats.put(this._rset.getInt(1), stat2);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        if (((Boolean)scriptRunnerContext.getProperty(ctxTraceState)).booleanValue() && !sQLCommand.getStmtClass().equals("4")) {
            Object object;
            this.aStats = new HashMap();
            try {
                object = connection.prepareStatement(this.statSql);
                this._rset = object.executeQuery();
                while (this._rset.next()) {
                    stat stat2 = new stat(this._rset.getInt(2) - this.bStats.get(this._rset.getInt(1)).getValue(), this._rset.getString(3));
                    this.aStats.put(this._rset.getInt(1), stat2);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (scriptRunnerContext.getProperty(ctxTraceType).equals(this.AUTO_ALL) || scriptRunnerContext.getProperty(ctxTraceType).equals(this.AUTO_EXPLAIN)) {
                try {
                    object = connection.prepareStatement("explain plan for " + sQLCommand.getSql());
                    this._rset = object.executeQuery();
                    object = connection.prepareStatement("SELECT * FROM table(DBMS_XPLAN.DISPLAY)");
                    this._rset = object.executeQuery();
                    while (this._rset.next()) {
                        this.write(this._rset.getString(1) + "\n", scriptRunnerContext);
                    }
                    this.write("\n", scriptRunnerContext);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
            }
            if (scriptRunnerContext.getProperty(ctxTraceType).equals(this.AUTO_ALL) || scriptRunnerContext.getProperty(ctxTraceType).equals(this.AUTO_STAT)) {
                if (this.aStats.size() > 0) {
                    this.write("   Statistics\n", scriptRunnerContext);
                    this.write("-----------------------------------------------------------\n", scriptRunnerContext);
                    object = new TreeMap<Integer, stat>(this.aStats);
                    for (Object e : object.keySet()) {
                        this.write(AutoTrace.lpad(16, String.valueOf(this.aStats.get(e).getValue())) + "  " + this.aStats.get(e).getName() + "\n", scriptRunnerContext);
                    }
                } else {
                    this.write("Unable to gather statistics please unsure user has correct access.\n", scriptRunnerContext);
                    this.write("The statistic feature requires that the user is granted select on v_$sesstat, v_$statname and v_$session.\n", scriptRunnerContext);
                }
            }
        }
    }

    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        if (sQLCommand.getSql().toLowerCase().trim().indexOf("set autotrace on exp") == 0) {
            scriptRunnerContext.putProperty(ctxTraceState, true);
            scriptRunnerContext.putProperty(ctxTraceType, this.AUTO_EXPLAIN);
            this.write("Autotrace Enabled\nDisplays the execution plan only.\n", scriptRunnerContext);
            return true;
        }
        if (sQLCommand.getSql().toLowerCase().trim().indexOf("set autotrace on stat") == 0) {
            scriptRunnerContext.putProperty(ctxTraceState, true);
            scriptRunnerContext.putProperty(ctxTraceType, this.AUTO_STAT);
            this.write("Autotrace Enabled\nDisplays the statistics only.\n", scriptRunnerContext);
            return true;
        }
        if (sQLCommand.getSql().toLowerCase().trim().indexOf("set autotrace trace") == 0) {
            this.write("Traceonly option is currently not supported\n", scriptRunnerContext);
            return true;
        }
        if (sQLCommand.getSql().toLowerCase().trim().equals("set autotrace on")) {
            scriptRunnerContext.putProperty(ctxTraceState, true);
            scriptRunnerContext.putProperty(ctxTraceType, this.AUTO_ALL);
            this.write("Autotrace Enabled\nShows the execution plan as well as statistics of the statement.\n", scriptRunnerContext);
            return true;
        }
        if (sQLCommand.getSql().toLowerCase().indexOf("set autotrace off") == 0) {
            scriptRunnerContext.putProperty(ctxTraceState, false);
            scriptRunnerContext.putProperty(ctxTraceType, this.AUTO_NONE);
            this.write("Autotrace Disabled\n", scriptRunnerContext);
            return true;
        }
        if (sQLCommand.getSql().toLowerCase().indexOf("set autotrace") == 0) {
            this.write("Unknown Autotrace option no action taken.\n", scriptRunnerContext);
            return true;
        }
        return false;
    }

    public class stat {
        int _value;
        String _name;

        public stat(int n, String string) {
            this._value = n;
            this._name = string;
        }

        public String getName() {
            return this._name;
        }

        public int getValue() {
            return this._value;
        }
    }
}

