/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.scriptrunner.CommandRegistry;
import oracle.dbtools.raptor.scriptrunner.PLSQL;
import oracle.dbtools.raptor.scriptrunner.SQL;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.scriptrunner.SQLPLUS;
import oracle.dbtools.raptor.scriptrunner.ScriptParser;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.scriptrunner.ScriptStatusDisplay;
import oracle.dbtools.raptor.scriptrunner.Substitution;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;

public class ScriptRunner
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(ScriptRunner.class.getName());
    private Connection conn;
    private String directory = null;
    private ScriptRunnerContext scriptRunnerContext = null;
    private boolean printComments = false;
    private BufferedOutputStream out = null;
    private final String ENCODING = "UTF-8";
    private SQLCommandRunner sqlCommandRunner;
    private boolean interrupted = false;
    public boolean finished = false;
    private SQLCommand[] cmds;
    private URL _baseURL;
    private ScriptStatusDisplay m_status;

    public void interrupt() {
        this.interrupted = true;
        if (this.sqlCommandRunner != null) {
            this.sqlCommandRunner.interrupt();
        }
        super.interrupt();
    }

    public ScriptRunner(Connection connection) {
        this.setConn(connection);
    }

    public ScriptRunner(String string, Connection connection) {
        this.setConn(connection);
        this.setStmt(string);
    }

    public ScriptRunner(InputStream inputStream, Connection connection) {
        this.setConn(connection);
        this.setStmt(inputStream);
    }

    public ScriptRunner(Reader reader, Connection connection) {
        this.setConn(connection);
        this.setStmt(reader);
    }

    public ScriptRunner(URL uRL, Connection connection) {
        try {
            this.setConn(connection);
            this.setStmt(uRL.openStream());
            this._baseURL = uRL;
        }
        catch (IOException iOException) {
            LOGGER.severe("Could not process url:" + uRL.toString());
        }
    }

    public void setURL(URL uRL) throws IOException {
        this.setStmt(uRL.openStream());
    }

    public void setStmt(String string) {
        ScriptParser scriptParser = new ScriptParser(string, this.conn);
        scriptParser.parse();
        this.cmds = scriptParser.getSqlStatements();
    }

    public void setStmt(InputStream inputStream) {
        this.setStmt(new InputStreamReader(inputStream));
    }

    private void setStmt(Reader reader) {
        ScriptParser scriptParser = new ScriptParser(reader, this.conn);
        scriptParser.parse();
        this.cmds = scriptParser.getSqlStatements();
    }

    public void run(SQLCommand sQLCommand) throws IOException {
        Object object;
        this.getScriptRunnerContext().setOutputStream(this.out);
        boolean bl = this.getConn() instanceof OracleConnection;
        CommandRegistry.fireBeginListeners(this.conn, this.getScriptRunnerContext(), sQLCommand);
        Substitution substitution = new Substitution(this.getScriptRunnerContext());
        String string = substitution.replaceSubstitution(sQLCommand);
        if (string != null) {
            this.report(string);
            return;
        }
        if (this.getScriptRunnerContext().isVerifyOn()) {
            object = (sQLCommand.getSql() + "\n").getBytes("UTF-8");
            this.out.write((byte[])object);
        }
        if (!this.getScriptRunnerContext().getExited()) {
            if (sQLCommand.getStmtClass().equals("8")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.printComment(sQLCommand.getSql());
                }
            } else if (sQLCommand.getStmtClass().equals("2") && (sQLCommand.getStmtId().equals("32") && bl || !sQLCommand.getStmtId().equals("32"))) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    object = new SQL(sQLCommand, this.out);
                    this.sqlCommandRunner = object;
                    ((SQLCommandRunner)object).setScriptRunnerContext(this.getScriptRunnerContext());
                    ((SQLCommandRunner)object).setConn(this.conn);
                    if (sQLCommand.getStmtId().equals("32")) {
                        byte[] byArray = (sQLCommand.getSQLOrig() + "\n").getBytes("UTF-8");
                        this.out.write(byArray);
                    }
                    ((SQL)object).run();
                    this.setScriptRunnerContext(((SQLCommandRunner)object).getScriptRunnerContext());
                    object = null;
                }
            } else if (sQLCommand.getStmtClass().equals("3")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    object = new PLSQL(sQLCommand, this.out);
                    this.sqlCommandRunner = object;
                    ((SQLCommandRunner)object).setScriptRunnerContext(this.getScriptRunnerContext());
                    ((SQLCommandRunner)object).setConn(this.conn);
                    ((PLSQL)object).run();
                    this.setScriptRunnerContext(((SQLCommandRunner)object).getScriptRunnerContext());
                    object = null;
                }
            } else if (sQLCommand.getStmtClass().equals("4")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    object = new SQLPLUS(sQLCommand, this.out);
                    this.sqlCommandRunner = object;
                    ((SQLCommandRunner)object).setScriptRunnerContext(this.getScriptRunnerContext());
                    ((SQLCommandRunner)object).setConn(this.conn);
                    ((SQLPLUS)object).setDirectory(this.directory);
                    ((SQLPLUS)object).run();
                    this.conn = ((SQLCommandRunner)object).getConn();
                    this.setScriptRunnerContext(((SQLCommandRunner)object).getScriptRunnerContext());
                    object = null;
                }
            } else if (sQLCommand.getStmtClass().equals("5")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.printComment(sQLCommand.getSql());
                }
            } else if (sQLCommand.getStmtClass().equals("6")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.printComment(sQLCommand.getSql());
                }
            } else if (sQLCommand.getStmtClass().equals("7")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.printComment(sQLCommand.getSql());
                }
            } else if (sQLCommand.getStmtClass().equals("1")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.unknown(ScriptRunnerDbArb.getString(31), sQLCommand);
                }
            } else if (sQLCommand.getStmtClass().equals("9")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.unknown("set", sQLCommand);
                }
            } else if (sQLCommand.getStmtClass().equals("10")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.unknown("create", sQLCommand);
                }
            } else if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                this.unknown("class", sQLCommand);
            }
        }
        CommandRegistry.fireEndListeners(this.conn, this.getScriptRunnerContext(), sQLCommand);
        if (this.scriptRunnerContext.getProperty("script.runner.using.systemout") == null || !((Boolean)this.scriptRunnerContext.getProperty("script.runner.using.systemout")).booleanValue()) {
            this.out.write("force_print\n".getBytes());
        }
        this.out.flush();
    }

    public void run() {
        block22: {
            Object var1_1 = null;
            Object var2_2 = null;
            if (this.scriptRunnerContext == null) {
                this.scriptRunnerContext = new ScriptRunnerContext();
            }
            if (this.scriptRunnerContext.getTopLevel()) {
                this.scriptRunnerContext.setBaseConnection(this.conn);
            }
            if (this._baseURL != null) {
                this.scriptRunnerContext.setLastUrl(this._baseURL);
            }
            this.scriptRunnerContext.putProperty("script.runner.base.url", this._baseURL);
            this.scriptRunnerContext.putProperty("total_cmd_count", this.cmds.length);
            if (this.out == null) {
                this.out = this.scriptRunnerContext.getProperty("output_stream") != null ? (BufferedOutputStream)this.scriptRunnerContext.getProperty("output_stream") : new BufferedOutputStream(System.out);
                this.scriptRunnerContext.putProperty("script.runner.using.systemout", Boolean.TRUE);
            }
            CommandRegistry.fireBeginScriptListeners(this.conn, this.getScriptRunnerContext(), this.cmds);
            int n = this.cmds.length;
            for (int i = 0; i < n; ++i) {
                try {
                    PrintWriter printWriter;
                    this.scriptRunnerContext.putProperty("sqldev.error", Boolean.FALSE);
                    this.scriptRunnerContext.putProperty("sqldev.last.err.message", null);
                    if (this.interrupted) {
                        this.interrupted = false;
                        break;
                    }
                    this.scriptRunnerContext.putProperty("output_stream", this.out);
                    this.scriptRunnerContext.putProperty("current_cmd_count", i);
                    this.run(this.cmds[i]);
                    if (this.scriptRunnerContext != null && ((Boolean)this.scriptRunnerContext.getProperty("sqldev.error")).booleanValue() && (printWriter = this.scriptRunnerContext.getErrWriter()) != null) {
                        printWriter.println(this.cmds[i]);
                        printWriter.println();
                        String string = (String)this.scriptRunnerContext.getProperty("sqldev.last.err.message");
                        string = string.replaceAll("\n", "\nREM ");
                        printWriter.println(string);
                        printWriter.println('\n');
                    }
                    if (this.scriptRunnerContext.getExited()) {
                        break;
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    try {
                        this.out.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                this.finished = true;
            }
            CommandRegistry.fireEndScriptListeners(this.conn, this.getScriptRunnerContext(), this.cmds);
            if (this.scriptRunnerContext.getTopLevel() && this.scriptRunnerContext.getCloseConnection()) {
                try {
                    this.conn.commit();
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                try {
                    this.conn.close();
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
            }
            if (this.scriptRunnerContext.getTopLevel()) {
                if (this.scriptRunnerContext.getExited()) {
                    this.scriptRunnerContext.reInitOnExit();
                } else {
                    this.scriptRunnerContext.reInitNoExit();
                }
            }
            try {
                this.out.flush();
            }
            catch (IOException iOException) {
                if (this.interrupted) break block22;
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    public void finished() {
    }

    private void unknown(String string, SQLCommand sQLCommand) {
        try {
            this.setStatusLine(ScriptRunnerDbArb.getString(31));
            String string2 = ScriptRunnerDbArb.format(16, new Integer(sQLCommand.startLine + 1), sQLCommand.getSQLOrig(), ScriptRunnerDbArb.format(32, string));
            this.out.write(string2.getBytes());
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private void printComment(String string) throws IOException {
        if (this.printComments) {
            this.out.write(string.getBytes("UTF-8"));
        }
    }

    private boolean replaceSubstitution(SQLCommand sQLCommand) {
        return false;
    }

    public BufferedOutputStream getOut() {
        return this.out;
    }

    public void setOut(BufferedOutputStream bufferedOutputStream) {
        this.out = bufferedOutputStream;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        this.directory = string;
    }

    public boolean isPrintComments() {
        return this.printComments;
    }

    public void setPrintComments(boolean bl) {
        this.printComments = bl;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection connection) {
        this.conn = connection;
    }

    public static void usage() {
        LOGGER.info("Usage: java ooracle.dbtools.raptor.scriptrunner.ScriptRunner username/password@host:port:sid @file1 @file2 @file3 ...");
        System.exit(1);
    }

    public static String[] nextToChar(String string, char c) {
        int n = string.indexOf(c);
        if (n == -1) {
            ScriptRunner.usage();
        }
        String string2 = n == string.length() - 1 ? "" : string.substring(n + 1);
        String[] stringArray = new String[]{string.substring(0, n), string2};
        return stringArray;
    }

    public static void main(String[] stringArray) throws SQLException {
        block13: {
            if (stringArray.length == 0) {
                ScriptRunner.usage();
            }
            DriverManager.registerDriver((Driver)new OracleDriver());
            String[] stringArray2 = ScriptRunner.nextToChar(stringArray[0], '/');
            String string = stringArray2[0];
            stringArray2 = ScriptRunner.nextToChar(stringArray2[1], '@');
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            if (string3.indexOf(58) == -1) {
                string3 = "127.0.0.1:1521:" + string3;
            }
            String string4 = "jdbc:oracle:thin:@" + string3;
            URL uRL = string4.getClass().getResource("/oracle/dbtools/db/foo.sql");
            LOGGER.info(uRL.toString());
            Connection connection = DriverManager.getConnection(string4, string, string2);
            connection.setAutoCommit(false);
            int n = 0;
            try {
                int n2 = stringArray.length;
                for (int i = 1; i < n2; ++i) {
                    ScriptRunner scriptRunner;
                    n = i;
                    long l = System.currentTimeMillis();
                    LOGGER.info("File:" + stringArray[i]);
                    String string5 = stringArray[i];
                    URL uRL2 = null;
                    try {
                        uRL2 = new URL(string5);
                        scriptRunner = new ScriptRunner(uRL2, connection);
                        scriptRunner.setScriptRunnerContext(new ScriptRunnerContext());
                        scriptRunner.run();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (uRL2 == null) {
                        FileInputStream fileInputStream = null;
                        if (string5.startsWith("@") && string5.length() > 1) {
                            string5 = string5.substring(1);
                        }
                        if (string5.endsWith(".sql")) {
                            fileInputStream = new FileInputStream(new File(string5));
                        } else {
                            try {
                                fileInputStream = new FileInputStream(new File(string5 + ".sql"));
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                fileInputStream = new FileInputStream(new File(string5));
                            }
                        }
                        scriptRunner = new ScriptRunner(fileInputStream, connection);
                        scriptRunner.setScriptRunnerContext(new ScriptRunnerContext());
                        scriptRunner.run();
                    }
                    LOGGER.info("Elapsed:" + (System.currentTimeMillis() - l));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.severe("File:" + stringArray[n] + " not found.");
                if (stringArray.length - 1 <= n) break block13;
                LOGGER.severe("Skipping remaining files.");
            }
        }
        LOGGER.info("Exiting");
    }

    protected void report(String string) {
        if (this.out != null) {
            try {
                this.out.write(string.getBytes("UTF-8"));
                this.out.write(10);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    public String getStatusLine() {
        return this.m_status != null ? this.m_status.getText() : null;
    }

    public void setStatusLine(String string) {
        if (this.m_status != null) {
            this.m_status.setText(string);
        }
    }

    public SQLCommand[] getCmds() {
        return this.cmds;
    }

    public void setCmds(SQLCommand[] sQLCommandArray) {
        this.cmds = sQLCommandArray;
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.scriptRunnerContext;
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.scriptRunnerContext = scriptRunnerContext;
    }

    public void setStatusDisplay(ScriptStatusDisplay scriptStatusDisplay) {
        this.m_status = scriptStatusDisplay;
    }

    public ScriptStatusDisplay getStatusDisplay() {
        return this.m_status;
    }
}

