/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryCache;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Version;
import oracle.sql.Datum;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryUtils {
    private static Logger LOGGER = Logger.getLogger(QueryUtils.class.getName());

    public static List<Bind> getNodeBinds(Node node) {
        return QueryUtils.getNodeBinds(node, "binds");
    }

    public static List<Bind> getNodeBinds(Node node, String string) {
        XMLNode[] xMLNodeArray;
        ArrayList<Bind> arrayList = new ArrayList<Bind>();
        Node node2 = XMLHelper.getChildNode(node, string);
        if (node2 == null) {
            return arrayList;
        }
        for (XMLNode xMLNode : xMLNodeArray = XMLHelper.getChildNodes(node2, "bind")) {
            String string2 = XMLHelper.getAttributeNode((Node)xMLNode, "id");
            String string3 = XMLHelper.getNodeValue((Node)xMLNode, "type");
            String string4 = XMLHelper.getNodeValue((Node)xMLNode, "prompt");
            String string5 = XMLHelper.getNodeValue((Node)xMLNode, "value");
            String string6 = XMLHelper.getNodeValue((Node)xMLNode, "tooltip");
            Bind bind = new Bind(string2, string3, string4, string5, string6);
            bind.setSortable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)xMLNode, "sortable")));
            bind.setFilterable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)xMLNode, "filterable")));
            arrayList.add(bind);
        }
        return arrayList;
    }

    public static Query getQuery(Node node) {
        String string;
        Query query = null;
        String string2 = XMLHelper.getAttributeNode(node, "sharedId");
        if (string2 != null && !string2.equals("")) {
            query = QueryCache.getQuery(string2);
        }
        if ((string = XMLHelper.getAttributeNode(node, "id")) != null && !string.equals("") && (query = QueryCache.getQuery(string)) != null) {
            query.buildQuery(node);
        }
        if (query == null) {
            query = new Query(node);
        }
        return query;
    }

    public static List<Column> getNodeCols(Node node) {
        XMLNode[] xMLNodeArray;
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Node node2 = XMLHelper.getChildNode(node, "columns");
        if (node2 == null) {
            return arrayList;
        }
        for (XMLNode xMLNode : xMLNodeArray = XMLHelper.getChildNodes(node2, "column")) {
            String string = XMLHelper.getNodeValue((Node)xMLNode, "colName");
            if (string != null) {
                string = string.trim();
            }
            if (!ModelUtil.hasLength((String)string)) continue;
            String string2 = XMLHelper.getAttributeNode((Node)xMLNode, "onClickClass");
            String string3 = XMLHelper.getAttributeNode((Node)xMLNode, "hAlign");
            String string4 = XMLHelper.getAttributeNode((Node)xMLNode, "vAlign");
            String string5 = XMLHelper.getAttributeNode((Node)xMLNode, "colFormat");
            Column column = new Column(string, string3, string4, string5);
            column.setType(XMLHelper.getNodeValue((Node)xMLNode, "type"));
            column.setID(XMLHelper.getAttributeNode((Node)xMLNode, "id"));
            column.setSortable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)xMLNode, "sortable")));
            column.setFilterable(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)xMLNode, "filterable")));
            arrayList.add(column);
        }
        return arrayList;
    }

    public static List<Query> getQueries(Node node) {
        List<Object> list = null;
        if (node != null) {
            String string = XMLHelper.getAttributeNode(node, "sharedId");
            if (string != null && !string.equals("")) {
                list = QueryCache.getQueries(string);
            }
            if (list == null) {
                list = new ArrayList();
                XMLNode[] xMLNodeArray = XMLHelper.getChildNodes(node, "query");
                for (XMLNode object2 : xMLNodeArray) {
                    Query query = Query.getQuery((Node)object2);
                    list.add(query);
                }
                List<Bind> list2 = QueryUtils.getNodeBinds(node);
                List<Column> list3 = QueryUtils.getNodeCols(node);
                List<Bind> list4 = QueryUtils.getNodeBinds(node, "optionalBinds");
                for (Query query : list) {
                    Iterator<Object> iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        Bind bind = (Bind)iterator.next();
                        query.addBind(bind);
                    }
                    for (Column column : list3) {
                        query.addColumn(column);
                    }
                    for (Bind bind : list4) {
                        query.addOptionalBind(bind);
                    }
                }
                String string2 = XMLHelper.getAttributeNode(node, "id");
                if (string2 != null && !string2.equals("")) {
                    QueryCache.putQuery(string2, list);
                }
            }
        }
        return list;
    }

    public static Query getQuery(List<Query> list, String string) {
        Query query = null;
        try {
            query = QueryUtils.getQuery(list, DBUtil.getConnectionResolver().getConnection(string));
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception);
        }
        return query;
    }

    public static Query getQuery(List<Query> list, Connection connection) {
        ArrayList<Query> arrayList = new ArrayList<Query>();
        for (Query query : list) {
            if (!DBUtil.checkVersion(connection, query.getMaxversion(), query.getMinversion())) continue;
            List list2 = (List)arrayList.clone();
            VersionComp versionComp = new VersionComp();
            for (Query query2 : list2) {
                if (versionComp.compare(query.getMinversion(), query2.getMinversion()) == 1) {
                    arrayList.remove(query2);
                    if (arrayList.contains(query)) continue;
                    arrayList.add(query);
                    continue;
                }
                if (versionComp.compare(query.getMinversion(), query2.getMinversion()) != 0) continue;
                if (query.getRequiredObjects() != null) {
                    arrayList.add(0, query);
                    continue;
                }
                arrayList.add(query);
            }
            if (arrayList.size() != 0) continue;
            arrayList.add(query);
        }
        if (arrayList.size() == 1 && (((Query)arrayList.get(0)).getRequiredObjects() == null || arrayList.get(0).getRequiredObjects().size() == 0)) {
            return arrayList.get(0);
        }
        Object object = null;
        object = QueryUtils.checkNonOracleAccess(connection, arrayList);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Query checkNonOracleAccess(Connection connection, ArrayList<Query> arrayList) {
        Query query = null;
        ConnectionResolver connectionResolver = DBUtil.getConnectionResolver();
        if (connectionResolver.lock(connection)) {
            try {
                for (Query query2 : arrayList) {
                    if (query2.getRequiredObjects() != null) {
                        Statement statement = null;
                        boolean bl = true;
                        for (String string : query2.getRequiredObjects()) {
                            String string2 = "select 1 from " + string + " where 1=2";
                            try {
                                if (connection != null) {
                                    statement = connection.createStatement();
                                    statement.execute(string2);
                                    continue;
                                }
                                bl = false;
                                break;
                            }
                            catch (SQLException sQLException) {
                                bl = false;
                                LOGGER.info(string + ":Not Found");
                                break;
                            }
                            finally {
                                if (statement == null) continue;
                                try {
                                    statement.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (!bl) continue;
                        query = query2;
                        continue;
                    }
                    if (query != null) continue;
                    query = query2;
                }
            }
            finally {
                connectionResolver.unlock(connection);
            }
        }
        return query;
    }

    private static Query checkOracleAccess(Connection connection, ArrayList<Query> arrayList) {
        Query query = null;
        for (Query query2 : arrayList) {
            if (query2.getRequiredObjects() != null) {
                StringBuilder stringBuilder = new StringBuilder("select count(1) from all_objects where ");
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int i = 0; i < query2.getRequiredObjects().size(); ++i) {
                    String string = query2.getRequiredObjects().get(i);
                    String[] stringArray = string.split("\\.");
                    arrayList2.add(stringArray[0]);
                    arrayList2.add(stringArray[1]);
                    stringBuilder.append(" ( owner = ? and object_name = ? )");
                    if (query2.getRequiredObjects().size() - 1 <= i) continue;
                    stringBuilder.append(" \n or \n ");
                }
                String string = DBUtil.getInstance().executeReturnOneCol(connection, stringBuilder.toString(), arrayList2);
                if (query2.getRequiredObjects().size() != Integer.parseInt(string)) continue;
                query = query2;
                continue;
            }
            if (query != null) continue;
            query = query2;
        }
        return query;
    }

    public static void loadFile(String string, BufferedOutputStream bufferedOutputStream) {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            File file;
            InputStream inputStream = QueryUtils.class.getResourceAsStream(string.trim());
            if (inputStream == null && (file = new File(string.trim())).exists()) {
                inputStream = new FileInputStream(file);
            }
            dOMParser.parse(inputStream);
            file = dOMParser.getDocument();
            NodeList nodeList = file.selectNodes("//query");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                XMLElement xMLElement = (XMLElement)nodeList.item(i);
                if (xMLElement.getAttribute("id") == null || xMLElement.getAttribute("id").equals("")) continue;
                LOGGER.info("Found:" + xMLElement.getNodeName() + ":" + xMLElement.getAttribute("id") + "\n");
                try {
                    bufferedOutputStream.write(("Loading:" + xMLElement.getAttribute("id") + "\n").getBytes());
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, "loadFile", iOException);
                }
                QueryUtils.getQuery((Node)xMLElement);
            }
        }
        catch (XMLParseException xMLParseException) {
            LOGGER.log(Level.WARNING, "loadFile", xMLParseException);
        }
        catch (SAXException sAXException) {
            LOGGER.log(Level.WARNING, "loadFile", sAXException);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "loadFile", iOException);
        }
        catch (XSLException xSLException) {
            LOGGER.log(Level.WARNING, "loadFile", xSLException);
        }
    }

    public static String expandQuery(String string, Map<String, Object> map) {
        String string2 = string;
        if (map != null) {
            for (String string3 : map.keySet()) {
                if (string2.toUpperCase().indexOf("#" + string3.toUpperCase() + "#") <= 0) continue;
                string2 = QueryUtils.subHashMark(string2, string3, map.get(string3));
            }
        }
        return string2;
    }

    private static String subHashMark(String string, String string2, Object object) {
        if (object == null) {
            object = "";
        }
        if (object instanceof Datum) {
            try {
                object = ((Datum)object).stringValue();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(QueryUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        String string3 = string;
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = null;
        if (object.toString().indexOf(36) > 0) {
            for (int i = 0; i < object.toString().length(); ++i) {
                if (object.toString().charAt(i) == '$') {
                    stringBuilder.append("\\" + object.toString().charAt(i));
                    continue;
                }
                stringBuilder.append(object.toString().charAt(i));
            }
            string4 = stringBuilder.toString();
        } else {
            string4 = object.toString();
        }
        try {
            string3 = string3.replaceAll("((?i)#" + string2 + "#)", string4);
            string3 = string3.replaceAll("((?i)#\"" + string2 + "\"#)", "\"" + string4 + "\"");
            string3 = string3.replaceAll("((?i)#," + string2 + "#)", string4 == "" ? "" : "," + string4);
            string3 = string3.replaceAll("((?i)#,\"" + string2 + "\"#)", string4 == "" ? "" : ",\"" + string4 + "\"");
            string3 = string3.replaceAll("((?i)#esc(" + string2 + ")#)", string4 == "" ? "" : string4.replaceAll("'", "''"));
        }
        catch (Exception exception) {
            Logger.getLogger(QueryUtils.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VersionComp
    implements Comparator<Version> {
        private VersionComp() {
        }

        @Override
        public int compare(Version version, Version version2) {
            if (version == null) {
                return version2 == null ? 0 : -1;
            }
            return version2 == null ? 1 : version.compareTo((Object)version2);
        }
    }
}

