/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Version;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Query {
    private Version m_minversion;
    private Version m_maxversion;
    private String m_sql;
    private List<Column> m_cols;
    private List<Bind> m_binds;
    private List<Bind> m_optBinds;
    private List<String> m_skipCols;
    private boolean m_constrained;
    String _id;
    private ArrayList<String> _reqs;

    protected Query(Node node) {
        this.buildQuery(node);
    }

    public Query() {
        this.m_binds = new ArrayList<Bind>();
        this.m_cols = new ArrayList<Column>();
    }

    public List<String> getRequiredObjects() {
        return this._reqs;
    }

    public void setMinversion(Version version) {
        this.m_minversion = version;
    }

    public Version getMinversion() {
        return this.m_minversion;
    }

    public void setMaxversion(Version version) {
        this.m_maxversion = version;
    }

    public Version getMaxversion() {
        return this.m_maxversion;
    }

    public void setSql(String string) {
        this.m_sql = string;
    }

    public String getSql() {
        return this.m_sql;
    }

    public void setBinds(List<Bind> list) {
        this.m_binds = list;
    }

    public Map<String, Object> getBindMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Bind bind : this.m_binds) {
            hashMap.put(bind.getName(), bind.getValue());
        }
        return hashMap;
    }

    public List<Bind> getBinds() {
        if (this.m_sql == null) {
            return this.m_binds;
        }
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(this.m_sql);
        if (this.m_binds.size() >= arrayList.size()) {
            ArrayList<Bind> arrayList2 = new ArrayList<Bind>();
            block0: for (Bind bind : this.m_binds) {
                for (Bind bind2 : arrayList) {
                    if (!bind2.getName().equals(bind.getName())) continue;
                    arrayList2.add(bind);
                    continue block0;
                }
            }
            return arrayList2;
        }
        return arrayList;
    }

    public List<Bind> getReportBinds() {
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(this.m_sql);
        if (this.m_binds.size() >= arrayList.size()) {
            return this.m_binds;
        }
        return arrayList;
    }

    public void addBind(Bind bind) {
        if (this.m_binds == null) {
            this.m_binds = new ArrayList<Bind>();
        }
        String string = bind.getName();
        boolean bl = false;
        for (Bind bind2 : this.m_binds) {
            if (bind2.getName() != string) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.m_binds.add(bind);
        }
    }

    public void setOptionalBinds(List<Bind> list) {
        this.m_optBinds = list;
    }

    public List<Bind> getOptionalBinds() {
        return this.m_optBinds;
    }

    protected void addOptionalBind(Bind bind) {
        if (this.m_optBinds == null) {
            this.m_optBinds = new ArrayList<Bind>();
        }
        String string = bind.getName();
        boolean bl = false;
        for (Bind bind2 : this.m_optBinds) {
            if (bind2.getName() != string) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.m_optBinds.add(bind);
        }
    }

    public HashMap<String, Object> getBindValues() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(this.m_sql);
        if (this.m_binds.isEmpty()) {
            this.m_binds = arrayList;
        }
        if (this.m_binds.isEmpty()) {
            return hashMap;
        }
        for (int i = 0; i < this.m_binds.size(); ++i) {
            String string = this.m_binds.get(i).getName();
            String string2 = this.m_binds.get(i).getValue();
            if (string2 != null && string2.equals("NULL_VALUE")) {
                hashMap.put(string, DBUtil.NULL_VALUE);
                continue;
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public void setCols(List<Column> list) {
        this.m_cols = list;
    }

    public List<Column> getCols() {
        return this.m_cols;
    }

    protected void addColumn(Column column) {
        if (this.m_cols == null) {
            this.m_cols = new ArrayList<Column>();
        }
        String string = column.getID();
        boolean bl = false;
        for (Column column2 : this.m_cols) {
            if (column2.getID() != string) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.m_cols.add(column);
        }
    }

    public HashMap getColValues() {
        HashMap<String, Column> hashMap = new HashMap<String, Column>();
        if (this.m_cols.isEmpty()) {
            return hashMap;
        }
        for (int i = 0; i < this.m_cols.size(); ++i) {
            String string = this.m_cols.get(i).getName();
            hashMap.put(string, this.m_cols.get(i));
        }
        return hashMap;
    }

    public void buildQuery(Node node) {
        String string;
        String string2;
        String string3;
        this.setID(XMLHelper.getAttributeNode(node, "id"));
        String string4 = XMLHelper.getAttributeNode(node, "minversion");
        if (ModelUtil.hasLength((String)string4)) {
            this.setMinversion(new Version(string4));
        }
        if ((string3 = XMLHelper.getAttributeNode(node, "requiredAccessObjects")) != null) {
            this._reqs = new ArrayList();
            Collections.addAll(this._reqs, string3.split(","));
        }
        if (ModelUtil.hasLength((String)(string2 = XMLHelper.getAttributeNode(node, "maxversion")))) {
            this.setMaxversion(new Version(string2));
        }
        if ((string = XMLHelper.getNodeValue(node, "sql")) != null) {
            this.setSql(string);
        }
        this.setConstrained(Boolean.parseBoolean(XMLHelper.getAttributeNode(XMLHelper.getChildNode(node, "sql"), "constrained")));
        List<Bind> list = QueryUtils.getNodeBinds(node);
        this.setBinds(list);
        List<Column> list2 = QueryUtils.getNodeCols(node);
        this.setCols(list2);
        String string5 = XMLHelper.getNodeValue(node, "nodisplay");
        this.setSkipCols(string5);
        List<Bind> list3 = QueryUtils.getNodeBinds(node, "optionalBinds");
        this.setOptionalBinds(list3);
    }

    public void setSkipCols(String string) {
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        this.setSkipCols(arrayList);
    }

    public void setSkipCols(List<String> list) {
        this.m_skipCols = list;
    }

    public List<String> getSkipCols() {
        return this.m_skipCols;
    }

    public boolean isConstrained() {
        return this.m_constrained;
    }

    public void setConstrained(boolean bl) {
        this.m_constrained = bl;
    }

    public String getIndent(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "\t";
        }
        return string;
    }

    public String toXML(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getIndent(n) + "<query");
        if (this.m_minversion != null) {
            stringBuilder.append(" minversion=\"" + this.m_minversion + "\"");
        }
        if (this.m_maxversion != null) {
            stringBuilder.append(" maxversion=\"" + this.m_maxversion + "\"");
        }
        if (this._reqs != null) {
            Iterator<Column> iterator = new StringBuilder();
            for (String string : this._reqs) {
                ((StringBuilder)((Object)iterator)).append(string);
                ((StringBuilder)((Object)iterator)).append(",");
            }
            ((StringBuilder)((Object)iterator)).deleteCharAt(((StringBuilder)((Object)iterator)).length() - 1);
            stringBuilder.append(" requiredAccessObjects=\"" + iterator + "\"");
        }
        stringBuilder.append(">\n");
        stringBuilder.append(this.getIndent(n + 1) + "<sql><![CDATA[" + this.m_sql + "]]></sql>\n");
        if (this.m_binds.size() > 0) {
            stringBuilder.append(this.getIndent(n + 1) + "<binds>\n");
            for (Bind bind : this.m_binds) {
                stringBuilder.append(bind.toXML(n + 2));
            }
            stringBuilder.append(this.getIndent(n + 1) + "</binds>\n");
        }
        if (this.m_cols.size() > 0) {
            stringBuilder.append(this.getIndent(n + 1) + "<columns>\n");
            for (Column column : this.m_cols) {
                stringBuilder.append(column.toXML(n + 2));
            }
            stringBuilder.append(this.getIndent(n + 1) + "</columns>\n");
        }
        stringBuilder.append(this.getIndent(n) + "</query>\n");
        return stringBuilder.toString();
    }

    public String getID() {
        return this._id;
    }

    public void setID(String string) {
        this._id = string;
    }

    public static Query getQuery(Node node) {
        return QueryUtils.getQuery(node);
    }

    public static List<Query> getQueries(Node node) {
        return QueryUtils.getQueries(node);
    }
}

