/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Translate;

public class ResultSetFormatterWrapper
extends ResultsFormatterWrapper {
    private ResultSet m_rs;
    private ResultSetMetaData m_meta;

    protected ResultSetFormatterWrapper() {
    }

    public ResultSetFormatterWrapper(ResultSet resultSet) {
        this.setResultSet(resultSet);
    }

    protected void setResultSet(ResultSet resultSet) {
        this.m_rs = resultSet;
        try {
            this.m_meta = ((PreparedStatement)this.m_rs.getStatement()).getMetaData();
            int[] nArray = new int[this.m_meta.getColumnCount() + 1];
            ArrayList<String> arrayList = new ArrayList<String>();
            block5: for (int i = 1; i < this.m_meta.getColumnCount() + 1; ++i) {
                String string = this.m_meta.getColumnName(i);
                arrayList.add(string);
                switch (this.m_meta.getColumnType(i)) {
                    case 91: 
                    case 92: 
                    case 93: {
                        nArray[i] = 25;
                        continue block5;
                    }
                    default: {
                        nArray[i] = string.length();
                    }
                }
            }
            this.setColumnNames(arrayList);
            this.setColumnSizes(nArray);
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException(sQLException);
        }
    }

    public Connection getConnection() {
        Connection connection = null;
        try {
            connection = this.m_rs.getStatement().getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return connection;
    }

    public int getDataType(int n) throws SQLException {
        return this.m_meta.getColumnType(n);
    }

    public int print() throws IOException {
        int n = 0;
        this.m_formatter.start();
        try {
            while (this.m_rs.next() && !this.isInterrupted()) {
                this.m_formatter.log(Translate.translate("Row:" + this.m_rs.getRow()));
                this.m_formatter.startRow();
                for (int i = 0; i < this.m_meta.getColumnCount(); ++i) {
                    this.m_formatter.printColumn(this.m_rs.getObject(i + 1), i + 1, i + 1);
                }
                this.m_formatter.endRow();
                n = this.m_rs.getRow();
            }
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException(sQLException);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException);
        }
        this.m_formatter.end();
        return n;
    }

    public String getSQL() {
        return null;
    }
}

