/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.sql.ARRAY;
import oracle.sql.STRUCT;

public class LoaderFormatter
extends ResultsFormatter {
    boolean do_header = false;
    String tableName = null;
    StringBuilder header;
    StringBuilder row;

    public LoaderFormatter() {
        super("LOADER", Translate.translate("Loader File"), "ldr");
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void start() throws IOException {
        this.do_header = true;
    }

    public void start2(Object object, int n) throws IOException {
        int n2 = this.getColumnCount();
        if (n == 1) {
            this.header.append("LOAD DATA" + this.getLineTerminator());
            this.header.append("INFILE *" + this.getLineTerminator());
            this.header.append("TRUNCATE" + this.getLineTerminator());
            this.header.append("INTO TABLE \"" + this.tableName + "\"" + this.getLineTerminator());
            this.header.append("FIELDS TERMINATED BY '|'" + this.getLineTerminator());
            this.header.append("TRAILING NULLCOLS ( " + this.getLineTerminator());
        }
        String string = this.getColumnName(n);
        int n3 = this.getDataType(n);
        if (n3 == 2002) {
            this.header.append(string + " COLUMN OBJECT ( " + this.getLineTerminator());
            STRUCT sTRUCT = (STRUCT)object;
            try {
                Object[] objectArray = sTRUCT.getAttributes();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) continue;
                    switch (i) {
                        case 0: {
                            this.header.append("SDO_GTYPE INTEGER EXTERNAL");
                            break;
                        }
                        case 1: {
                            this.header.append("SDO_SRID INTEGER EXTERNAL");
                            break;
                        }
                        case 2: {
                            this.header.append("SDO_POINT COLUMN OBJECT (Y FLOAT EXTERNAL, X FLOAT EXTERNAL)");
                            break;
                        }
                        case 3: {
                            this.header.append("SDO_ELEM_INFO VARRAY TERMINATED BY '|/' (elements  FLOAT EXTERNAL)");
                            break;
                        }
                        case 4: {
                            this.header.append("SDO_ORDINATES VARRAY TERMINATED BY '|/' (ordinates FLOAT EXTERNAL)");
                        }
                    }
                    if (i >= objectArray.length - 1) continue;
                    this.header.append("," + this.getLineTerminator());
                }
                this.header.append(")" + this.getLineTerminator());
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        } else {
            this.header.append(string + this.getDateFormat(n3));
        }
        if (n == n2 - 1) {
            this.header.append(")" + this.getLineTerminator());
            this.header.append("begindata" + this.getLineTerminator());
        } else {
            this.header.append("," + this.getLineTerminator());
        }
    }

    private String getDateFormat(int n) {
        String string = NLSUtils.getDateFormat(this.getConnection());
        if (n == 93) {
            return " timestamp \"" + string + "\" ";
        }
        return " ";
    }

    public void startRow() throws IOException {
        this.header = new StringBuilder();
        this.row = new StringBuilder();
    }

    public String getStruct(Object object) {
        String string = "";
        STRUCT sTRUCT = (STRUCT)object;
        try {
            Object[] objectArray = sTRUCT.getAttributes();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (object2 == null) continue;
                if (!(object2 instanceof ARRAY)) {
                    string = string + objectArray[i] + "|";
                    continue;
                }
                BigDecimal[] bigDecimalArray = (BigDecimal[])((ARRAY)object2).getArray();
                int n = ((ARRAY)object2).length();
                for (int j = 0; j < n; ++j) {
                    string = string + bigDecimalArray[j] + "|";
                }
                string = string + "/";
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return string;
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
        if (this.do_header) {
            this.start2(object, n);
        }
        int n3 = this.getDataType(n);
        String string = "";
        if (n == 0) {
            return;
        }
        if (n > 1) {
            string = string + "|";
        }
        if (object == null) {
            string = string + this.getQuote(n3) + this.getQuote(n3);
        } else if (object != null) {
            string = n3 == 2002 ? string + this.getStruct(object) : string + this.getQuote(n3) + this.cleanString(this.getValue(object).toString()) + this.getQuote(n3);
        }
        this.row.append(string);
    }

    private String getQuote(int n) {
        if (n == 2 || n == 12 || n == 93) {
            return "";
        }
        return "\"";
    }

    public String cleanString(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            Character c = Character.valueOf(string.charAt(i));
            string2 = string2 + c;
        }
        return string2;
    }

    public void endRow() throws IOException {
        if (this.do_header) {
            this.write(this.header.toString());
        }
        this.write(this.row.toString());
        this.write(this.getLineTerminator());
        this.do_header = false;
    }

    public void end() throws IOException {
    }

    public Boolean getPromptForTable() {
        return true;
    }
}

