/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.utils.Translate;

public class InsertFormatter
extends ResultsFormatter {
    StringBuffer sb = new StringBuffer();
    String tableName = null;
    public static final String exportTypeName = "INSERT";

    public InsertFormatter() {
        super(exportTypeName, Translate.translate("SQL File"), "sql");
    }

    public String getString() {
        return this.sb.toString();
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void start() throws IOException {
        this.sb = new StringBuffer();
        this.write("REM INSERTING into " + this.tableName);
        this.write(this.getLineTerminator());
    }

    public void startRow() throws IOException {
        int n = this.getColumnCount();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        if (this.getColumnName(0).equals("Row")) {
            n2 = 1;
        }
        if (n > n2) {
            stringBuffer.append(DBUtil.enquote(this.getColumnName(n2)));
            ++n2;
        }
        for (int i = n2; i < n; ++i) {
            stringBuffer.append(',').append(DBUtil.enquote(this.getColumnName(i)));
        }
        this.write("Insert into ");
        if (this.tableName.indexOf(".") > -1) {
            this.write(this.tableName);
        } else {
            this.write(DBUtil.enquote(this.tableName));
        }
        this.write(" (" + stringBuffer + ") values (");
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
        String string = "";
        char c = NLSProvider.getProvider(this.getWrapper().getConnection()).getGroupSeparator();
        if (n == 0) {
            return;
        }
        if (object != null && n == 1) {
            int n3 = this.getDataType(n);
            string = n3 == 91 ? (this.getDateFormat() == null ? "'" + this.cleanString(this.getValue(object).toString()) + "'" : "to_date('" + this.cleanString(this.getValue(object).toString()) + "','" + this.getDateFormat() + "')") : (n3 == 4 || n3 == -5 || n3 == 6 || n3 == 7 || n3 == 8 || n3 == 2 || n3 == 2 || n3 == -6 || n3 == 3 ? this.cleanString(this.getValue(object).toString()) : (n3 == 93 || this.getDataType(n2) == -102 ? "to_timestamp('" + this.getValue(object) + "','" + this.getTimeStampFormat() + "')" : (n3 == -101 ? "to_timestamp('" + this.getValue(object) + "','" + this.getTimeStampFormat() + "')" : (n3 == 2005 ? "(CLOB)" : "'" + this.cleanString(this.getValue(object).toString()) + "'"))));
        } else if (object == null && n == 1) {
            string = "null";
        } else if (object != null && n > 1) {
            int n4 = this.getDataType(n);
            string = n4 == 91 ? (this.getDateFormat() == null ? c + "'" + this.cleanString(this.getValue(object).toString()) + "'" : c + "to_date('" + this.cleanString(this.getValue(object).toString()) + "','" + this.getDateFormat() + "')") : (n4 == 4 || n4 == -5 || n4 == 6 || n4 == 7 || n4 == 8 || n4 == 2 || n4 == 2 || n4 == -6 || n4 == 3 || n4 == 2002 ? c + this.cleanString(this.getValue(object).toString()) : (n4 == 93 || n4 == -102 ? c + "to_timestamp('" + this.getValue(object) + "','" + this.getTimeStampFormat() + "')" : (n4 == -101 ? c + "to_timestamp('" + this.getValue(object) + "','" + this.getTimeStampFormat() + "')" : (n4 == 2005 ? ",(CLOB)" : c + "'" + this.cleanString(this.getValue(object).toString()) + "'"))));
        } else if (object == null && n > 1) {
            string = c + "null";
        }
        this.write(string);
    }

    public String cleanString(String string) {
        String string2 = "";
        Character c = Character.valueOf('\'');
        for (int i = 0; i < string.length(); ++i) {
            Character c2 = Character.valueOf(string.charAt(i));
            string2 = c2.equals(c) ? string2 + "''" : string2 + c2;
        }
        return string2;
    }

    public void endRow() throws IOException {
        this.write(");" + this.getLineTerminator());
    }

    public void end() throws IOException {
    }

    public Boolean getPromptForTable() {
        return true;
    }

    protected void write(String string) throws IOException {
        if (string != null) {
            if (this._out != null) {
                this._out.write(string);
            } else {
                this.sb.append(string);
            }
        }
    }
}

