/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.raptor.format.CSVFormatter;
import oracle.dbtools.raptor.format.ExcelFormatter;
import oracle.dbtools.raptor.format.HTMLFormatter;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.InsertFormatter;
import oracle.dbtools.raptor.format.LoaderFormatter;
import oracle.dbtools.raptor.format.TxtFormatter;
import oracle.dbtools.raptor.format.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatRegistry {
    private static Map<String, IResultFormatter> s_registry = new TreeMap<String, IResultFormatter>();

    public static synchronized void registerFormater(IResultFormatter iResultFormatter) {
        s_registry.put(iResultFormatter.getType().toLowerCase(), iResultFormatter);
    }

    public static synchronized void unregisterFormater(IResultFormatter iResultFormatter) {
        s_registry.remove(iResultFormatter.getType().toLowerCase());
    }

    public static synchronized IResultFormatter getFormatter(String string) {
        return s_registry.get(string.toLowerCase());
    }

    public static synchronized List<String> getTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(s_registry.keySet());
        return arrayList;
    }

    static {
        FormatRegistry.registerFormater(new TxtFormatter());
        FormatRegistry.registerFormater(new CSVFormatter());
        FormatRegistry.registerFormater(new InsertFormatter());
        FormatRegistry.registerFormater(new LoaderFormatter());
        FormatRegistry.registerFormater(new XMLFormatter());
        FormatRegistry.registerFormater(new HTMLFormatter());
        FormatRegistry.registerFormater(new ExcelFormatter());
    }
}

