/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.controls.TextAutoCompleter;

public abstract class FilterAutoCompleter
extends TextAutoCompleter {
    public FilterAutoCompleter(JTextComponent jTextComponent) {
        super(jTextComponent);
    }

    protected void acceptedListItem(String string) {
        try {
            this.textComp.getDocument().remove(0, this.textComp.getDocument().getLength());
            this.textComp.getDocument().insertString(0, string, null);
            this.textComp.select(this.textComp.getDocument().getLength(), this.textComp.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected boolean updateListData() {
        String string = this.textComp.getText();
        List<Object> list = Arrays.asList(this.getPullDownList());
        if (list == null) {
            this.list.setListData(new String[0]);
            return false;
        }
        if (string == null || string.equals("")) {
            this.list.setListData(list.toArray());
            return true;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : list) {
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(string.toLowerCase());
            }
            catch (Exception exception) {
                this.list.setListData(new String[0]);
                return true;
            }
            Matcher matcher = pattern.matcher(object.toString().toLowerCase());
            if (!matcher.find()) continue;
            arrayList.add(object);
        }
        if (arrayList.size() == 0) {
            this.list.setListData(new String[0]);
            return false;
        }
        if (arrayList.size() == 1 && arrayList.get(0).toString().equalsIgnoreCase(string)) {
            this.list.setListData(new String[0]);
        } else {
            this.list.setListData(arrayList.toArray());
        }
        return true;
    }

    protected abstract Object[] getPullDownList();
}

