/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging;

import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RaptorSimpleFormatter
extends Formatter {
    private static Long lastTime = System.currentTimeMillis();
    private static String MSG = "%-10s%dms\t%s.%-20s\t%s\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(LogRecord logRecord) {
        String string = String.format(MSG, logRecord.getLevel().getName(), new Long(logRecord.getMillis() - lastTime), logRecord.getSourceClassName().substring(logRecord.getSourceClassName().lastIndexOf(".") + 1), logRecord.getSourceMethodName(), logRecord.getMessage());
        Long l = lastTime;
        synchronized (l) {
            lastTime = logRecord.getMillis();
        }
        return string;
    }

    public static void initBasicLogger() {
        if (Logger.getLogger("") != null && Logger.getLogger("").getHandlers() != null && Logger.getLogger("").getHandlers().length == 1 && Logger.getLogger("").getHandlers()[0] != null) {
            Logger.getLogger("").removeHandler(Logger.getLogger("").getHandlers()[0]);
        }
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new RaptorSimpleFormatter());
        Logger logger = Logger.getLogger("oracle.dbtools.raptor");
        logger.setLevel(Level.ALL);
        logger.addHandler(consoleHandler);
    }
}

