/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.logging.ILoggingPage;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class LogPaneHandler
extends Handler {
    private static final Object LOCK = new Object();
    private static LogPaneHandler INSTANCE;
    private ILoggingPage _logPage = new DefaultLogger();
    private Class<ILoggingPage> _logpageClass;

    private LogPaneHandler() {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger("");
        logger.addHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogPaneHandler getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new LogPaneHandler();
            }
        }
        return INSTANCE;
    }

    public void close() throws SecurityException {
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord logRecord) {
        Object object = LOCK;
        synchronized (object) {
            if (this._logPage == null && this._logpageClass != null) {
                try {
                    INSTANCE.setLogPage(this._logpageClass.newInstance());
                }
                catch (InstantiationException instantiationException) {
                    ExceptionHandler.handleException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    ExceptionHandler.handleException(illegalAccessException);
                }
            }
            this._logPage.log(logRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogPage(ILoggingPage iLoggingPage) {
        Object object = LOCK;
        synchronized (object) {
            if (this._logPage instanceof DefaultLogger) {
                ((DefaultLogger)this._logPage).outputTo(iLoggingPage);
            }
            this._logPage = iLoggingPage;
        }
    }

    public void setLogPageClass(Class clazz) {
        this._logPage = null;
        this._logpageClass = clazz;
    }

    private static class DefaultLogger
    implements ILoggingPage {
        private List<LogRecord> _log = new ArrayList<LogRecord>();

        private DefaultLogger() {
        }

        public void log(LogRecord logRecord) {
            this._log.add(logRecord);
        }

        private void outputTo(ILoggingPage iLoggingPage) {
            for (LogRecord logRecord : this._log) {
                iLoggingPage.log(logRecord);
            }
        }
    }
}

