/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.log.LogManager;
import oracle.javatools.db.DBException;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.CLOB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUtil {
    public static final String PREFERRED_FETCH_SIZE = "PreferfedFetchSize";
    public static final Object NULL_VALUE = new Object();
    private static ConnectionResolver conns;
    private static DBUtil _dbUtilInstance;
    private static final String MODULE = "begin dbms_application_info.set_module(?,?); end;";
    private static final String ACTION = "begin dbms_application_info.set_action(?); end;";
    private static final String ERR_SQL = " declare  l_theCursor     integer default dbms_sql.open_cursor;  l_status        integer default -1 ;  insqlsix        VARCHAR2(6);  begin    insqlsix:=upper(substr(ltrim(?),1,6));   if ((insqlsix  in ( 'CREATE' ,'INSERT', 'UPDATE', 'DELETE', 'SELECT') )     OR(substr(insqlsix,1,5)='MERGE')      OR(substr(insqlsix,1,4)='WITH') OR (substr(insqlsix,1,1)='(')) then      begin      l_status := -2;      dbms_sql.parse(  l_theCursor, ?, dbms_sql.native );      exception           when others then             l_status := dbms_sql.last_error_position;      end;      dbms_sql.close_cursor( l_theCursor );    end if;     ? := l_status;   end;";
    private static final String HAS_TRANSACTION_QUERY = "SELECT dbms_transaction.local_transaction_id FROM dual";
    private static final String ORACLE_CONNECTION_ALIVE_QUERY = "SELECT 1 FROM DUAL";
    private static String s_prodName;
    private List _internalBinds = new ArrayList();
    private static String _currentErrorString;
    private static boolean _raiseError;
    private static final HashMap<Connection, Version> VERSION_CACHE;
    private static final HashMap<String, Version> VERSION_NAME_BASED_CACHE;
    private static Logger logger;
    private static final String VERSION_PATTERN = "[0-9]+\\.[0-9.]*[0-9]+";
    private static final Pattern s_pattern;

    public static synchronized void setConnectionResolver(ConnectionResolver connectionResolver) {
        if (conns != null) {
            throw new IllegalStateException("Cannot set a ConnectionResolver if one is already set");
        }
        conns = connectionResolver;
    }

    public static synchronized ConnectionResolver getConnectionResolver() {
        return conns;
    }

    public static void setProductName(String string) {
        s_prodName = string;
    }

    public static synchronized DBUtil getInstance() {
        if (_dbUtilInstance == null) {
            _dbUtilInstance = new DBUtil();
        }
        _dbUtilInstance.setRaiseError(true);
        return _dbUtilInstance;
    }

    public void setDBAction(String string, String string2) {
        this._internalBinds.clear();
        this._internalBinds.add(string2 == null ? "" : string2);
        this.execute(string, ACTION, this._internalBinds);
    }

    public void setDBModuleAction(String string, String string2) {
        this._internalBinds.clear();
        this._internalBinds.add(s_prodName);
        this._internalBinds.add(string2 == null ? "" : string2);
        this.execute(string, MODULE, this._internalBinds);
    }

    public String executeReturnOneCol(String string, String string2, Map map) {
        if (conns.isOracle(string)) {
            return this.executeOracleReturnOneCol(string, string2, map);
        }
        return this.executeNonOracleReturnOneCol(string, string2, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeNonOracleReturnOneCol(String string, String string2, Map map) {
        String string3 = null;
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string2, true);
        ArrayList arrayList2 = new ArrayList();
        ResultSet resultSet = null;
        String string4 = string2;
        for (Bind bind : arrayList) {
            arrayList2.add(map.get(bind.getName()));
            string4 = string4.replaceFirst(":" + bind.getName(), "?");
        }
        string4.replaceAll("\n", " ");
        Object object = null;
        try {
            object = conns.getConnection(string).prepareStatement(string4);
            logger.info("Prepared:" + string4);
            this.bind((PreparedStatement)object, arrayList2);
            resultSet = object.executeQuery();
            resultSet.next();
            string3 = resultSet.getString(1);
        }
        catch (Exception exception) {
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            } else {
                logger.fine(exception.getMessage());
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {}
            try {
                object.close();
            }
            catch (SQLException sQLException) {}
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeOracleReturnOneCol(String string, String string2, Map map) {
        String string3 = null;
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = conns.getConnection(string);
            callableStatement = connection.prepareCall(string2);
            logger.info("Prepared:" + string2);
            this.bind(string2, callableStatement, map);
            resultSet = callableStatement.executeQuery();
            if (resultSet.next()) {
                string3 = resultSet.getString(1);
            }
        }
        catch (Exception exception) {
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            } else {
                logger.severe(exception.getMessage());
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
        }
        return string3;
    }

    public String executeReturnOneCol(String string, String string2, List list) {
        String string3 = null;
        try {
            string3 = this.executeReturnOneCol(conns.getConnection(string), string2, list);
        }
        catch (Exception exception) {
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            }
            logger.severe(exception.getMessage());
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeReturnOneCol(Connection connection, String string, List list) {
        String string2 = null;
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall(string);
            logger.info("Prepared:" + string);
            this.bind((PreparedStatement)callableStatement, list);
            resultSet = callableStatement.executeQuery();
            resultSet.next();
            string2 = resultSet.getString(1);
        }
        catch (Exception exception) {
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            } else {
                logger.severe(exception.getMessage());
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, String string2, List list) {
        int n = 0;
        Statement statement = null;
        try {
            Connection connection = conns.getConnection(string);
            statement = connection.prepareCall(string2);
            logger.info("Prepared:" + string2);
            if (list != null) {
                this.bind((PreparedStatement)statement, list);
            }
            n = statement.executeUpdate();
        }
        catch (Exception exception) {
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            } else {
                logger.severe(exception.getMessage());
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, String string2, Map map) {
        int n = 0;
        Statement statement = null;
        try {
            Connection connection = conns.getConnection(string);
            statement = connection.prepareCall(string2);
            logger.info("Prepared:" + string2);
            this.bind((PreparedStatement)statement, map);
            n = statement.executeUpdate();
        }
        catch (Exception exception) {
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            } else {
                _currentErrorString = exception.getMessage();
            }
            logger.severe(exception.getMessage());
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public boolean execute(String string, String string2, List list) {
        return this.execute(string, string2, list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string, String string2, List list, String string3) {
        boolean bl = false;
        Statement statement = null;
        try {
            Connection connection = conns.getConnection(string);
            statement = connection.prepareCall(string2);
            logger.info("Prepared:" + string2);
            if (list != null) {
                this.bind((PreparedStatement)statement, list);
            }
            bl = statement.execute();
            bl = true;
        }
        catch (Exception exception) {
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            } else {
                logger.severe(exception.getMessage());
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public PreparedStatement prepareExecute(String string, String string2, Map<String, Object> map) {
        Statement statement = null;
        try {
            Connection connection = conns.getConnection(string);
            statement = this.prepareExecute(connection, string2, map);
        }
        catch (Exception exception) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            }
            logger.severe(exception.getMessage());
        }
        return statement;
    }

    public PreparedStatement prepareExecute(Connection connection, String string, Map<String, Object> map) {
        boolean bl = true;
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(string);
            logger.info("Prepared:" + string);
            if (map != null) {
                this.bind((PreparedStatement)callableStatement, map);
            }
        }
        catch (Exception exception) {
            bl = false;
            if (callableStatement != null) {
                try {
                    callableStatement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            }
            logger.severe(exception.getMessage());
        }
        return callableStatement;
    }

    public boolean execute(String string, String string2, Map<String, Object> map) {
        PreparedStatement preparedStatement = this.prepareExecute(string, string2, map);
        logger.info("Prepared:" + string2);
        return this.execute(preparedStatement);
    }

    public boolean execute(Connection connection, String string, Map<String, Object> map) {
        PreparedStatement preparedStatement = this.prepareExecute(connection, string, map);
        logger.info("Prepared:" + string);
        return this.execute(preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(PreparedStatement preparedStatement) {
        boolean bl = true;
        try {
            bl = preparedStatement.execute();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            } else {
                logger.severe(exception.getMessage());
            }
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public ResultSet executeQuery(String string, String string2, Map map) {
        ResultSet resultSet = null;
        try {
            Connection connection = conns.getConnection(string);
            resultSet = this.executeQuery(connection, string2, map);
        }
        catch (Exception exception) {
            try {
                if (resultSet != null && resultSet.getStatement() != null) {
                    resultSet.getStatement().close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            }
            logger.severe(exception.getMessage());
        }
        return resultSet;
    }

    public ResultSet executeOracleQuery(Connection connection, String string, Map map) {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareCall(string);
            logger.info("Prepared:" + string);
            if (map != null) {
                this.bind(string, preparedStatement, map);
            }
            resultSet = preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (resultSet != null && resultSet.getStatement() != null) {
                    resultSet.getStatement().close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (_raiseError) {
                String string2 = conns.getConnectionName(connection);
                ExceptionHandler.handleException(exception, string2);
            }
            logger.severe(exception.getMessage());
        }
        return resultSet;
    }

    public ResultSet executeQuery(Connection connection, String string, Map map) {
        if (connection instanceof OracleConnection) {
            return this.executeOracleQuery(connection, string, map);
        }
        return this.executeNonOracleQuery(connection, string, map);
    }

    private ResultSet executeNonOracleQueryUsingMessageFormat(Connection connection, String string, Map map) {
        boolean bl = false;
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string, true);
        ArrayList arrayList2 = new ArrayList();
        ResultSet resultSet = null;
        String string2 = string;
        String string3 = this.prepareNonOracleSqlMsgFormat(connection, string, map);
        try {
            Statement statement = connection.createStatement();
            logger.info("Executing:" + string3);
            resultSet = statement.executeQuery(string3);
        }
        catch (Exception exception) {
            try {
                if (resultSet != null && resultSet.getStatement() != null) {
                    resultSet.getStatement().close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            }
            logger.severe(exception.getMessage());
        }
        return resultSet;
    }

    private ResultSet executeNonOracleQuery(Connection connection, String string, Map map) {
        if (string.contains("{:")) {
            return this.executeNonOracleQueryUsingMessageFormat(connection, string, map);
        }
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string, true);
        ArrayList arrayList2 = new ArrayList();
        ResultSet resultSet = null;
        String string2 = string;
        for (Bind bind : arrayList) {
            arrayList2.add(map.get(bind.getName()));
            string2 = string2.replaceFirst(":" + bind.getName(), "?");
        }
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            logger.info("Prepared:" + string2);
            this.bind(preparedStatement, arrayList2);
            resultSet = preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            try {
                if (resultSet != null && resultSet.getStatement() != null) {
                    resultSet.getStatement().close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            }
            logger.severe(exception.getMessage());
        }
        return resultSet;
    }

    public ResultSet executeQuery(String string, String string2, List list) {
        try {
            return this.executeQuery(conns.getConnection(string), string2, list);
        }
        catch (DBException dBException) {
            logger.severe("Could not get connection:" + dBException.getMessage());
            return null;
        }
    }

    public ResultSet executeQuery(Connection connection, String string, List list) {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            if (!(connection instanceof OracleConnection)) {
                ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string, true);
                for (Bind bind : arrayList) {
                    string = string.replaceFirst(":" + bind.getName(), "?");
                }
                preparedStatement = connection.prepareStatement(string);
            } else {
                preparedStatement = connection.prepareCall(string);
            }
            logger.info("Prepared:" + string);
            if (list != null) {
                this.bind(preparedStatement, list);
            }
            resultSet = preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            try {
                if (resultSet != null && resultSet.getStatement() != null) {
                    resultSet.getStatement().close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            }
            logger.severe(exception.getMessage());
        }
        return resultSet;
    }

    public List<Map> executeReturnArrayList(String string, String string2, Map map) throws Exception {
        return this.executeReturnArrayList(conns.getConnection(string), string2, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map> executeReturnArrayList(Connection connection, String string, Map map) {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        ResultSet resultSet = this.executeQuery(connection, string, map);
        try {
            HashMap<String, Object> hashMap = null;
            while (resultSet.next()) {
                hashMap = new HashMap<String, Object>();
                for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                    hashMap.put(resultSet.getMetaData().getColumnName(i + 1), resultSet.getObject(i + 1));
                }
                arrayList.add(hashMap);
            }
        }
        catch (SQLException sQLException) {
            if (_raiseError) {
                ExceptionHandler.handleException(sQLException);
            } else {
                logger.severe(sQLException.getMessage());
            }
        }
        finally {
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> executeReturnHashMap(String string, String string2, Map map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ResultSet resultSet = this.executeQuery(string, string2, map);
        try {
            while (resultSet != null && resultSet.next()) {
                int n = 0;
                for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                    hashMap.put(n + "." + resultSet.getMetaData().getColumnName(i + 1), resultSet.getObject(i + 1));
                }
                ++n;
            }
        }
        catch (SQLException sQLException) {
            if (_raiseError) {
                ExceptionHandler.handleException(sQLException);
            } else {
                logger.severe(sQLException.getMessage());
            }
        }
        finally {
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    public void bind(PreparedStatement preparedStatement, Map map) throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = null;
        if (!(preparedStatement instanceof OraclePreparedStatement)) {
            Iterator iterator = map.values().iterator();
            ArrayList arrayList = new ArrayList(16);
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            this.bind(preparedStatement, arrayList);
            return;
        }
        oraclePreparedStatement = (OraclePreparedStatement)preparedStatement;
        String string2 = null;
        Object var5_7 = null;
        for (String string2 : map.keySet()) {
            var5_7 = map.get(string2);
            if (var5_7 == NULL_VALUE) {
                try {
                    oraclePreparedStatement.setNullAtName(string2, 12);
                }
                catch (Exception exception) {}
                continue;
            }
            if (var5_7 instanceof String) {
                try {
                    oraclePreparedStatement.setStringAtName(string2, (String)var5_7);
                }
                catch (Exception exception) {}
                continue;
            }
            if (var5_7 instanceof BigDecimal) {
                try {
                    oraclePreparedStatement.setBigDecimalAtName(string2, (BigDecimal)var5_7);
                }
                catch (Exception exception) {}
                continue;
            }
            if (var5_7 instanceof CLOB) {
                try {
                    oraclePreparedStatement.setCLOBAtName(string2, (CLOB)var5_7);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                oraclePreparedStatement.setObjectAtName(string2, var5_7);
            }
            catch (Exception exception) {}
        }
    }

    public void bind(PreparedStatement preparedStatement, List list) throws SQLException {
        Object var3_3 = null;
        int n = 1;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            var3_3 = list.get(i);
            if (var3_3 == NULL_VALUE || var3_3 instanceof String && ((String)var3_3).equals("")) {
                preparedStatement.setNull(n, 12);
            } else if (var3_3 instanceof String) {
                preparedStatement.setString(n, var3_3);
            } else if (var3_3 instanceof BigDecimal) {
                preparedStatement.setBigDecimal(n, var3_3);
            } else if (var3_3 instanceof Date) {
                preparedStatement.setDate(n, var3_3);
            } else if (var3_3 instanceof Integer) {
                preparedStatement.setInt(n, (Integer)var3_3);
            }
            ++n;
        }
    }

    public String getDBMSOUTPUT(String string) {
        String string2 = null;
        try {
            string2 = this.getDBMSOUTPUT(conns.getConnection(string));
        }
        catch (Exception exception) {
            if (_raiseError) {
                ExceptionHandler.handleException(exception);
            }
            logger.severe(exception.getMessage());
        }
        return string2;
    }

    private boolean largeBuffer(Connection connection) {
        boolean bl = false;
        int[] nArray = DBUtil.getDbVersion(connection).toIntArray();
        if (nArray[0] > 10) {
            bl = true;
        } else if (nArray[0] == 10 && nArray[1] >= 2) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDBMSOUTPUT(Connection connection) {
        StringBuilder stringBuilder = new StringBuilder();
        Statement statement = null;
        try {
            if (this.largeBuffer(connection)) {
                statement = connection.prepareCall("declare     l_line varchar2(32767);     l_done number;     l_buffer varchar2(32767) := '';    l_lengthbuffer number := 0;    l_lengthline number := 0;  begin   loop     dbms_output.get_line( l_line, l_done );     if (l_buffer is null) then       l_lengthbuffer := 0;     else       l_lengthbuffer := length(l_buffer);     end if;     if (l_line is null) then       l_lengthline := 0;     else       l_lengthline := length(l_line);     end if;     exit when l_lengthbuffer + l_lengthline > :maxbytes OR l_lengthbuffer + l_lengthline > 32767 OR l_done = 1;     l_buffer := l_buffer || l_line || chr(10);   end loop;  :done := l_done;  :buffer := l_buffer;  :line := l_line; end;");
                statement.registerOutParameter(2, 4);
                statement.registerOutParameter(3, 12);
                statement.registerOutParameter(4, 12);
            } else {
                statement = connection.prepareCall("declare     l_line varchar2(255);     l_done number;     l_buffer long; begin   loop     exit when length(l_buffer)+255 > :maxbytes OR l_done = 1;     dbms_output.get_line( l_line, l_done );     l_buffer := l_buffer || l_line || chr(10);   end loop;  :done := l_done;  :buffer := l_buffer; end;");
                statement.registerOutParameter(2, 4);
                statement.registerOutParameter(3, 12);
            }
            do {
                statement.setInt(1, 1000);
                statement.executeUpdate();
                if (this.largeBuffer(connection)) {
                    String string = statement.getString(3);
                    if (string != null) {
                        stringBuilder.append(string);
                    }
                    if ((string = statement.getString(4)) != null) {
                        stringBuilder.append(string + "\n");
                        continue;
                    }
                    stringBuilder.append("\n");
                    continue;
                }
                stringBuilder.append(statement.getString(3));
            } while (statement.getInt(2) != 1);
        }
        catch (SQLException sQLException) {
            logger.severe("Could not get DBMS_OUTPUT" + sQLException.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return stringBuilder.toString();
    }

    public void handleException(Exception exception) {
        String string = exception.getMessage();
        LogManager.getLogManager().getMsgPage().log((Object)string);
    }

    public void close(Statement statement) {
        try {
            statement.close();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public static synchronized boolean checkVersion(String string, Version version, Version version2) {
        Version version3 = null;
        if (VERSION_NAME_BASED_CACHE.containsKey(string)) {
            version3 = VERSION_NAME_BASED_CACHE.get(string);
        } else {
            try {
                version3 = DBUtil.getDbVersion(conns.getConnection(string));
                VERSION_NAME_BASED_CACHE.put(string, version3);
            }
            catch (DBException dBException) {
                Logger.getLogger(DBUtil.class.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
        }
        return DBUtil.checkVersion(version3, version, version2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getDbVersion(Connection connection) {
        if (connection == null) {
            return new Version("10.0");
        }
        Version version = VERSION_CACHE.get(connection);
        if (version == null) {
            Matcher matcher;
            String string;
            block17: {
                DatabaseMetaData databaseMetaData = null;
                string = "10.0";
                if (conns.lock(connection)) {
                    try {
                        databaseMetaData = connection.getMetaData();
                        if (connection instanceof OracleConnection) {
                            string = databaseMetaData.getDatabaseProductVersion();
                            break block17;
                        }
                        try {
                            string = databaseMetaData.getDatabaseMajorVersion() + "." + databaseMetaData.getDatabaseMinorVersion() + ".0";
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof ThreadDeath) {
                                throw (ThreadDeath)throwable;
                            }
                            try {
                                string = databaseMetaData.getDatabaseProductVersion();
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                string = "1.0.0";
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                    }
                    finally {
                        conns.unlock(connection);
                    }
                }
            }
            String string2 = (matcher = s_pattern.matcher(string)).find() ? matcher.group() : "1.0.0";
            version = new Version(string2);
            HashMap<Connection, Version> hashMap = VERSION_CACHE;
            synchronized (hashMap) {
                VERSION_CACHE.put(connection, version);
            }
        }
        return version;
    }

    public static boolean checkVersion(Connection connection, Version version, Version version2) {
        Version version3;
        try {
            version3 = DBUtil.getDbVersion(connection);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            version3 = null;
        }
        return DBUtil.checkVersion(version3, version, version2);
    }

    public static boolean checkVersion(Version version, Version version2, Version version3) {
        boolean bl = false;
        if (version == null || (version3 == null || version3.compareTo((Object)version) <= 0) && (version2 == null || version2.compareTo((Object)version) >= 0)) {
            bl = true;
        }
        return bl;
    }

    public String getCurrentError() {
        if (_currentErrorString != null) {
            return _currentErrorString;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorOffset(Connection connection, String string) {
        int n = 0;
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(ERR_SQL);
            logger.info("Prepared: declare  l_theCursor     integer default dbms_sql.open_cursor;  l_status        integer default -1 ;  insqlsix        VARCHAR2(6);  begin    insqlsix:=upper(substr(ltrim(?),1,6));   if ((insqlsix  in ( 'CREATE' ,'INSERT', 'UPDATE', 'DELETE', 'SELECT') )     OR(substr(insqlsix,1,5)='MERGE')      OR(substr(insqlsix,1,4)='WITH') OR (substr(insqlsix,1,1)='(')) then      begin      l_status := -2;      dbms_sql.parse(  l_theCursor, ?, dbms_sql.native );      exception           when others then             l_status := dbms_sql.last_error_position;      end;      dbms_sql.close_cursor( l_theCursor );    end if;     ? := l_status;   end;");
            callableStatement.setString(1, string);
            callableStatement.setString(2, string);
            callableStatement.registerOutParameter(3, 4);
            callableStatement.execute();
            n = callableStatement.getInt(3);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            if (callableStatement != null) {
                try {
                    callableStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return n;
    }

    public static String enquote(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) < 'A' && (string.charAt(i) < '0' || string.charAt(i) > '9') && string.charAt(i) != '#' && string.charAt(i) != '$' || string.charAt(i) > 'Z' && string.charAt(i) != '_' && string.charAt(i) >= 'a' && string.charAt(i) <= 'z') {
                bl = true;
            }
            if (string.charAt(i) != '\"') continue;
            bl = false;
        }
        if (bl) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public void setRaiseError(boolean bl) {
        _raiseError = bl;
    }

    public static List<String> getBinds(String string) {
        return Parser.getInstance().getBindNames(string);
    }

    public static List<String> getBinds(String string, boolean bl) {
        return Parser.getInstance().getBindNames(string, bl);
    }

    public void bind(String string, PreparedStatement preparedStatement, Map map) throws SQLException {
        if (map != null) {
            HashMap hashMap = new HashMap();
            Iterator iterator = map.keySet().iterator();
            String string2 = null;
            Object var7_7 = null;
            HashSet<String> hashSet = new HashSet<String>(DBUtil.getBinds(string));
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                var7_7 = map.get(string2);
                if (!hashSet.contains(string2.intern())) continue;
                hashMap.put(string2, map.get(string2));
            }
            this.bind(preparedStatement, hashMap);
        }
    }

    public String scrubObjectName(String string) {
        if (string.indexOf("\"") > -1) {
            return string.replaceAll("\"", "");
        }
        return string.toUpperCase();
    }

    public String[] resolveDBLink(String string) {
        String[] stringArray = string.split("@");
        if (stringArray.length == 2) {
            return stringArray;
        }
        return null;
    }

    public Map<String, String> resolveName(String string, String string2) {
        try {
            return this.resolveName(conns.getConnection(string), string2);
        }
        catch (DBException dBException) {
            return null;
        }
    }

    public Map<String, String> resolveName(Connection connection, String string) {
        List<Map> list;
        String[] stringArray = string.split("\\.");
        String string2 = null;
        String string3 = null;
        if (stringArray.length == 2) {
            string2 = stringArray[1];
            string3 = stringArray[0];
        } else if (stringArray.length == 1) {
            string2 = stringArray[0];
            string3 = null;
        } else {
            string2 = string;
            string3 = null;
        }
        String string4 = null;
        string2 = this.scrubObjectName(string2);
        String[] stringArray2 = this.resolveDBLink(string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (stringArray2 != null) {
            string4 = "select object_type,owner,object_name,rank from (    select object_type,owner,object_name,0 rank    from all_objects@" + stringArray2[1] + "  where object_name = :NAME  " + "  and UPPER(owner) = nvl(:OWNER,UPPER(sys_context('USERENV', 'CURRENT_SCHEMA')))  " + "  and object_type not in ( 'SYNONYM' )   " + "  union all  " + "  select ao.object_type,ao.owner,ao.object_name,decode(UPPER(syn.owner), nvl(:OWNER,UPPER(sys_context('USERENV', 'CURRENT_SCHEMA'))),10,20)  " + "  from all_objects@" + stringArray2[1] + " ao,all_synonyms syn  " + "  where ao.owner = syn.table_owner  " + "  and   ao.object_name = syn.table_name  " + "  and   syn.synonym_name = :NAME  " + " ) where object_type not in ('PACKAGE BODY') order by rank";
            hashMap.put("NAME", stringArray2[0]);
            hashMap.put("OWNER", string3);
        } else {
            string4 = "select object_type,owner,object_name,rank from (    select object_type,owner,object_name,0 rank    from all_objects    where object_name = :NAME    and UPPER(owner) = nvl(:OWNER,UPPER(sys_context('USERENV', 'CURRENT_SCHEMA')))    and object_type not in ( 'SYNONYM' )     union all    select ao.object_type,ao.owner,ao.object_name,decode(UPPER(syn.owner), nvl(:OWNER,UPPER(sys_context('USERENV', 'CURRENT_SCHEMA'))),10,20)    from all_objects ao,all_synonyms syn    where ao.owner = syn.table_owner    and   ao.object_name = syn.table_name    and   syn.synonym_name = :NAME   ) where object_type not in ('PACKAGE BODY') order by rank";
            hashMap.put("NAME", string2);
            hashMap.put("OWNER", string3);
        }
        if (string3 != null) {
            string3 = this.scrubObjectName(string3);
        }
        if ((list = this.executeReturnArrayList(connection, string4, hashMap)).size() == 0 && string2 != null && string3 == null) {
            string4 = "select 'SCHEMA' object_type , :OWNER owner , :OWNER object_name from all_users where username = :OWNER";
            hashMap.put("OWNER", string2);
            list = this.executeReturnArrayList(connection, string4, hashMap);
        }
        Map map = null;
        if (list.size() > 0) {
            map = list.get(0);
        }
        if (map != null && map.get("OBJECT_TYPE") != null && ((String)map.get("OBJECT_TYPE")).indexOf("TABLE PARTITION") != -1) {
            map.put("OBJECT_TYPE", "TABLE");
        }
        return map;
    }

    public String prepareOracleSql(String string) {
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string, true);
        String string2 = string;
        int n = 1;
        for (Bind bind : arrayList) {
            string2 = string2.replaceFirst(":" + bind.getName(), ":ZSqlDevUnIq" + n);
            ++n;
        }
        return string2;
    }

    public String prepareNonOracleSql(String string) {
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string, true);
        String string2 = string;
        for (Bind bind : arrayList) {
            string2 = string2.replaceFirst(":" + bind.getName(), "?");
        }
        return string2;
    }

    public String prepareNonOracleSql(Connection connection, String string, Map map) {
        if (string.indexOf("{:") > 0) {
            return this.prepareNonOracleSqlMsgFormat(connection, string, map);
        }
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string, true);
        ArrayList arrayList2 = new ArrayList();
        String string2 = string;
        for (Bind bind : arrayList) {
            if (map != null) {
                arrayList2.add(map.get(bind.getName()));
            }
            string2 = string2.replaceFirst(":" + bind.getName(), "?");
        }
        return string2;
    }

    private String prepareNonOracleSqlMsgFormat(Connection connection, String string, Map map) {
        int n = 0;
        String string2 = string;
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string, true);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string3 = string;
        for (Bind bind : arrayList) {
            if (map == null) continue;
            if (map.get(bind.getName()) instanceof String) {
                String string4 = (String)map.get(bind.getName());
                string4 = this.addQuotes(connection, string4);
                arrayList2.add(string4);
            } else {
                arrayList2.add((String)map.get(bind.getName()));
            }
            string3 = string3.replaceFirst(":" + bind.getName(), Integer.toString(n++));
        }
        string2 = MessageFormat.format(string3, arrayList2.toArray());
        return string2;
    }

    public String addQuotes(Connection connection, String string) {
        String string2 = string.trim();
        try {
            string2 = conns.getDatabase(connection).quoteIdentifier(string, true);
        }
        catch (DBException dBException) {
            String string3 = conns.getDatabase(connection).getIdentifierQuoteString();
            string2 = string3 != null ? string3 + string + string3 : string;
        }
        return string2;
    }

    public String addQuotes(String string, String string2) {
        Connection connection = null;
        try {
            connection = conns.getConnection(string);
        }
        catch (DBException dBException) {
            ExceptionHandler.handleException((Exception)((Object)dBException));
        }
        return this.addQuotes(connection, string2);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(DBUtil.enquote("\"test\""));
        System.out.println("\"test\"");
    }

    public static boolean hasTransaction(String string) {
        if (conns.isOracle(string)) {
            try {
                String string2;
                Connection connection = conns.getConnection(string);
                if (connection == null || connection.isClosed()) {
                    return false;
                }
                ResultSet resultSet = DBUtil.getInstance().executeOracleQuery(connection, HAS_TRANSACTION_QUERY, null);
                if (resultSet.next() && (string2 = resultSet.getString(1)) != null && !string2.equals("")) {
                    return true;
                }
            }
            catch (SQLException sQLException) {
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOracleConnectionAlive(Connection connection) throws SQLException, DBException {
        if (connection == null) {
            return false;
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(ORACLE_CONNECTION_ALIVE_QUERY);
            boolean bl = true;
            return bl;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    static {
        VERSION_CACHE = new HashMap();
        VERSION_NAME_BASED_CACHE = new HashMap();
        logger = Logger.getLogger(DBUtil.class.getName());
        s_pattern = Pattern.compile(VERSION_PATTERN);
    }
}

