/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.util;

import java.net.URL;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controller.PropertyResolver;
import oracle.ide.util.GraphicsUtils;
import oracle.javatools.util.BundleLoader;
import oracle.javatools.util.NullResourceBundle;

public class BundlePropertyResolver
extends PropertyResolver {
    private String _resBundleClass;
    private ClassLoader _resBundleClassLoader;
    private Map _actionKeyToBundleKey;
    private String _actionNameBundleKey;
    private ResourceBundle _resBundle;

    public BundlePropertyResolver(String bundleClass, ClassLoader bundleClassLoader, Map actionKeyToBundleKey) {
        if (bundleClass == null) {
            throw new NullPointerException("bundleClass is null");
        }
        if (bundleClass.trim().length() == 0) {
            throw new IllegalArgumentException("bundleClass is an empty string");
        }
        if (bundleClassLoader == null) {
            bundleClassLoader = Thread.currentThread().getContextClassLoader();
        }
        this._resBundleClass = bundleClass;
        this._resBundleClassLoader = bundleClassLoader;
        this._actionKeyToBundleKey = actionKeyToBundleKey;
        this._actionNameBundleKey = this._actionKeyToBundleKey != null ? (String)this._actionKeyToBundleKey.get("Name") : null;
    }

    public Object get(String key) {
        try {
            String value = this.getFromBundle(key);
            if (value != null) {
                if (key == "SmallIcon") {
                    URL url;
                    if (value.length() != 0 && (url = this.getBundle().getClass().getResource(value)) != null) {
                        ImageIcon imageIcon = GraphicsUtils.createImageIcon((URL)url);
                        return imageIcon;
                    }
                    Object var7_5 = null;
                    return var7_5;
                }
                if (key == "Name") {
                    value = StringUtils.stripMnemonic((String)value);
                }
            }
            if (key == "MnemonicKey") {
                int mnemonic;
                if (value != null && value.length() > 0) {
                    Integer n = value.charAt(0);
                    return n;
                }
                String name = this.getFromBundleImpl(this._actionNameBundleKey);
                if (name != null && (mnemonic = StringUtils.getMnemonicKeyCode((String)name)) != 0) {
                    Integer n = mnemonic;
                    return n;
                }
                Integer n = 0;
                try {
                    return n;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this._actionNameBundleKey = null;
                }
            }
            String string = value;
            return string;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.free();
        }
    }

    private String getFromBundle(String key) {
        if (this._actionKeyToBundleKey == null) {
            return null;
        }
        try {
            String string = this.getFromBundleImpl((String)this._actionKeyToBundleKey.get(key));
            return string;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this._actionKeyToBundleKey.remove(key);
            if (this._actionKeyToBundleKey.isEmpty()) {
                this._actionKeyToBundleKey = null;
            }
        }
    }

    private String getFromBundleImpl(String bundleKey) {
        if (bundleKey != null) {
            try {
                String string = this.getBundle().getString(bundleKey);
                return string;
            }
            catch (MissingResourceException mre) {
                String string = null;
                return string;
            }
        }
        return null;
    }

    private ResourceBundle getBundle() {
        if (this._resBundle == null && this._resBundleClass != null) {
            try {
                try {
                    this._resBundle = BundleLoader.getBundle((String)this._resBundleClass, (ClassLoader)this._resBundleClassLoader);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    NullResourceBundle nullResourceBundle = NullResourceBundle.instance();
                    this._resBundleClass = null;
                    this._resBundleClassLoader = null;
                    return nullResourceBundle;
                }
            }
            finally {
                this._resBundleClass = null;
                this._resBundleClassLoader = null;
            }
        }
        if (this._resBundle == null) {
            this._resBundle = NullResourceBundle.instance();
        }
        return this._resBundle;
    }

    private void free() {
        if (this._actionKeyToBundleKey == null || this._actionKeyToBundleKey.isEmpty()) {
            this._actionKeyToBundleKey = null;
            this._resBundle = null;
            this._resBundleClass = null;
            this._resBundleClassLoader = null;
        }
    }
}

