/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.xml;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.Node;
import oracle.ide.model.NodeInfo;
import oracle.ide.model.Recognizer;
import oracle.ide.model.RecognizerException;
import oracle.ide.model.XMLDataNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.NodeInfoLoader;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;

public final class XMLRecognizer
extends Recognizer {
    private static final XMLRecognizer _instance = new XMLRecognizer();
    private static final HashMap _xmlExtensions = new HashMap();
    private static final HashMap _nsElemToClass = new HashMap();
    private static final HashMap _xsiToClass = new HashMap();
    private static final HashMap _doctypeToClass = new HashMap();
    private static final HashMap _rootElementToClass = new HashMap();
    private static final HashMap _classToNodeInfo = new HashMap();

    static {
        XMLRecognizer.treatExtensionAsXML(".xml");
    }

    private XMLRecognizer() {
    }

    public static XMLRecognizer getInstance() {
        return _instance;
    }

    public static void treatExtensionAsXML(String extension) {
        XMLRecognizer.treatExtensionAsXML(extension, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void treatExtensionAsXML(String extension, NodeInfoLoader loader) {
        XMLRecognizer.mapExtensionToXML(extension);
        if (ModelUtil.hasLength((String)extension)) {
            File fileExt = XMLRecognizer.sanitizeExtension(extension);
            HashMap hashMap = _xmlExtensions;
            synchronized (hashMap) {
                _xmlExtensions.put(fileExt, loader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapNamespaceElemToClass(String namespaceURI, String localElemName, Class cls) {
        if (cls != null && ModelUtil.hasLength((String)namespaceURI)) {
            HashMap hashMap = _nsElemToClass;
            synchronized (hashMap) {
                _nsElemToClass.put(new NSElem(namespaceURI, localElemName), cls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapSchemaInstanceToClass(String schemaLocationURI, String rootElemLocalName, Class nodeType) {
        if (nodeType != null && ModelUtil.hasLength((String)schemaLocationURI)) {
            HashMap hashMap = _xsiToClass;
            synchronized (hashMap) {
                _xsiToClass.put(new NSElem(schemaLocationURI, rootElemLocalName), nodeType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapDoctypeToClass(String publicId, String systemId, Class cls) {
        if (cls != null && (publicId != null || systemId != null)) {
            Doctype doctype = new Doctype(publicId, systemId);
            HashMap hashMap = _doctypeToClass;
            synchronized (hashMap) {
                _doctypeToClass.put(doctype, cls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapRootElementToClass(String rootElem, Class cls) {
        if (cls != null && ModelUtil.hasLength((String)rootElem)) {
            HashMap hashMap = _rootElementToClass;
            synchronized (hashMap) {
                _rootElementToClass.put(rootElem, cls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNodeInfo(NodeInfo info) {
        if (info != null) {
            Class dataClass = info.getDataClass();
            String rootElem = info.getXMLRootElement();
            String namespaceURI = info.getXMLNamespaceURI();
            if (ModelUtil.hasLength((String)namespaceURI)) {
                XMLRecognizer.mapNamespaceElemToClass(namespaceURI, rootElem, dataClass);
                Object2Dom.registerNamespaceElem((Class)dataClass, (String)namespaceURI, (String)rootElem);
            }
            XMLRecognizer.mapRootElementToClass(info.getXMLRootElement(), dataClass);
            HashMap hashMap = _classToNodeInfo;
            synchronized (hashMap) {
                _classToNodeInfo.put(dataClass, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeInfo findNodeInfo(Class dataClass) {
        if (dataClass == null) {
            return null;
        }
        HashMap hashMap = _classToNodeInfo;
        synchronized (hashMap) {
            NodeInfo nodeInfo = (NodeInfo)_classToNodeInfo.get(dataClass);
            return nodeInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class recognize(URL url) {
        block27: {
            try {
                String schemaLocationURI;
                StartElementPacket rootElem = XMLUtil.getXMLRootElement((URL)url);
                if (rootElem == null) break block27;
                XMLRecognizer.ensureNodeInfosLoaded(XMLRecognizer.sanitizeExtension(URLFileSystem.getSuffix((URL)url)));
                if (ModelUtil.hasLength((String)rootElem.namespaceURI)) {
                    String value;
                    if (rootElem.attributes != null && ModelUtil.hasLength((String)(value = rootElem.attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation")))) {
                        StringTokenizer stok = new StringTokenizer(value);
                        while (stok.hasMoreTokens()) {
                            String xmlns = stok.nextToken();
                            if (!rootElem.namespaceURI.equals(xmlns)) continue;
                            if (!stok.hasMoreTokens()) break;
                            String schemaLocationURI2 = stok.nextToken();
                            HashMap hashMap = _xsiToClass;
                            synchronized (hashMap) {
                                NSElem nsElem = new NSElem(schemaLocationURI2, rootElem.localName);
                                Object dataClass = _xsiToClass.get(nsElem);
                                if (dataClass != null) {
                                    Class clazz = (Class)dataClass;
                                    return clazz;
                                }
                            }
                        }
                    }
                    HashMap hashMap = _nsElemToClass;
                    synchronized (hashMap) {
                        NSElem nsElem = new NSElem(rootElem.namespaceURI, rootElem.localName);
                        Object dataClass = _nsElemToClass.get(nsElem);
                        if (dataClass != null) {
                            Class clazz = (Class)dataClass;
                            return clazz;
                        }
                    }
                }
                if (rootElem.attributes != null && ModelUtil.hasLength((String)(schemaLocationURI = rootElem.attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation")))) {
                    HashMap hashMap = _xsiToClass;
                    synchronized (hashMap) {
                        NSElem nsElem = new NSElem(schemaLocationURI, rootElem.localName);
                        Object dataClass = _xsiToClass.get(nsElem);
                        if (dataClass != null) {
                            Class clazz = (Class)dataClass;
                            return clazz;
                        }
                    }
                }
                if (rootElem.publicId != null || rootElem.systemId != null) {
                    HashMap hashMap = _doctypeToClass;
                    synchronized (hashMap) {
                        Doctype doctype = new Doctype(rootElem.publicId, rootElem.systemId);
                        Object dataClass = _doctypeToClass.get(doctype);
                        if (dataClass != null) {
                            Class clazz = (Class)dataClass;
                            return clazz;
                        }
                    }
                }
                HashMap hashMap = _rootElementToClass;
                synchronized (hashMap) {
                    Object dataClass = _rootElementToClass.get(rootElem.localName);
                    if (dataClass != null) {
                        Class clazz = (Class)dataClass;
                        return clazz;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public Node create(URL url, Class nodeType) throws IllegalAccessException, InstantiationException {
        if (url != null && nodeType != null) {
            NodeInfo nodeInfo = XMLRecognizer.findNodeInfo(nodeType);
            if (nodeInfo != null) {
                Class nodeInfoNodeClass = nodeInfo.getNodeClass();
                XMLDataNode node = (XMLDataNode)super.create(url, nodeInfoNodeClass);
                node.setNodeInfo(nodeInfo);
                return node;
            }
            return super.create(url, nodeType);
        }
        return null;
    }

    public URL validate(URL newURL, URL oldURL) throws RecognizerException {
        String extension = URLFileSystem.getSuffix((URL)newURL);
        if (XMLRecognizer.isXmlExtension(extension)) {
            return newURL;
        }
        if (this.recognize(oldURL) != null) {
            String oldExtension = URLFileSystem.getSuffix((URL)oldURL);
            try {
                String newPath = newURL.getPath() + oldExtension;
                URL uRL = URLFactory.replacePathPart((URL)newURL, (String)newPath);
                return uRL;
            }
            catch (Exception e) {
                throw new RecognizerException("Internal exception: Unable to build new URL: " + e.getLocalizedMessage());
            }
        }
        throw new RecognizerException("Internal exception: Old URL not recognized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureNodeInfosLoaded(File fileExt) {
        HashMap hashMap = _xmlExtensions;
        synchronized (hashMap) {
            Object loader = _xmlExtensions.get(fileExt);
            if (loader != null) {
                ((NodeInfoLoader)loader).loadNodeInfos();
                _xmlExtensions.put(fileExt, null);
            }
        }
    }

    private static final class NSElem {
        final String namespaceURI;
        final String localElemName;
        private Integer _hashCode;

        NSElem(String namespaceURI, String localElemName) {
            this.namespaceURI = namespaceURI;
            this.localElemName = localElemName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NSElem)) {
                return false;
            }
            NSElem other = (NSElem)o;
            return ModelUtil.areEqual((Object)this.namespaceURI, (Object)other.namespaceURI) && ModelUtil.areEqual((Object)this.localElemName, (Object)other.localElemName);
        }

        public int hashCode() {
            if (this._hashCode == null) {
                int hcUri = this.namespaceURI != null ? this.namespaceURI.hashCode() : 0;
                int hcElem = this.localElemName != null ? this.localElemName.hashCode() : 0;
                this._hashCode = hcUri ^ hcElem;
            }
            return this._hashCode;
        }
    }

    private static final class Doctype {
        final String publicId;
        final String systemId;
        private Integer _hashCode;

        Doctype(String publicId, String systemId) {
            this.publicId = publicId;
            this.systemId = systemId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Doctype)) {
                return false;
            }
            Doctype other = (Doctype)o;
            if (this.publicId == null || other.publicId == null) {
                return ModelUtil.areEqual((Object)this.systemId, (Object)other.systemId);
            }
            return this.publicId.equals(other.publicId);
        }

        public int hashCode() {
            if (this._hashCode == null) {
                int hashCode = this.publicId != null ? this.publicId.hashCode() : (this.systemId != null ? this.systemId.hashCode() : 0);
                this._hashCode = hashCode;
            }
            return this._hashCode;
        }
    }
}

