/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JDialog;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.CommitNotifier;
import oracle.ide.resource.WizardArb;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.FinishPanel;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.javatools.util.ModelUtil;

public class GenericWizardLauncher
implements CommitNotifier {
    private ArrayList _stepList;
    private boolean _showStepNumber;
    private String _wizardTitle;
    private boolean _welcomePageAdded;
    private boolean _finishPageAdded;
    private Image _wizardImage;
    private Color[] _gradientColors;
    private EventListenerList _listeners;
    private Namespace _namespace;
    public static final Color[] WIZARD_HEADER_GRADIENT = new Color[]{new Color(255, 255, 255), new Color(206, 223, 230)};
    public static final String CONTEXT_KEY = "Context";
    public static final String WIZARD_NAME_KEY = "WizardName";

    private void $init$() {
        this._stepList = new ArrayList();
        this._showStepNumber = false;
        this._wizardTitle = null;
        this._welcomePageAdded = false;
        this._finishPageAdded = false;
        this._wizardImage = null;
        this._gradientColors = null;
        this._listeners = null;
        this._namespace = new Namespace();
    }

    public GenericWizardLauncher(Context initContext) {
        this.$init$();
        this._namespace.put(CONTEXT_KEY, (Object)initContext);
    }

    public GenericWizardLauncher(Context initContext, String wizardTitle) {
        this(initContext);
        this._wizardTitle = wizardTitle;
    }

    public final Namespace getNamespace() {
        return this._namespace;
    }

    public void setWizardTitle(String title) {
        this._wizardTitle = title;
    }

    public String getWizardTitle() {
        return this._wizardTitle;
    }

    public void setGradientColors(Color[] gradientColors) {
        this._gradientColors = gradientColors;
    }

    public Color[] getGradientColors() {
        if (this._gradientColors == null) {
            return WIZARD_HEADER_GRADIENT;
        }
        return this._gradientColors;
    }

    public void setWizardImage(Image image) {
        this._wizardImage = image;
    }

    public Image getWizardImage() {
        return this._wizardImage;
    }

    public boolean addWelcomePage(String welcomePageClassStr, String helpID, String pageTitle) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(welcomePageClassStr);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        Step step = new Step(clazz);
        if (ModelUtil.hasLength((String)pageTitle)) {
            step.setPageTitle(pageTitle);
        }
        this._addWelcomeStep(step, helpID);
        return true;
    }

    public void addWelcomePage(String welcomeText, String descriptiveText, String saveKey, String helpId) {
        if (saveKey == null || saveKey.length() == 0) {
            throw new IllegalArgumentException("The specified saveKey must not be null or empty.  Please pass a non-null key that uniquely identifies your wizard for preferences purposes, such as the fully-qualified name of your wizard class.");
        }
        Class[] argTypeArray = new Class[4];
        int i = 0;
        while (i < 4) {
            argTypeArray[i] = String.class;
            ++i;
        }
        Object[] argValueArray = new Object[]{this._wizardTitle, welcomeText, descriptiveText, saveKey};
        this._addWelcomeStep(new Step(WelcomePanel.class, argTypeArray, argValueArray), helpId);
    }

    public void addFinishPage(String helpId) {
        this.addFinishPage(WizardArb.getString(0), "", WizardArb.getString(1), helpId);
    }

    public void addFinishPage(String finishText, String descText, String title, String helpId) {
        Class[] argTypes = new Class[]{String.class, String.class};
        Object[] argVals = new Object[]{finishText, descText};
        Step step = new Step(FinishPanel.class, argTypes, argVals);
        if (!ModelUtil.hasLength((String)title)) {
            title = WizardArb.getString(1);
        }
        step.setPageTitle(title);
        this._addFinishStep(step, helpId);
    }

    public boolean addFinishPage(String finishPageClassStr, String helpID, String pageTitle) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(finishPageClassStr);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        Step step = new Step(clazz);
        if (ModelUtil.hasLength((String)pageTitle)) {
            step.setPageTitle(pageTitle);
        }
        this._addFinishStep(step, helpID);
        return true;
    }

    public boolean addPage(String pageClass) {
        return this.addPage(pageClass, null, null);
    }

    public boolean addPage(String pageClass, String helpID) {
        return this.addPage(pageClass, helpID, null);
    }

    public boolean addPage(String pageClassStr, String helpID, String pageTitle) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(pageClassStr);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        Step step = new Step(clazz);
        if (ModelUtil.hasLength((String)helpID)) {
            step.setHelpID(helpID);
        }
        if (ModelUtil.hasLength((String)pageTitle)) {
            step.setPageTitle(pageTitle);
        }
        this.addPage(step);
        return true;
    }

    public void addPage(Step step) {
        this._stepList.add(step);
    }

    public void addPages(Step[] steps) {
        this._stepList.addAll(Arrays.asList(steps));
    }

    public boolean runGenericWizard() {
        FSMWizard fsmWiz = new FSMWizard(this._getTraversableSteps(), this._namespace);
        fsmWiz.setHeaderGradientBackground(this.getGradientColors());
        fsmWiz.setWizardTitle(this._wizardTitle);
        fsmWiz.setShowStepNumber(this._showStepNumber);
        fsmWiz.setWelcomePageAdded(this._welcomePageAdded);
        fsmWiz.setFinishPageAdded(this._finishPageAdded);
        if (this._wizardImage != null) {
            fsmWiz.setLogoImage(this._wizardImage);
        }
        if (ModelUtil.hasLength((String)this.getWizardTitle())) {
            this._namespace.put(WIZARD_NAME_KEY, (Object)this.getWizardTitle());
        }
        if (this._listeners != null) {
            CommitListener[] cListeners = (CommitListener[])this._listeners.getListeners(CommitListener.class);
            int i = 0;
            while (i < cListeners.length) {
                fsmWiz.addCommitListener(cListeners[i]);
                ++i;
            }
        }
        WizardDialog wd = fsmWiz.getDialog((Frame)((Object)Ide.getMainWindow()));
        return WizardLauncher.runDialog((JDialog)wd);
    }

    public boolean getShowStepNumber() {
        return this._showStepNumber;
    }

    public void setShowStepNumber(boolean showStepNumber) {
        this._showStepNumber = showStepNumber;
    }

    public void addCommitListener(CommitListener commitListener) {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        this._listeners.add(CommitListener.class, commitListener);
    }

    public void removeCommitListener(CommitListener commitListener) {
        if (this._listeners != null) {
            this._listeners.remove(CommitListener.class, commitListener);
        }
    }

    private void _addWelcomeStep(Step step, String helpId) {
        if (ModelUtil.hasLength((String)helpId)) {
            step.setHelpID(helpId);
        }
        this._stepList.add(0, step);
        this._welcomePageAdded = true;
    }

    private void _addFinishStep(Step step, String helpId) {
        if (ModelUtil.hasLength((String)helpId)) {
            step.setHelpID(helpId);
        }
        this._stepList.add(step);
        this._finishPageAdded = true;
    }

    private Step[] _getTraversableSteps() {
        if (!this._finishPageAdded) {
            this.addFinishPage(null);
        }
        return this._stepList.toArray(new Step[this._stepList.size()]);
    }
}

