/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vcs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.naming.Context;
import oracle.ide.Addin;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCSListener;
import oracle.javatools.jndi.Names;

public abstract class VCSManager
implements Addin {
    private static final String VCS_MANAGER_NAME = "ide/vcs-manager";

    public static VCSManager getVCSManager() {
        VCSManager vcsManager = (VCSManager)Names.lookup((Context)Names.newInitialContext(), (String)VCS_MANAGER_NAME);
        return vcsManager != null ? vcsManager : NullVCSManager.getInstance();
    }

    public static void setVCSManager(VCSManager vcsManager) {
        Names.bind((Context)Names.newInitialContext(), (String)VCS_MANAGER_NAME, (Object)vcsManager);
    }

    public abstract boolean isVersioned(URL var1);

    public abstract boolean isAutoCheckOutEnabled(URL var1);

    public abstract boolean canCheckOut(URL var1);

    public abstract boolean setReadWrite(URL[] var1);

    public abstract boolean checkOutNode(Node var1);

    public abstract boolean checkOutNode(Node var1, CommandProcessor var2);

    public abstract String getCheckOutCommand(Node var1);

    public abstract void validateStatus(URL var1);

    public abstract void validateStatus(URLFilter var1);

    public abstract void addVCSListener(VCSListener var1, URLFilter var2);

    public abstract void removeVCSListener(VCSListener var1);

    public abstract String getVersionName(URL var1);

    public abstract void registerWorkspaceArtifact(String var1);

    public abstract void deregisterWorkspaceArtifact(String var1);

    public abstract boolean containsConflicts(URL var1);

    public abstract InputStream openConflictsStreamAsContributor(URL var1) throws IOException;

    public abstract ContextMenuListener[] getContextMenuListeners();

    private static class NullVCSManager
    extends VCSManager {
        private static final NullVCSManager _instance = new NullVCSManager();

        public static NullVCSManager getInstance() {
            return _instance;
        }

        public void initialize() {
        }

        public boolean isVersioned(URL url) {
            return false;
        }

        public boolean isAutoCheckOutEnabled(URL url) {
            return false;
        }

        public boolean canCheckOut(URL url) {
            return false;
        }

        public boolean checkOutNode(Node node) {
            return false;
        }

        public boolean checkOutNode(Node node, CommandProcessor processor) {
            return false;
        }

        public String getCheckOutCommand(Node node) {
            return null;
        }

        public void validateStatus(URL url) {
        }

        public void validateStatus(URLFilter filter) {
        }

        public void addVCSListener(VCSListener listener, URLFilter filter) {
        }

        public void removeVCSListener(VCSListener listener) {
        }

        public String getVersionName(URL url) {
            return null;
        }

        public boolean setReadWrite(URL[] urls) {
            return false;
        }

        public void registerWorkspaceArtifact(String path) {
        }

        public void deregisterWorkspaceArtifact(String path) {
        }

        public boolean containsConflicts(URL url) {
            return false;
        }

        public InputStream openConflictsStreamAsContributor(URL url) throws IOException {
            return URLFileSystem.openInputStream((URL)url);
        }

        public ContextMenuListener[] getContextMenuListeners() {
            return new ContextMenuListener[0];
        }

        private NullVCSManager() {
        }
    }
}

