/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util.macro;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import oracle.ide.util.macro.MacroConverter;
import oracle.ide.util.macro.StringMacroConverter;

public class FileMacroConverter
implements MacroConverter {
    private int _converterType;
    private StringMacroConverter _lineConverter;

    private void $init$() {
        this._converterType = -1;
        this._lineConverter = null;
    }

    private FileMacroConverter(int converterType) {
        this.$init$();
        this._converterType = converterType;
        this._lineConverter = StringMacroConverter.getConverter(this._converterType);
    }

    public boolean expandFile(File src, Writer dest, Map macros) {
        try {
            this.expandFile(new FileReader(src), dest, macros);
        }
        catch (FileNotFoundException fnfEx) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public boolean expandFile(File src, File dest, Map macros) {
        try {
            File parentDir = new File(dest.getParent());
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            this.expandFile(new FileReader(src), (Writer)new FileWriter(dest), macros);
        }
        catch (FileNotFoundException fnfEx) {
            boolean bl = false;
            return bl;
        }
        catch (IOException ioEx) {
            boolean bl = false;
            return bl;
        }
        catch (NullPointerException npEx) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public boolean expandFile(Reader src, Writer dest, Map macros) {
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            try {
                in = new BufferedReader(src);
                out = new BufferedWriter(dest);
                String line = in.readLine();
                while (line != null) {
                    String newline = null;
                    if (line.length() > 0) {
                        newline = this._lineConverter.expandString(line, macros);
                        out.write(newline);
                    }
                    out.newLine();
                    line = in.readLine();
                }
            }
            catch (Exception ex) {
                boolean bl = false;
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bl;
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception ioEx) {}
            try {
                in.close();
            }
            catch (Exception ioEx) {}
        }
        return true;
    }

    public static FileMacroConverter getConverter(int converterType) {
        return new FileMacroConverter(converterType);
    }
}

