/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.StringTokenizer;
import oracle.javatools.marshal.StringConversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionNumber
implements Comparable,
StringConversion {
    private final String[] _versionParts;
    private transient int _hash;

    public VersionNumber(String versionString) {
        StringTokenizer st = new StringTokenizer(versionString, ".");
        int numTokens = st.countTokens();
        this._versionParts = new String[numTokens];
        int i = 0;
        while (st.hasMoreTokens()) {
            this._versionParts[i] = st.nextToken();
            ++i;
        }
    }

    public int countParts() {
        return this._versionParts.length;
    }

    public String getPart(int offset) {
        if (offset < 0 || offset >= this._versionParts.length) {
            return null;
        }
        return this._versionParts[offset];
    }

    public final boolean isAfter(VersionNumber version) {
        int compare = this.compareToImpl(version);
        return compare > 0;
    }

    public final boolean isAfter(VersionNumber version, boolean orEquals) {
        int compare = this.compareToImpl(version);
        return orEquals ? compare >= 0 : compare > 0;
    }

    public final boolean isBefore(VersionNumber version) {
        int compare = this.compareToImpl(version);
        return compare < 0;
    }

    public boolean isBefore(VersionNumber version, boolean orEquals) {
        int compare = this.compareToImpl(version);
        return orEquals ? compare <= 0 : compare < 0;
    }

    public int compareTo(Object o) {
        return this.compareToImpl((VersionNumber)o);
    }

    private int compareToImpl(VersionNumber other) {
        if (other == null) {
            return 1;
        }
        int myParts = this._versionParts.length;
        int otherParts = other.countParts();
        int i = 0;
        while (i < myParts) {
            block9: {
                String otherPart = other.getPart(i);
                if (otherPart == null) {
                    return 1;
                }
                String myPart = this._versionParts[i];
                try {
                    int myInt = Integer.parseInt(myPart);
                    int otherInt = Integer.parseInt(otherPart);
                    if (myInt < otherInt) {
                        int n = -1;
                        return n;
                    }
                    if (myInt > otherInt) {
                        int n = 1;
                        return n;
                    }
                }
                catch (NumberFormatException nfe) {
                    int compare = myPart.compareTo(otherPart);
                    if (compare < 0) {
                        int n = -1;
                        return n;
                    }
                    if (compare <= 0) break block9;
                    int n = 1;
                    return n;
                }
            }
            ++i;
        }
        if (myParts == otherParts) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((VersionNumber)o);
    }

    private boolean equalsImpl(VersionNumber other) {
        int n = this._versionParts.length;
        if (n != other.countParts()) {
            return false;
        }
        int i = 0;
        while (i < n) {
            String otherVersionPart = other.getPart(i);
            if (otherVersionPart == null || !otherVersionPart.equals(this._versionParts[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int h = this._hash;
        if (h == 0) {
            int len = this._versionParts.length;
            int i = 0;
            while (i < len) {
                h = 31 * h + Integer.parseInt(this._versionParts[i]);
                ++i;
            }
            this._hash = h;
        }
        return h;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(25);
        int n = this._versionParts.length;
        int i = 0;
        while (i < n) {
            sb.append(this._versionParts[i]).append('.');
            ++i;
        }
        if (n > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

