/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

public final class PatternFilters
extends HashStructureAdapter {
    public static final String DATA_KEY = "pattern-filters";
    private transient PatternFilter[] _filters;

    private PatternFilters(HashStructure contentSetHash) {
        super(contentSetHash);
        this.refreshFilters();
    }

    private void refreshFilters() {
        ListStructure list = this._hash.getListStructure(DATA_KEY);
        if (list != null) {
            ArrayList<PatternFilter> filters = new ArrayList<PatternFilter>();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String str = iter.next().toString();
                filters.add(PatternFilter.fromStr(str));
            }
            this._filters = PatternFilters.toArray(filters);
        } else {
            this._filters = null;
        }
    }

    public static PatternFilters getInstance(HashStructure contentSetHash) {
        return new PatternFilters(contentSetHash);
    }

    public Object copyTo(Object target) {
        PatternFilters copy = (PatternFilters)((Object)super.copyTo(target));
        copy.refreshFilters();
        return copy;
    }

    public PatternFilter[] getFilters() {
        return this._filters != null ? (PatternFilter[])this._filters.clone() : null;
    }

    public void setFilters(PatternFilter[] filters) {
        if (filters != null) {
            int n = filters.length;
            int i = 0;
            while (i < n) {
                if (filters[i] == null) {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            if (this._filters != null && Arrays.equals(this._filters, filters)) {
                return;
            }
        }
        this._filters = filters;
        this.updateListStructure();
    }

    public void addInclude(String pattern) {
        this.addInclude(pattern, true);
    }

    public void addInclude(String pattern, boolean simplify) {
        if (pattern != null) {
            this.addFilterImpl(PatternFilter.newInclude(pattern), simplify);
        }
    }

    public void addExclude(String pattern) {
        this.addExclude(pattern, true);
    }

    public void addExclude(String pattern, boolean simplify) {
        if (pattern != null) {
            this.addFilterImpl(PatternFilter.newExclude(pattern), simplify);
        }
    }

    public boolean containsFilters() {
        return this._hash.containsKey(DATA_KEY);
    }

    public void removeFilters() {
        this._hash.remove(DATA_KEY);
    }

    public static boolean containsFilters(HashStructure contentSetHash) {
        return contentSetHash.containsKey(DATA_KEY);
    }

    public static void removeFilters(HashStructure contentSetHash) {
        contentSetHash.remove(DATA_KEY);
    }

    public PatternFilter findMatchingFilter(String path) {
        if (this._filters != null) {
            int n = this._filters.length;
            int i = 0;
            while (i < n) {
                PatternFilter filter = this._filters[i];
                if (filter != null && filter.matches(path)) {
                    return filter;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean isIncluded(String path) {
        PatternFilter matchingFilter = this.findMatchingFilter(path);
        return matchingFilter != null ? matchingFilter.isInclude() : false;
    }

    public TriStateBoolean inferFromFilters(String relPath) {
        if (this._filters != null) {
            int n = this._filters.length;
            int i = 0;
            while (i < n) {
                PatternFilter filter = this._filters[i];
                if (filter != null) {
                    int consumeType = filter.consumes(relPath);
                    if (consumeType == 0) {
                        if (filter.isInclude()) {
                            return TriStateBoolean.TRI_STATE;
                        }
                    } else if (consumeType == 1) {
                        return TriStateBoolean.getState((boolean)filter.isInclude());
                    }
                }
                ++i;
            }
        }
        return TriStateBoolean.FALSE;
    }

    private void addFilterImpl(PatternFilter filter, boolean simplify) {
        ArrayList<PatternFilter> filtersList;
        block23: {
            String pattern = filter.getPattern();
            filtersList = new ArrayList<PatternFilter>();
            if (this._filters != null) {
                filtersList.addAll(Arrays.asList(this._filters));
            }
            if (filtersList.size() == 0) {
                if (filter.isExclude()) {
                    return;
                }
            } else if (simplify) {
                PatternFilter firstFilter;
                if ("**".equals(pattern) && (firstFilter = (PatternFilter)filtersList.get(0)) != null && "**".equals(firstFilter.getPattern())) {
                    filtersList.remove(0);
                }
                if (!PatternFilters.containsWildcard(pattern)) {
                    Iterator iterSimplify = filtersList.iterator();
                    boolean matchingAntagonistRemoved = false;
                    while (iterSimplify.hasNext()) {
                        PatternFilter curFilter = (PatternFilter)iterSimplify.next();
                        if (curFilter == null) continue;
                        String curPattern = curFilter.getPattern();
                        if (curPattern != null) {
                            if ("**".equals(curPattern)) {
                                if (curFilter.isInclude() == filter.isInclude()) {
                                    this.setFiltersImpl(filtersList);
                                    return;
                                }
                            } else if (curFilter.matches(pattern)) {
                                boolean isSameType;
                                boolean bl = isSameType = curFilter.isInclude() == filter.isInclude();
                                if (PatternFilters.containsWildcard(curPattern)) {
                                    if (isSameType) {
                                        this.setFiltersImpl(filtersList);
                                        return;
                                    }
                                } else {
                                    if (curPattern.equals(pattern)) {
                                        iterSimplify.remove();
                                        if (isSameType) continue;
                                        matchingAntagonistRemoved = true;
                                        continue;
                                    }
                                    if (isSameType) {
                                        this.setFiltersImpl(filtersList);
                                        return;
                                    }
                                }
                            } else {
                                if (curPattern.startsWith(pattern) && (pattern.endsWith("/") || curPattern.charAt(pattern.length()) == '/')) {
                                    iterSimplify.remove();
                                    continue;
                                }
                                if (!pattern.startsWith(curPattern) || !curPattern.endsWith("/") && pattern.charAt(curPattern.length()) != '/') continue;
                                if (curFilter.isInclude() == filter.isInclude()) {
                                    this.setFiltersImpl(filtersList);
                                    return;
                                }
                            }
                        }
                        break block23;
                    }
                    if (matchingAntagonistRemoved && filter.isExclude()) {
                        this.setFiltersImpl(filtersList);
                        return;
                    }
                    if (filtersList.size() == 0 && filter.isExclude()) {
                        this.setFiltersImpl(filtersList);
                        return;
                    }
                }
            }
        }
        filtersList.add(0, filter);
        this.setFiltersImpl(filtersList);
    }

    private void setFiltersImpl(ArrayList filtersList) {
        this._filters = PatternFilters.toArray(filtersList);
        this.updateListStructure();
    }

    private void updateListStructure() {
        if (this._filters == null) {
            this._hash.remove(DATA_KEY);
        } else {
            ListStructure list = this._hash.getListStructure(DATA_KEY);
            if (list == null) {
                list = ListStructure.newInstance();
                this._hash.putListStructure(DATA_KEY, list);
            }
            list.clear();
            int n = this._filters.length;
            int i = 0;
            while (i < n) {
                list.add((Object)this._filters[i].toStr());
                ++i;
            }
        }
    }

    private static PatternFilter[] toArray(ArrayList filters) {
        return filters.toArray(new PatternFilter[filters.size()]);
    }

    private static boolean containsWildcard(String pattern) {
        return pattern.indexOf(42) >= 0;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof PatternFilters && Arrays.equals(this._filters, ((PatternFilters)((Object)object))._filters);
    }

    public int hashCode() {
        int code = 0;
        if (this._filters == null) {
            return 0;
        }
        PatternFilter[] patternFilterArray = this._filters;
        int n = 0;
        while (n < patternFilterArray.length) {
            PatternFilter filter = patternFilterArray[n];
            code = code * 37 + filter.hashCode();
            ++n;
        }
        return code;
    }
}

