/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

public final class PatternFilter {
    private boolean _include;
    private String _pattern;
    static final int DOES_NOT_CONSUME = -1;
    static final int CONSUMES_ONLY = 0;
    static final int CONSUMES_AND_MATCHES = 1;
    private static int END = -1;
    private static int CHAR = 0;
    private static int SLASH = 1;
    private static int STAR = 2;
    private static int STARSTAR = 3;
    private static int QMARK = 4;

    private PatternFilter(boolean include, String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        this._include = include;
        this._pattern = pattern;
    }

    public static PatternFilter newInclude(String pattern) {
        return new PatternFilter(true, pattern);
    }

    public static PatternFilter newExclude(String pattern) {
        return new PatternFilter(false, pattern);
    }

    public static PatternFilter fromStr(String filterStr) {
        boolean include;
        if (filterStr == null || filterStr.length() < 2) {
            throw new IllegalArgumentException();
        }
        char filterType = filterStr.charAt(0);
        if (filterType == '-') {
            include = false;
        } else if (filterType == '+') {
            include = true;
        } else {
            throw new IllegalArgumentException("Filter type '" + filterType + "' not recognized.");
        }
        String pattern = filterStr.substring(1);
        return new PatternFilter(include, pattern);
    }

    public String toStr() {
        StringBuffer buf = new StringBuffer(this._pattern.length() + 1);
        buf.append(this._include ? "+" : "-");
        buf.append(this._pattern);
        return buf.toString();
    }

    public boolean isInclude() {
        return this._include;
    }

    public boolean isExclude() {
        return this._include ^ true;
    }

    public boolean containsWildcard() {
        if (this._pattern != null) {
            return this._pattern.indexOf(42) >= 0;
        }
        return false;
    }

    public void setInclude(boolean include) {
        this._include = include;
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String pattern) {
        if (pattern != null && pattern.length() > 0) {
            this._pattern = pattern;
        }
    }

    public boolean matches(String path) {
        if (path == null) {
            return false;
        }
        if ("**".equals(this._pattern)) {
            return true;
        }
        return this.matchesImpl(path, new int[]{0, 0});
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this._pattern.length() + 1);
        buf.append(this._include ? "Include " : "Exclude ");
        buf.append(this._pattern);
        return buf.toString();
    }

    int consumes(String path) {
        if (this._pattern == null || path == null) {
            return -1;
        }
        if ("**".equals(this._pattern)) {
            return 1;
        }
        int[] indexes = new int[]{0, 0};
        boolean matches = this.matchesImpl(path, indexes);
        if (matches) {
            return 1;
        }
        if ("".equals(path) && this.isInclude()) {
            return 0;
        }
        int highestPathIndex = indexes[0];
        int highestPatternIndex = indexes[1];
        if (highestPathIndex == path.length() && (this._pattern.charAt(highestPatternIndex) == '/' || highestPathIndex > 0 && highestPatternIndex > 0 && this._pattern.charAt(highestPatternIndex - 1) == '/')) {
            return 0;
        }
        return -1;
    }

    private int nextPatternUnit_not_yet_complete(int[] indexes) {
        int iPattern = indexes[1];
        int nPattern = this._pattern.length();
        if (iPattern >= nPattern) {
            return END;
        }
        char c = this._pattern.charAt(iPattern++);
        switch (c) {
            case '*': {
                int numStars = 1;
                while (iPattern < nPattern) {
                    if (this._pattern.charAt(iPattern) == '*') {
                        ++numStars;
                        ++iPattern;
                        continue;
                    }
                    if (!"/**".equals(this._pattern.substring(iPattern, iPattern + 3))) break;
                    ++numStars;
                    iPattern += 3;
                }
                return numStars == 1 ? STAR : STARSTAR;
            }
            case '/': {
                return SLASH;
            }
            case '?': {
                return QMARK;
            }
        }
        return CHAR;
    }

    private boolean matchesImpl(String path, int[] indexes) {
        int iPath = indexes[0];
        int iPattern = indexes[1];
        try {
            int nPath = path.length();
            int nPattern = this._pattern.length();
            block13: while (iPath < nPath && iPattern < nPattern) {
                if (this._pattern.charAt(iPattern) == '*') {
                    boolean consumeSlash;
                    boolean slashLookbehind = true;
                    if (iPattern > 0) {
                        slashLookbehind = this._pattern.charAt(iPattern - 1) == '/';
                    }
                    int numStars = 0;
                    while (iPattern < nPattern && this._pattern.charAt(iPattern) == '*') {
                        ++numStars;
                        ++iPattern;
                    }
                    boolean bl = consumeSlash = numStars > 1;
                    if (iPattern >= nPattern) {
                        if (consumeSlash) {
                            boolean bl2 = true;
                            return bl2;
                        }
                        boolean bl3 = path.indexOf(47, iPath) < 0;
                        return bl3;
                    }
                    boolean slashLookahead = false;
                    if (consumeSlash && slashLookbehind) {
                        while (iPattern < nPattern && this._pattern.charAt(iPattern) == '/') {
                            slashLookahead = true;
                            ++iPattern;
                        }
                        if (iPattern >= nPattern) {
                            boolean bl4 = true;
                            return bl4;
                        }
                    }
                    char nextPatternChar = this._pattern.charAt(iPattern);
                    boolean slashStarStarSlash = slashLookbehind && slashLookahead;
                    char curPathChar = iPath > 0 ? path.charAt(iPath - 1) : (char)'\u0000';
                    while (iPath < nPath) {
                        char prevPathChar = curPathChar;
                        curPathChar = path.charAt(iPath);
                        if (!(curPathChar != nextPatternChar && nextPatternChar != '*' || !this.matchesImpl(path, new int[]{iPath, iPattern}) || (!slashStarStarSlash || prevPathChar != '/' && prevPathChar != '\u0000') && slashStarStarSlash)) {
                            boolean bl5 = true;
                            return bl5;
                        }
                        if (curPathChar == '/') {
                            if (!consumeSlash) continue block13;
                            if (this.matchesImpl(path, new int[]{iPath, iPattern})) {
                                boolean bl6 = true;
                                return bl6;
                            }
                        }
                        ++iPath;
                    }
                    continue;
                }
                if (this._pattern.charAt(iPattern) == path.charAt(iPath)) {
                    ++iPattern;
                    ++iPath;
                    continue;
                }
                boolean bl = false;
                return bl;
            }
            int tmp_iPattern = iPattern;
            while (iPattern < nPattern) {
                if (this._pattern.charAt(iPattern) != '*') break;
                ++iPattern;
            }
            if (iPattern < nPattern && this._pattern.charAt(iPattern) != '/') {
                iPattern = tmp_iPattern;
            }
            if (iPath == nPath) {
                boolean bl = iPattern == nPattern;
                return bl;
            }
            if (path.charAt(iPath) == '/') {
                boolean bl = true;
                return bl;
            }
            if (iPattern == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this._pattern.charAt(iPattern - 1) == '/';
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            indexes[0] = iPath;
            indexes[1] = iPattern;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PatternFilter)) {
            return false;
        }
        PatternFilter that = (PatternFilter)obj;
        return this._include == that._include && this._pattern.equals(that._pattern);
    }

    public int hashCode() {
        return this._pattern.hashCode() << 1 + (this._include ? 1 : 0);
    }
}

