/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.ide.util.Letter;
import oracle.ide.util.MenuCJKUtil;
import oracle.ide.util.MenuLabelComparator;

public class MnemonicSolver {
    private Collection _labels;
    private Map _letters;

    private void $init$() {
        this._labels = new TreeSet(new MenuLabelComparator());
        this._letters = new HashMap();
    }

    public MnemonicSolver() {
        this.$init$();
    }

    public MnemonicSolver(String[] labels) {
        this.$init$();
        int i = 0;
        while (i < labels.length) {
            this.addMenuLabel(labels[i]);
            ++i;
        }
    }

    public MnemonicSolver(String[] labels, int[] mnemonics) {
        this.$init$();
        int i = 0;
        while (i < labels.length) {
            this.addMenuLabel(labels[i], mnemonics[i]);
            ++i;
        }
    }

    public MnemonicSolver(String[] labels, int[] mnemonics, boolean[] fixed) {
        this.$init$();
        int i = 0;
        while (i < labels.length) {
            this.addMenuLabel(labels[i], mnemonics[i], fixed[i]);
            ++i;
        }
    }

    public MnemonicSolver(JMenu menu) {
        this(menu.getPopupMenu());
    }

    public MnemonicSolver(JPopupMenu popupMenu) {
        this.$init$();
        this.addMenuLabels(popupMenu);
    }

    public MenuLabel addMenuLabel(String text) {
        return this.addMenuLabel(text, 0);
    }

    public MenuLabel addMenuLabel(String text, int mnemonic) {
        return this.addMenuLabel(text, mnemonic, false);
    }

    public MenuLabel addMenuLabel(String text, int mnemonic, boolean fixed) {
        MenuLabel label = new MenuLabel(text, mnemonic, fixed);
        this.registerMenuLabel(label);
        return label;
    }

    public MenuLabel addMenuLabel(JMenuItem menuItem) {
        return this.addMenuLabel(menuItem, false);
    }

    public MenuLabel addMenuLabel(JMenuItem menuItem, boolean fixed) {
        return this.addMenuLabel(menuItem, null, fixed);
    }

    public MenuLabel addMenuLabel(JMenuItem menuItem, String text, boolean fixed) {
        MenuLabel label = this.findMenuLabel(menuItem);
        if (label != null) {
            label.setFixed(fixed);
            label.setText(text);
        } else {
            label = new MenuLabel(menuItem, text, fixed);
            this.registerMenuLabel(label);
        }
        return label;
    }

    public MenuLabel addMenuLabel(Component component, boolean fixed) {
        return this.addMenuLabel(component, null, fixed);
    }

    public MenuLabel addMenuLabel(Component component, String text, boolean fixed) {
        if (component instanceof JMenuItem) {
            return this.addMenuLabel((JMenuItem)component, text, fixed);
        }
        return null;
    }

    public Collection addMenuLabels(JMenu menu) {
        return this.addMenuLabels(menu.getPopupMenu());
    }

    public Collection addMenuLabels(JPopupMenu popupMenu) {
        Component[] items = popupMenu.getComponents();
        int i = 0;
        while (i < items.length) {
            Component component = items[i];
            if (component instanceof JMenuItem) {
                this.addMenuLabel((JMenuItem)component);
            }
            ++i;
        }
        return this._labels;
    }

    public MenuLabel findMenuLabel(JMenuItem menuItem) {
        for (MenuLabel label : this._labels) {
            if (label.getMenuItem() != menuItem) continue;
            return label;
        }
        return null;
    }

    public void removeMenuLabel(MenuLabel label) {
        this.decrementLetterCounter(label.getText(), true);
        this._labels.remove(label);
    }

    public Collection solve() {
        this.resolve();
        this.fineTune();
        return this._labels;
    }

    public void clear() {
        this._labels.clear();
        this._letters.clear();
    }

    private void resolve() {
        Iterator labels = this._labels.iterator();
        while (labels.hasNext()) {
            this.resolve((MenuLabel)labels.next());
        }
    }

    private void fineTune() {
        Iterator labels = this._labels.iterator();
        while (labels.hasNext()) {
            this.fineTune((MenuLabel)labels.next());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void resolve(MenuLabel label) {
        text = MenuCJKUtil.addSingleByteCharsForMnemonics(label.getText());
        labelMnemonic = label.getMnemonic();
        best = new Letter();
        best._counter = 0x7FFFFFFF;
        prevChar = 0;
        bestFit = false;
        potentials = new ArrayList<Integer>();
        i = 0;
        while (i < text.length()) {
            block21: {
                block20: {
                    c = text.charAt(i);
                    if (Letter.isValid(c)) break block20;
                    prevChar = c;
                    break block21;
                }
                letter = this.findLetter(c);
                if (!letter.isUsed()) ** GOTO lbl-1000
                usageCount = letter.getUsageCount();
                if (this.areEqual(letter._char, labelMnemonic)) {
                    if (usageCount == 1) {
                        label.setFixed(true);
                        this.decrementLetterCounter(text, false);
                        return;
                    }
                    for (MenuLabel ml : letter._labels) {
                        if (ml == label) continue;
                        ml.setMnemonic(0);
                        ml.setFixed(false);
                    }
                    letter._labels.clear();
                    label.setFixed(true);
                    letter._labels.add(label);
                    this.decrementLetterCounter(text, false);
                    return;
                }
                if (letter.isFixed()) {
                    prevChar = letter._char;
                } else if (this.isSpace(c)) {
                    prevChar = c;
                } else {
                    if (letter._counter < best._counter) {
                        if (!bestFit) {
                            best._char = c;
                            best._counter = letter._counter;
                            if (i == 0) {
                                bestFit = true;
                            }
                        }
                    } else if (letter._counter == best._counter) {
                        if (!bestFit && this.isSpace(prevChar)) {
                            best._char = c;
                            best._counter = letter._counter;
                            bestFit = true;
                        }
                    } else if (!bestFit && (i == 0 || this.isSpace(prevChar))) {
                        potentials.add(c);
                    }
                    prevChar = c;
                }
            }
            ++i;
        }
        if (best.isValid()) {
            letter = this.findLetter(best._char);
            for (MenuLabel ml : letter._labels) {
                ml.setMnemonic(0);
                ml.setFixed(false);
            }
            letter._labels.clear();
            label.initMnemonic(best._char);
            if (!label.isFixed()) {
                label.setFixed(true);
                label.setPotentialMnemonics(potentials);
            }
            letter._labels.add(label);
            this.decrementLetterCounter(text, false);
        } else {
            label.initMnemonic(0);
        }
    }

    private void fineTune(MenuLabel label) {
        List potentials = label.getPotentialMnemonics();
        if (potentials == null || potentials.size() == 0) {
            return;
        }
        Iterator items = potentials.iterator();
        while (items.hasNext()) {
            int c = (Integer)items.next();
            Letter letter = this.findLetter(c);
            if (letter.isUsed()) continue;
            label.initMnemonic(c);
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void registerMenuLabel(MenuLabel label) {
        text = MenuCJKUtil.addSingleByteCharsForMnemonics(label.getText());
        if (text == null) {
            return;
        }
        mnemonic = label.getMnemonic();
        len = text.length();
        uniqueChars = new char[len];
        u = 0;
        i = 0;
        while (i < len) {
            block7: {
                block8: {
                    block10: {
                        block9: {
                            c = text.charAt(i);
                            if (!Letter.isValid((int)c)) break block7;
                            letter = this.findLetter(c);
                            if (letter == null) {
                                letter = new Letter(c);
                                this.cacheLetter(c, letter);
                            }
                            if (MenuLabelComparator.isUniqueChar(uniqueChars, c)) {
                                uniqueChars[u++] = c;
                                ++letter._counter;
                            }
                            if (!this.areEqual(mnemonic, c)) break block7;
                            usageCount = letter.getUsageCount();
                            if (usageCount == 0) ** GOTO lbl-1000
                            if (!label.isFixed()) break block8;
                            if (usageCount <= 1) break block9;
                            for (MenuLabel ml : letter._labels) {
                                ml.setMnemonic(0);
                                ml.setFixed(false);
                            }
                            letter._labels.clear();
                            ** GOTO lbl-1000
                        }
                        ml = (MenuLabel)letter._labels.first();
                        if (ml == label) break block7;
                        if (!ml.isFixed()) ** GOTO lbl-1000
                        if (MenuLabelComparator.length(ml.getText()) <= MenuLabelComparator.length(label.getText())) break block10;
                        letter._labels.clear();
                        ml.setMnemonic(0);
                        ml.setFixed(false);
                        ** GOTO lbl-1000
                    }
                    label.setMnemonic(0);
                    label.setFixed(false);
                    break block7;
                }
                if (usageCount == 1 && (ml = (MenuLabel)letter._labels.first()).isFixed()) {
                    label.setMnemonic(0);
                    label.setFixed(false);
                } else lbl-1000:
                // 5 sources

                {
                    letter._labels.add(label);
                }
            }
            ++i;
        }
        this._labels.add(label);
    }

    private void decrementLetterCounter(String text, boolean remove) {
        int len;
        int n = len = text == null ? 0 : text.length();
        if (len == 0) {
            return;
        }
        char[] uniqueChars = new char[len];
        int u = 0;
        int i = 0;
        while (i < len) {
            Letter letter;
            char c = text.charAt(i);
            if (Letter.isValid((int)c) && (letter = this.findLetter(c)) != null && MenuLabelComparator.isUniqueChar(uniqueChars, c)) {
                uniqueChars[u++] = c;
                --letter._counter;
                if (remove && letter._counter == 0) {
                    this.uncacheLetter(c);
                }
            }
            ++i;
        }
    }

    private Letter findLetter(int c) {
        return (Letter)this._letters.get(this.toLowerCase(c));
    }

    private void cacheLetter(int c, Letter letter) {
        this._letters.put(this.toLowerCase(c), letter);
    }

    private void uncacheLetter(int c) {
        this._letters.remove(this.toLowerCase(c));
    }

    private boolean isSpace(int c) {
        return Character.isSpaceChar((char)c);
    }

    private Integer toLowerCase(int c) {
        return Character.toLowerCase((char)c);
    }

    private boolean areEqual(int c1, int c2) {
        return Character.toLowerCase((char)c1) == Character.toLowerCase((char)c2);
    }

    static void mav$registerMenuLabel(MnemonicSolver mnemonicSolver, MenuLabel menuLabel) {
        mnemonicSolver.registerMenuLabel(menuLabel);
    }

    public class MenuLabel {
        private JMenuItem _menuItem;
        private String _text;
        private int _mnemonic;
        private boolean _fixed;
        private List _potentialMnemonics;

        protected MenuLabel(String text) {
            this(text, 0);
        }

        protected MenuLabel(String text, int mnemonic) {
            this(text, mnemonic, false);
        }

        protected MenuLabel(String text, int mnemonic, boolean fixed) {
            this._text = text;
            this._mnemonic = mnemonic;
            this._fixed = fixed;
        }

        protected MenuLabel(JMenuItem menuItem, boolean fixed) {
            this(menuItem, null, fixed);
        }

        protected MenuLabel(JMenuItem menuItem, String text, boolean fixed) {
            this(text, menuItem.getMnemonic(), fixed);
            if (!this.isValidText(this._text)) {
                this._text = menuItem.getText();
            }
            this._menuItem = menuItem;
        }

        public String getText() {
            return this._text;
        }

        public void setText(String text) {
            if (this.isValidText(text)) {
                MnemonicSolver.this.removeMenuLabel(this);
                this._text = text;
                MnemonicSolver.mav$registerMenuLabel(MnemonicSolver.this, this);
            }
        }

        public int getMnemonic() {
            return this._mnemonic;
        }

        public void setMnemonic(int mnemonic) {
            this._mnemonic = mnemonic;
        }

        public void initMnemonic(int mnemonic) {
            this.setMnemonic(mnemonic);
            if (this._menuItem != null) {
                this._menuItem.setText(MenuCJKUtil.getCJKMenuLabel(this._menuItem.getText(), mnemonic));
                int vk = mnemonic;
                if (vk >= 97 && vk <= 122) {
                    vk -= 32;
                }
                this._menuItem.setMnemonic(vk);
            }
        }

        public boolean isFixed() {
            return this._fixed;
        }

        public void setFixed(boolean fixed) {
            this._fixed = fixed;
        }

        public JMenuItem getMenuItem() {
            return this._menuItem;
        }

        public void setMenuItem(JMenuItem menuItem) {
            this._menuItem = menuItem;
        }

        public List getPotentialMnemonics() {
            return this._potentialMnemonics;
        }

        public void setPotentialMnemonics(List potentialMnemonics) {
            this._potentialMnemonics = potentialMnemonics;
        }

        public boolean isValidText(String text) {
            return text != null && text.length() > 0;
        }
    }
}

