/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

public final class JDK {
    private static final int V_1_3_0_2 = 2;
    private static final int V_1_3_1_0 = 4;
    private static final int V_1_3_1_1 = 8;
    private static final int V_1_3_1_2 = 16;
    private static final int V_1_3_1_3 = 32;
    private static final int V_1_3_1_4 = 64;
    private static final int V_1_4_0_0 = 128;
    private static final int V_1_4_1_0 = 256;
    private static final int V_1_4_2_0 = 512;
    private static final int V_1_5 = 1024;
    private static final int V_1_6 = 2048;
    private static final int V_1_7 = 4096;
    private static final int V_1_3_1 = 124;
    private static final int V_1_4_0 = 128;
    private static final int V_DEFAULT = 512;
    private static final String JDK_VERSION_KEY = "java.version";
    private static final String[] JDK_VERSIONS_VALUES = new String[]{"1.3.1", "1.3.1_01", "1.3.1_02", "1.3.1_03", "1.3.1_04", "1.4.0", "1.4.1", "1.4.2", "1.5", "1.6", "1.7"};
    private static final int[] JDK_VERSIONS = new int[]{4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096};
    private static final int STATIC_VERSION = 16;
    private static final int DYNAMIC_VERSION = JDK.getJDKVersion();
    public static final boolean IS_JDK14 = DYNAMIC_VERSION >= 128;
    public static final boolean IS_JDK141 = DYNAMIC_VERSION >= 256;
    public static final boolean IS_JDK142 = DYNAMIC_VERSION >= 512;
    public static final boolean IS_JDK15 = DYNAMIC_VERSION >= 1024;
    public static final boolean IS_JDK16 = DYNAMIC_VERSION >= 2048;
    public static final boolean IS_JDK17 = DYNAMIC_VERSION >= 4096;
    public static final boolean HAS_BUG_4199374 = JDK.getBooleanProperty("HAS_BUG_4199374", true);
    public static final boolean HAS_BUG_J2D_ROTATE = JDK.getBooleanProperty("HAS_BUG_J2D_ROTATE", false);
    public static final boolean HAS_BUG_NOREMOVEFOCUS = JDK.getBooleanProperty("HAS_BUG_NOREMOVEFOCUS", true);
    public static final boolean HAS_BUG_4336775 = JDK.getBooleanProperty("HAS_BUG_4336775", false);
    public static final boolean HAS_BUG_4776532 = JDK.getBooleanProperty("HAS_BUG_4776532", true);
    public static final boolean HAS_BUG_GETKEYMODIFIERSTEXT = JDK.getBooleanProperty("HAS_BUG_GETKEYMODIFIERSTEXT", true);
    public static final boolean HAS_BUG_4502288 = JDK.getBooleanProperty("HAS_BUG_4502288", true);
    public static final boolean HAS_BUG_TABBEDPANE_NPE_JAWS = JDK.getBooleanProperty("HAS_BUG_TABBEDPANE_NPE_JAWS", true);
    public static final boolean HAS_BUG_4381959 = JDK.getBooleanProperty("HAS_BUG_4381959", DYNAMIC_VERSION < 128);
    public static final boolean HAS_BUG_2435195 = JDK.getBooleanProperty("HAS_BUG_2435195", DYNAMIC_VERSION >= 128);
    public static final boolean HAS_BUG_4519411 = JDK.getBooleanProperty("HAS_BUG_4519411", DYNAMIC_VERSION == 8 || DYNAMIC_VERSION == 16);
    public static final boolean HAS_BUG_4647105 = JDK.getBooleanProperty("HAS_BUG_4647105", DYNAMIC_VERSION <= 64);
    public static final boolean HAS_BUG_4765282 = JDK.getBooleanProperty("HAS_BUG_4765282", IS_JDK14);
    public static final boolean WA_ORABUG_1963899 = JDK.getBooleanProperty("RestoreAppDefaultSize", false);
    public static final boolean HAS_BUG_4390137 = JDK.getBooleanProperty("FrameNotRevisible", false);
    public static final boolean HAS_BUG_4674205 = JDK.getBooleanProperty("HAS_BUG_4674205", true);
    public static final boolean HAS_BUG_4551985 = JDK.getBooleanProperty("HAS_BUG_4551985", DYNAMIC_VERSION < 512);
    public static final boolean HAS_BUG_2645826 = JDK.getBooleanProperty("WrongSystemFontOnWindows", IS_JDK15 ^ true);
    public static final boolean SEARCH_ACCELERATORS_IN_MENUS = JDK.getBooleanProperty("SearchAcceleratorsInMenus", false);
    public static final boolean HAS_BUG_4753146 = JDK.getBooleanProperty("HAS_BUG_4753146", IS_JDK141);
    public static final boolean HAS_BUG_4749792 = JDK.getBooleanProperty("HAS_BUG_4749792", IS_JDK14);
    public static final boolean HAS_BUG_4812991 = JDK.getBooleanProperty("HAS_BUG_4812991", true);
    public static final boolean HAS_BUG_MENU_RESTORES_WRONG_FOCUS = JDK.getBooleanProperty("HAS_BUG_MENU_RESTORES_WRONG_FOCUS", true);
    public static final boolean HAS_BUG_TYPE_DOES_NOT_SCROLL_IN_JLIST = JDK.getBooleanProperty("HAS_BUG_TYPE_DOES_NOT_SCROLL_IN_JLIST", true);
    public static final boolean HAS_BUG_METAL_MAXIMIZE_DOES_NOT_WORK_ON_LINUX = JDK.getBooleanProperty("HAS_BUG_METAL_MAXIMIZE_DOES_NOT_WORK_ON_LINUX", true);
    public static final boolean HAS_BUG_METAL_CURSOR_SHAPE = JDK.getBooleanProperty("HAS_BUG_METAL_CURSOR_SHAPE", true);
    public static final boolean HAS_BUG_BROKEN_TYPE_AHEAD = JDK.getBooleanProperty("HAS_BUG_BROKEN_TYPE_AHEAD", true);
    public static final boolean HAS_BUG_4552322 = JDK.getBooleanProperty("HAS_BUG_4552322", IS_JDK15);
    public static final boolean HAS_BUG_WINDOWS_REGISTRY_FONT_MULTIBYTE_SUPPORT = JDK.getBooleanProperty("HAS_BUG_WINDOWS_REGISTRY_FONT_MULTIBYTE_SUPPORT", IS_JDK15 && !IS_JDK16);
    public static final boolean HAS_BUG_4699831 = JDK.getBooleanProperty("HAS_BUG_4699831", true);

    private JDK() {
    }

    private static int getJDKVersion() {
        String jdkVersion = System.getProperty(JDK_VERSION_KEY);
        int i = JDK_VERSIONS_VALUES.length - 1;
        while (i >= 0) {
            if (jdkVersion.startsWith(JDK_VERSIONS_VALUES[i])) {
                return JDK_VERSIONS[i];
            }
            --i;
        }
        return 512;
    }

    private static boolean getBooleanProperty(String sName, boolean bDefault) {
        String sProp = System.getProperty(sName, bDefault ? "true" : "false");
        return Boolean.valueOf(sProp);
    }
}

