/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.Arrays;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.TriStateBoolean;

public final class IntersectedFilters {
    private final PatternFilters[] _filters;
    private final int _n;

    public IntersectedFilters(PatternFilters[] filters) {
        int okCount = 0;
        int n = filters.length;
        int i = 0;
        while (i < n) {
            if (filters[i] != null) {
                ++okCount;
            }
            ++i;
        }
        if (okCount == n) {
            this._filters = filters;
            this._n = n;
        } else {
            PatternFilters[] trimmedFilters = new PatternFilters[okCount];
            int j = 0;
            int i2 = 0;
            while (i2 < n) {
                PatternFilters pf = filters[i2];
                if (pf != null) {
                    trimmedFilters[j++] = pf;
                }
                ++i2;
            }
            this._filters = trimmedFilters;
            this._n = okCount;
        }
    }

    public IntersectedFilters(IntersectedFilters filters1, IntersectedFilters filters2) {
        this._filters = IntersectedFilters.intersect(filters1, filters2);
        this._n = this._filters.length;
    }

    public IntersectedFilters(PatternFilters filters1) {
        this(new PatternFilters[]{filters1});
    }

    public IntersectedFilters(PatternFilters filters1, PatternFilters filters2) {
        this(new PatternFilters[]{filters1, filters2});
    }

    public IntersectedFilters(PatternFilters filters1, PatternFilters filters2, PatternFilters filters3) {
        this(new PatternFilters[]{filters1, filters2, filters3});
    }

    public IntersectedFilters intersectWith(PatternFilters filters) {
        return filters != null ? new IntersectedFilters(IntersectedFilters.intersect(filters, this)) : this;
    }

    public IntersectedFilters intersectWith(IntersectedFilters filters) {
        return filters != null ? new IntersectedFilters(IntersectedFilters.intersect(filters, this)) : this;
    }

    public TriStateBoolean inferFromFilters(String relPath) {
        TriStateBoolean result = TriStateBoolean.TRUE;
        int i = 0;
        while (i < this._n) {
            PatternFilters pf = this._filters[i];
            if (pf.containsFilters()) {
                TriStateBoolean bool = pf.inferFromFilters(relPath);
                if (bool.isFalse()) {
                    return TriStateBoolean.FALSE;
                }
                result = result.and(bool);
            }
            ++i;
        }
        return result;
    }

    public boolean isIncluded(String relPath) {
        int i = 0;
        while (i < this._n) {
            PatternFilters pf = this._filters[i];
            if (pf.containsFilters() && !pf.isIncluded(relPath)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static PatternFilters[] intersect(IntersectedFilters filters1, IntersectedFilters filters2) {
        int n1 = filters1 != null ? filters1._n : 0;
        int n2 = filters2 != null ? filters2._n : 0;
        int n = n1 + n2;
        PatternFilters[] filters = new PatternFilters[n];
        if (filters1 != null) {
            System.arraycopy(filters1._filters, 0, filters, 0, n1);
        }
        if (filters2 != null) {
            System.arraycopy(filters2._filters, 0, filters, n1, n2);
        }
        return filters;
    }

    private static PatternFilters[] intersect(PatternFilters filters1, IntersectedFilters filters2) {
        int n1 = filters1 != null ? 1 : 0;
        int n2 = filters2 != null ? filters2._n : 0;
        int n = n1 + n2;
        PatternFilters[] filters = new PatternFilters[n];
        if (filters1 != null) {
            filters[0] = filters1;
        }
        if (filters2 != null) {
            System.arraycopy(filters2._filters, 0, filters, n1, n2);
        }
        return filters;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof IntersectedFilters && Arrays.equals((Object[])this._filters, (Object[])((IntersectedFilters)object)._filters);
    }

    public int hashCode() {
        int code = 0;
        int i = 0;
        while (i < this._n) {
            code = code * 37 + this._filters[i].hashCode();
            ++i;
        }
        return code;
    }
}

