/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntHashMap<V> {
    private static final int DEFAULT_SIZE = 11;
    private transient Entry<V>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount;
    private static EmptyHashIterator emptyHashIterator = new EmptyHashIterator();

    private void $init$() {
        this.modCount = 0;
    }

    public IntHashMap(int initialCapacity, float loadFactor) {
        this.$init$();
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap() {
        this(11, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsValue(Object value) {
        Entry<V>[] tab = this.table;
        if (value == null) {
            int i = tab.length;
            while (i-- > 0) {
                Entry<V> e = tab[i];
                while (e != null) {
                    if (e.value == null) {
                        return true;
                    }
                    e = e.next;
                }
            }
        } else {
            int i = tab.length;
            while (i-- > 0) {
                Entry<V> e = tab[i];
                while (e != null) {
                    if (value.equals(e.value)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        Entry<V>[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        while (e != null) {
            if (key == e.key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public V get(int key) {
        Entry<V>[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        while (e != null) {
            if (key == e.key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<V> old = oldMap[i];
            while (old != null) {
                Entry<V> e = old;
                old = old.next;
                int index = (e.key & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public V put(int key, V value) {
        Entry<V>[] tab = this.table;
        int index = 0;
        index = (key & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        while (e != null) {
            if (key == e.key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (key & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = new Entry<V>(key, value, tab[index]);
        ++this.count;
        return null;
    }

    public V remove(int key) {
        Entry<V>[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        Entry<V> prev = null;
        while (e != null) {
            if (key == e.key) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        Entry<V>[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Iterator<V> iterator() {
        if (this.count == 0) {
            return emptyHashIterator;
        }
        return new ValueIterator(null);
    }

    public Set<Integer> keySet() {
        return new KeySet(null);
    }

    private Iterator<Integer> newKeyIterator() {
        if (this.count == 0) {
            return emptyHashIterator;
        }
        return new KeyIterator(null);
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    static int ra$count(IntHashMap intHashMap) {
        return intHashMap.count;
    }

    static Iterator mav$newKeyIterator(IntHashMap intHashMap) {
        return intHashMap.newKeyIterator();
    }

    static int ra$modCount(IntHashMap intHashMap) {
        return intHashMap.modCount;
    }

    static Entry[] ra$table(IntHashMap intHashMap) {
        return intHashMap.table;
    }

    static void wa$modCount(IntHashMap intHashMap, int n) {
        intHashMap.modCount = n;
    }

    static void wa$count(IntHashMap intHashMap, int n) {
        intHashMap.count = n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<Integer> {
        @Override
        public Iterator<Integer> iterator() {
            return IntHashMap.mav$newKeyIterator(IntHashMap.this);
        }

        @Override
        public int size() {
            return IntHashMap.ra$count(IntHashMap.this);
        }

        @Override
        public boolean contains(Object o) {
            return IntHashMap.this.containsKey((Integer)o);
        }

        @Override
        public boolean remove(Object o) {
            return IntHashMap.this.remove((Integer)o) != null;
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }

        private KeySet() {
        }

        KeySet(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<V> {
        int key;
        V value;
        Entry<V> next;

        Entry(int key, V value, Entry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyHashIterator
    implements Iterator {
        EmptyHashIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<V>
    implements Iterator<V> {
        Entry[] table;
        int index;
        Entry<V> entry;
        Entry<V> lastReturned;
        private int expectedModCount;

        private void $init$() {
            this.table = IntHashMap.ra$table(IntHashMap.this);
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = IntHashMap.ra$modCount(IntHashMap.this);
        }

        HashIterator() {
            this.$init$();
        }

        @Override
        public boolean hasNext() {
            Entry e = this.entry;
            int i = this.index;
            Entry[] t = this.table;
            while (e == null && i > 0) {
                e = t[--i];
            }
            this.entry = e;
            this.index = i;
            return e != null;
        }

        public Entry<V> nextEntry() {
            if (IntHashMap.ra$modCount(IntHashMap.this) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry et = this.entry;
            int i = this.index;
            Entry[] t = this.table;
            while (et == null && i > 0) {
                et = t[--i];
            }
            this.entry = et;
            this.index = i;
            if (et != null) {
                this.lastReturned = this.entry;
                Entry<V> e = this.lastReturned;
                this.entry = e.next;
                return e;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IntHashMap.ra$modCount(IntHashMap.this) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] tab = IntHashMap.ra$table(IntHashMap.this);
            int index = (this.lastReturned.key & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturned) {
                    IntHashMap intHashMap = IntHashMap.this;
                    IntHashMap.wa$modCount(intHashMap, IntHashMap.ra$modCount(intHashMap) + 1);
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    IntHashMap intHashMap2 = IntHashMap.this;
                    IntHashMap.wa$count(intHashMap2, IntHashMap.ra$count(intHashMap2) - 1);
                    this.lastReturned = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends HashIterator<V> {
        @Override
        public V next() {
            return this.nextEntry().value;
        }

        private ValueIterator() {
        }

        ValueIterator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends HashIterator<Integer> {
        @Override
        public Integer next() {
            return this.nextEntry().key;
        }

        private KeyIterator() {
        }

        KeyIterator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

