/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.Version;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.Encodings;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.StringTokenizerEx;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.util.SwingUtils;

public final class IdeUtil {
    private static HashSet javaKeywords;
    private static HashSet javaReservedWords;
    private static String _encoding;

    private IdeUtil() {
    }

    public static void centerWindow(Container parent, Component child) {
        Dimension dimParent;
        Point ptParent;
        if (parent != null) {
            ptParent = parent.getLocationOnScreen();
            dimParent = parent.getSize();
        } else {
            ptParent = new Point(0, 0);
            dimParent = child.getToolkit().getScreenSize();
        }
        Dimension dimChild = child.getSize();
        child.setLocation(ptParent.x + (dimParent.width - dimChild.width) / 2, ptParent.y + (dimParent.height - dimChild.height) / 2);
    }

    public static void centerTreeSelection(JTree tree) {
        if (tree == null) {
            return;
        }
        JScrollPane sp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, tree);
        if (sp == null) {
            return;
        }
        1 runnable = new 1(tree, sp);
        SwingUtilities.invokeLater(runnable);
    }

    public static void expandAllTreeRows(JTree tree) {
        IdeUtil.expandTreeToDepth(tree, 0);
    }

    public static void expandTreeToDepth(JTree tree, int depth) {
        TreePath selectedPath = tree.getSelectionPath();
        int i = 0;
        while (i < tree.getRowCount()) {
            if (depth <= 0) {
                tree.expandRow(i);
            } else {
                TreePath path = tree.getPathForRow(i);
                if (path != null && path.getPathCount() <= depth) {
                    tree.expandRow(i);
                } else {
                    tree.collapseRow(i);
                }
            }
            ++i;
        }
        if (selectedPath != null) {
            tree.setSelectionPath(selectedPath);
        } else {
            tree.setSelectionRow(0);
        }
    }

    public static Dialog findDialog(Component component) {
        if (component instanceof Dialog) {
            return (Dialog)component;
        }
        return (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, component);
    }

    public static Frame findFrame(Component component) {
        return SwingUtils.findFrame((Component)component);
    }

    public static boolean isJavaKeyword(String name) {
        if (javaKeywords == null) {
            String[] JAVA_KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
            javaKeywords = new HashSet();
            int i = 0;
            while (i < JAVA_KEYWORDS.length) {
                javaKeywords.add(JAVA_KEYWORDS[i]);
                ++i;
            }
        }
        return javaKeywords.contains(name);
    }

    public static boolean isJavaReservedWord(String name) {
        if (javaReservedWords == null) {
            String[] JAVA_RESERVED_WORDS = new String[]{"true", "false", "null"};
            javaReservedWords = new HashSet();
            int i = 0;
            while (i < JAVA_RESERVED_WORDS.length) {
                javaReservedWords.add(JAVA_RESERVED_WORDS[i]);
                ++i;
            }
        }
        return IdeUtil.isJavaKeyword(name) || javaReservedWords.contains(name);
    }

    public static boolean isJavaIdentifier(String name) {
        if (name == null) {
            return false;
        }
        int length = name.length();
        if (length == 0 || !Character.isJavaIdentifierStart(name.charAt(0)) || IdeUtil.isJavaReservedWord(name)) {
            return false;
        }
        int i = 1;
        while (i < length) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isPackageIdentifier(String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith(".") || name.endsWith(".") || name.indexOf("..") >= 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(name, ".");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (IdeUtil.isJavaIdentifier(token)) continue;
            return false;
        }
        return true;
    }

    public static String list2String(List list) {
        int bufferLength;
        FastStringBuffer buffer = new FastStringBuffer();
        if (list != null) {
            Object[] o = list.toArray(new Object[list.size()]);
            int i = 0;
            while (i < o.length) {
                buffer.append(o[i].toString()).append(";");
                ++i;
            }
        }
        if ((bufferLength = buffer.length()) > 0) {
            buffer.setLength(bufferLength - 1);
        }
        return buffer.toString();
    }

    public static void string2List(String string, List list) {
        list.clear();
        if (string != null) {
            StringTokenizer st = new StringTokenizer(string, ";");
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
    }

    public static String[] convertStringToStringArray(String s) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] convertStringToStringArray(String s, boolean allowQuotedStrings, boolean keepQuotes) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizerEx st = new StringTokenizerEx(s, " \t\n\r\f", false, allowQuotedStrings, keepQuotes);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getSubString(String sIn, char c, boolean bBefore) {
        String sRet = null;
        int i = sIn.indexOf(c);
        if (i < 0) {
            if (bBefore) {
                sRet = sIn;
            }
        } else {
            sRet = bBefore ? sIn.substring(0, i) : sIn.substring(i + 1);
        }
        return sRet;
    }

    public static String removeChars(String sIn, String sRemove) {
        int nAt = sIn.indexOf(sRemove);
        if (nAt == -1) {
            return sIn;
        }
        StringBuffer sb = new StringBuffer(sIn);
        while (nAt != -1) {
            sb.deleteCharAt(nAt);
            nAt = sb.toString().indexOf(sRemove);
        }
        return sb.toString();
    }

    public static String prepad(String s, char c, int len) {
        int diff = len - s.length();
        if (diff > 0) {
            FastStringBuffer sb = new FastStringBuffer(len);
            int i = 0;
            while (i < diff) {
                sb.append(c);
                ++i;
            }
            sb.append(s);
            s = sb.toString();
        }
        return s;
    }

    public static void addAll(Collection target, Object[] toAdd) {
        int i = 0;
        while (i < toAdd.length) {
            target.add(toAdd[i]);
            ++i;
        }
    }

    public static void addAll(Collection target, Iterator toAdd) {
        while (toAdd.hasNext()) {
            target.add(toAdd.next());
        }
    }

    public static boolean containsAny(AbstractCollection set, Collection collection) {
        for (Object object : collection) {
            if (!set.contains(object)) continue;
            return true;
        }
        return false;
    }

    public static String getDocumentVersion(URL url) {
        try {
            StartElementPacket sep = XMLUtil.getXMLRootElement((URL)url);
            if (sep != null) {
                String string = IdeUtil.getVersionFromNamespaceURI(sep.namespaceURI);
                return string;
            }
        }
        catch (FileNotFoundException e) {
            String string = IdeUtil.getVersionFromNamespaceURI(Version.BASE_NAMESPACE_URI);
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void addComboBoxDocumentListener(JComboBox jcomboBox, DocumentListener documentListener) {
        JTextField editor = (JTextField)jcomboBox.getEditor().getEditorComponent();
        editor.getDocument().addDocumentListener(new 2(documentListener, editor));
    }

    public static void comboBoxSelectItem(JComboBox comboBox, Object item) {
        boolean found = false;
        int i = comboBox.getItemCount() - 1;
        while (i >= 0) {
            if (comboBox.getItemAt(i).equals(item)) {
                found = true;
                comboBox.setSelectedIndex(i);
            }
            --i;
        }
        if (!found) {
            comboBox.insertItemAt(item, 0);
            comboBox.setSelectedIndex(0);
        }
        JTextField editor = (JTextField)comboBox.getEditor().getEditorComponent();
        editor.setText(item.toString());
    }

    public static Icon grayIcon(Icon icon) {
        Image grayImage = GrayFilter.createDisabledImage(((ImageIcon)icon).getImage());
        return new ImageIcon(grayImage);
    }

    public static void runNow(Runnable r) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyToClipboard(String s) {
        if (s != null && s.length() > 0) {
            StringSelection content = new StringSelection(s);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            ClipboardStack.pushCurrentClipboard();
            clipboard.setContents(content, null);
        }
    }

    public static Frame getMainWindow() {
        return SwingUtils.getMainWindow();
    }

    public static void setMainWindow(JFrame frame) {
        SwingUtils.setMainWindow((JFrame)frame);
    }

    public static void setStartupWindow(JFrame frame) {
        SwingUtils.setStartupWindow((JFrame)frame);
    }

    public static String getProgramName() {
        String programName = SwingUtils.getProgramName();
        return ModelUtil.hasLength((String)programName) ? programName : "Oracle Development Tool";
    }

    public static void setProgramName(String name) {
        SwingUtils.setProgramName((String)name);
    }

    public static String getProgramShortName() {
        String programShortName = SwingUtils.getProgramShortName();
        return ModelUtil.hasLength((String)programShortName) ? programShortName : "Development Tool";
    }

    public static void setProgramShortName(String name) {
        SwingUtils.setProgramShortName((String)name);
    }

    public static String getIdeEncoding() {
        return _encoding != null ? _encoding : Encodings.getDefaultEncoding();
    }

    public static void setIdeEncoding(String encoding) {
        _encoding = encoding;
    }

    public static String getIdeIanaEncoding() {
        String ideEncoding = IdeUtil.getIdeEncoding();
        if (ideEncoding.equals("Cp1252")) {
            return "windows-1252";
        }
        return Encodings.convertJdk2IanaEncoding((String)ideEncoding);
    }

    public static String replaceHTMLReservedCharacters(String s) {
        StringBuffer sb = new StringBuffer(s);
        int length = sb.length();
        int i = 0;
        while (i < length) {
            String replace;
            char c = sb.charAt(i);
            switch (c) {
                default: {
                    replace = null;
                    break;
                }
                case '&': {
                    replace = "&amp;";
                    break;
                }
                case '<': {
                    replace = "&lt;";
                    break;
                }
                case '>': {
                    replace = "&gt;";
                    break;
                }
                case '\"': {
                    replace = "&quot;";
                    break;
                }
            }
            if (replace != null) {
                sb.replace(i, i + 1, replace);
                length = sb.length();
            }
            ++i;
        }
        return sb.toString();
    }

    public static String decodeHTMLReservedCharacters(String s) {
        StringBuffer sb = new StringBuffer(s);
        int length = sb.length();
        int i = 0;
        while (i < length) {
            String replace = null;
            int changeLen = 0;
            char c = sb.charAt(i);
            switch (c) {
                default: {
                    replace = null;
                    break;
                }
                case '&': {
                    String str = sb.substring(i, Math.min(length, i + 4));
                    if (str.equals("&lt;")) {
                        replace = "<";
                        changeLen = 4;
                        break;
                    }
                    if (str.equals("&gt;")) {
                        replace = ">";
                        changeLen = 4;
                        break;
                    }
                    str = sb.substring(i, Math.min(length, i + 5));
                    if (str.equals("&amp;")) {
                        replace = "&";
                        changeLen = 5;
                        break;
                    }
                    str = sb.substring(i, Math.min(length, i + 6));
                    if (!str.equals("&quot;")) break;
                    replace = "\"";
                    changeLen = 6;
                    break;
                }
            }
            if (replace != null) {
                sb.replace(i, i + changeLen, replace);
                length = sb.length();
            }
            ++i;
        }
        return sb.toString();
    }

    public static Component moveFocusAway() {
        IdeMainWindow w = Ide.getMainWindow();
        Component cWasFocused = w.getFocusOwner();
        Menubar bar = Ide.getMenubar();
        Container menuBar = bar.getGUI(false);
        GraphicsUtils.focusComponentOrChild((Component)menuBar, (boolean)false);
        return cWasFocused;
    }

    public static void tryToRestoreFocus(Component cPreferred) {
        if (cPreferred != null && cPreferred.isShowing() && cPreferred.isEnabled()) {
            cPreferred.requestFocus();
        } else {
            Editor currentEditor;
            EditorManager editorManager = EditorManager.getEditorManager();
            Editor editor = currentEditor = editorManager != null ? editorManager.getCurrentEditor() : null;
            if (currentEditor != null) {
                Component currentEditorUI = currentEditor.getGUI();
                GraphicsUtils.focusComponentOrChild((Component)currentEditorUI, (boolean)true);
            } else {
                DockStation dockStation = DockStation.getDockStation();
                if (dockStation != null && !dockStation.activateAnyDockable()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().upFocusCycle(IdeUtil.getMainWindow());
                }
            }
        }
    }

    public static final Window modalDialogOwner() {
        Window window = IdeUtil.findActiveModalWindow();
        if (window != null) {
            return window;
        }
        return Ide.getMainWindow();
    }

    public static final Window findActiveModalWindow() {
        Window child;
        Window modal = IdeUtil.findActiveModalWindowImpl(IdeUtil.getMainWindow());
        if (modal == null) {
            return null;
        }
        while ((child = IdeUtil.findActiveModalWindowImpl(modal.getOwnedWindows())) != null) {
            modal = child;
        }
        return modal;
    }

    private static final Window findActiveModalWindowImpl(Window w) {
        if (!w.isShowing()) {
            return null;
        }
        if (w instanceof Dialog && ((Dialog)w).isModal()) {
            return w;
        }
        return IdeUtil.findActiveModalWindowImpl(w.getOwnedWindows());
    }

    private static final Window findActiveModalWindowImpl(Window[] arr) {
        int i = 0;
        while (i < arr.length) {
            Window w = IdeUtil.findActiveModalWindowImpl(arr[i]);
            if (w != null) {
                return w;
            }
            ++i;
        }
        return null;
    }

    public static String getDigitsFromString(String inString) {
        int strlen = inString.length();
        StringBuffer stringBuffer = new StringBuffer(strlen);
        int i = 0;
        while (i < strlen) {
            if (Character.isDigit(inString.charAt(i))) {
                stringBuffer.append(inString.charAt(i));
            }
            ++i;
        }
        return stringBuffer.toString();
    }

    private static String getVersionFromNamespaceURI(String namespaceURI) {
        int count = 0;
        StringTokenizer st = new StringTokenizer(namespaceURI, "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (++count != 4) continue;
            return token;
        }
        return null;
    }

    public static void invokeAfterRepaint(Runnable runnable) {
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show(0);
        3 waitCursorRunnable = new 3(runnable, waitCursor);
        SwingUtils.invokeAfterRepaint((Runnable)waitCursorRunnable);
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ JTree v$tree;
        private final /* synthetic */ JScrollPane v$sp;

        public void run() {
            int treeHeight;
            TreePath tp = this.v$tree.getSelectionPath();
            Rectangle pathRect = this.v$tree.getPathBounds(tp);
            JViewport viewPort = this.v$sp.getViewport();
            Rectangle viewRect = viewPort.getViewRect();
            viewRect.y = pathRect.y - (viewRect.height - pathRect.height >> 1);
            if (viewRect.y < 0) {
                viewRect.y = 0;
            }
            if (viewRect.y + viewRect.height > (treeHeight = this.v$tree.getHeight())) {
                viewRect.y = treeHeight - viewRect.height;
            }
            this.v$tree.scrollRectToVisible(viewRect);
        }

        public 1(JTree jTree, JScrollPane jScrollPane) {
            this.v$sp = jScrollPane;
            this.v$tree = jTree;
        }
    }

    static final class 2
    implements DocumentListener {
        private final /* synthetic */ DocumentListener v$documentListener;
        private final /* synthetic */ JTextField v$editor;

        public void changedUpdate(DocumentEvent e) {
            this.v$documentListener.changedUpdate(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.v$documentListener.insertUpdate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            if (this.v$editor.hasFocus()) {
                this.v$documentListener.removeUpdate(e);
            }
        }

        public 2(DocumentListener documentListener, JTextField jTextField) {
            this.v$editor = jTextField;
            this.v$documentListener = documentListener;
        }
    }

    static final class 3
    implements Runnable {
        private final /* synthetic */ Runnable v$runnable;
        private final /* synthetic */ WaitCursor v$waitCursor;

        public void run() {
            try {
                try {
                    this.v$runnable.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                this.v$waitCursor.hide();
            }
        }

        public 3(Runnable runnable, WaitCursor waitCursor) {
            this.v$waitCursor = waitCursor;
            this.v$runnable = runnable;
        }
    }
}

