/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.ide.resource.UtilArb;

public final class FileCopyUtil {
    private FileCopyUtil() {
    }

    public static void copyFile(File src, File target) throws IOException {
        block19: {
            FileInputStream in = null;
            FileOutputStream out = null;
            long srcDate = src.lastModified();
            long targetDate = target.lastModified();
            try {
                try {
                    int bytesRead;
                    if (srcDate <= targetDate) break block19;
                    FileCopyUtil.ensureParent(target);
                    in = new FileInputStream(src);
                    out = new FileOutputStream(target);
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException ioEx) {
                    target = null;
                    throw ioEx;
                }
                catch (Exception ex) {
                    target = null;
                    throw new IOException(UtilArb.format(0, src.getName()));
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception ex) {}
                if (target != null) {
                    target.setLastModified(srcDate);
                }
            }
        }
    }

    private static void ensureParent(File file) throws IOException {
        File parent;
        String parentName = file.getParent();
        if (parentName != null && (parent = new File(parentName)) != null && !parent.exists()) {
            parent.mkdirs();
        }
    }
}

