/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.DefaultPropertyAccess;
import oracle.ide.util.IteratorFilter;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultStructuredPropertyAccess
extends DefaultPropertyAccess
implements StructuredPropertyAccess {
    private String _name;
    private ArrayList _childNodes;
    private static final String ESCAPE_STRING = "_escaped";
    private static final String ESCAPE_VALUE_STRING = "_escapedValue";
    private static final String TEXT = "TEXT";

    private void $init$() {
        this._childNodes = new ArrayList();
    }

    public DefaultStructuredPropertyAccess(String name) {
        this.$init$();
        this.setName(name);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Iterator getChildNodes() {
        return this._childNodes.iterator();
    }

    public Iterator getChildNodes(String name) {
        return new 1(this, this.getChildNodes(), name);
    }

    public StructuredPropertyAccess getChildNode(String name) {
        int size = this._childNodes.size();
        int i = 0;
        while (i < size) {
            StructuredPropertyAccess structuredPropertyAccess = (StructuredPropertyAccess)this._childNodes.get(i);
            if (name.equals(structuredPropertyAccess.getName())) {
                return structuredPropertyAccess;
            }
            ++i;
        }
        return null;
    }

    public void insertChild(int position, StructuredPropertyAccess childNode) {
        this._childNodes.add(position, childNode);
    }

    public void appendChild(StructuredPropertyAccess childNode) {
        this._childNodes.add(childNode);
    }

    private static boolean contains(StructuredPropertyAccess parent, StructuredPropertyAccess child) {
        if (parent == child) {
            return true;
        }
        Iterator childNodes = parent.getChildNodes();
        while (childNodes.hasNext()) {
            StructuredPropertyAccess childNode = (StructuredPropertyAccess)childNodes.next();
            if (!DefaultStructuredPropertyAccess.contains(childNode, child)) continue;
            return true;
        }
        return false;
    }

    public void addAll(StructuredPropertyAccess other) {
        Iterator properties = other.getProperties();
        while (properties.hasNext()) {
            String key = (String)properties.next();
            String value = other.getProperty(key, null);
            this.setProperty(key, value);
        }
        Iterator childNodes = other.getChildNodes();
        while (childNodes.hasNext()) {
            StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
            this.appendChild(child);
        }
    }

    public void setBooleanProperty(String key, boolean value) {
        this.setProperty(key, Boolean.toString(value));
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        Object property = this.get(key);
        boolean ret = property != null ? Boolean.valueOf(property.toString()) : defaultValue;
        return ret;
    }

    public void setIntegerProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public int getIntegerProperty(String key, int defaultValue) {
        Object property = this.get(key);
        int ret = property != null ? Integer.valueOf(property.toString()) : defaultValue;
        return ret;
    }

    public void removeChild(StructuredPropertyAccess childNode) {
        this._childNodes.remove(childNode);
    }

    public void removeAllChildren() {
        this._childNodes.clear();
    }

    public boolean hasAttributes() {
        return this._map.isEmpty() ^ true;
    }

    public boolean hasChildNodes() {
        return this._childNodes.isEmpty() ^ true;
    }

    public Iterator getProperties() {
        return this._map.keySet().iterator();
    }

    public static void saveToXML(StructuredPropertyAccess structuredPropertyAccess, File file) throws IOException {
        XMLDocument xmlDocument = new XMLDocument();
        Element element = DefaultStructuredPropertyAccess.saveToElement(structuredPropertyAccess, xmlDocument);
        xmlDocument.appendChild((Node)element);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        xmlDocument.print((OutputStream)bufferedOutputStream);
        bufferedOutputStream.close();
    }

    private static Element saveToElement(StructuredPropertyAccess structuredPropertyAccess, XMLDocument ownerDocument) {
        Element element;
        String nodeName = structuredPropertyAccess.getName();
        if (DefaultStructuredPropertyAccess.isValidKey(nodeName)) {
            try {
                element = ownerDocument.createElement(nodeName);
            }
            catch (DOMException e) {
                FeedbackManager.addFeedback("Failed to create element [" + nodeName + "]");
                throw e;
            }
        } else {
            element = ownerDocument.createElement(ESCAPE_STRING);
            element.setAttribute(ESCAPE_VALUE_STRING, nodeName);
        }
        int invalidKeys = 0;
        Iterator properties = structuredPropertyAccess.getProperties();
        while (properties.hasNext()) {
            String key = (String)properties.next();
            String property = structuredPropertyAccess.getProperty(key, null);
            if (DefaultStructuredPropertyAccess.isValidKey(key)) {
                element.setAttribute(key, property);
                continue;
            }
            element.setAttribute(ESCAPE_STRING + invalidKeys, property);
            element.setAttribute(ESCAPE_VALUE_STRING + invalidKeys, key);
            ++invalidKeys;
        }
        Iterator childNodes = structuredPropertyAccess.getChildNodes();
        while (childNodes.hasNext()) {
            StructuredPropertyAccess childPropertyAccess = (StructuredPropertyAccess)childNodes.next();
            try {
                Element childElement = DefaultStructuredPropertyAccess.saveToElement(childPropertyAccess, ownerDocument);
                element.appendChild(childElement);
            }
            catch (DOMException e) {
                FeedbackManager.reportException(e);
            }
        }
        return element;
    }

    private static boolean isValidKey(String name) {
        boolean ret = false;
        if (name.length() > 0 && name.charAt(0) != '.' && !DefaultStructuredPropertyAccess.contains(name, "/$<> ")) {
            ret = true;
        }
        return ret;
    }

    private static boolean contains(String string, String chars) {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (chars.indexOf(c) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static DefaultStructuredPropertyAccess loadFromXML(File file) throws SAXException, XMLParseException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        DOMParser domParser = new DOMParser();
        domParser.setPreserveWhitespace(false);
        domParser.parse((InputStream)bufferedInputStream);
        XMLDocument xmlDocument = domParser.getDocument();
        Element root = xmlDocument.getDocumentElement();
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = DefaultStructuredPropertyAccess.loadFromElement(root);
        return defaultStructuredPropertyAccess;
    }

    private static DefaultStructuredPropertyAccess loadFromElement(Element root) {
        String escapedKeyKey;
        String escapedKey;
        String nodeName = root.getNodeName();
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess(nodeName);
        NamedNodeMap attributes = root.getAttributes();
        int attributesLength = attributes.getLength();
        int i = 0;
        while (i < attributesLength) {
            Attr attribute = (Attr)attributes.item(i);
            String key = attribute.getNodeName();
            String value = attribute.getNodeValue();
            defaultStructuredPropertyAccess.setProperty(key, value);
            ++i;
        }
        if (ESCAPE_STRING.equals(nodeName)) {
            String realNodeName = defaultStructuredPropertyAccess.getProperty(ESCAPE_VALUE_STRING, "");
            defaultStructuredPropertyAccess.setName(realNodeName);
            defaultStructuredPropertyAccess.removeProperty(ESCAPE_VALUE_STRING);
        }
        int escapedKeyCounter = 0;
        while ((escapedKey = defaultStructuredPropertyAccess.getProperty(escapedKeyKey = ESCAPE_STRING + escapedKeyCounter, null)) != null) {
            defaultStructuredPropertyAccess.removeProperty(escapedKeyKey);
            String escapedValueKey = ESCAPE_VALUE_STRING + escapedKeyCounter;
            String escapedValue = defaultStructuredPropertyAccess.getProperty(escapedValueKey, null);
            if (escapedValue == null) continue;
            defaultStructuredPropertyAccess.removeProperty(ESCAPE_VALUE_STRING + escapedKeyCounter);
            defaultStructuredPropertyAccess.setProperty(escapedKey, escapedValue);
        }
        NodeList childNodes = root.getChildNodes();
        int childrenLength = childNodes.getLength();
        int i2 = 0;
        while (i2 < childrenLength) {
            Node childNode = childNodes.item(i2);
            short nodeType = childNode.getNodeType();
            switch (nodeType) {
                case 1: {
                    Element element = (Element)childNode;
                    DefaultStructuredPropertyAccess child = DefaultStructuredPropertyAccess.loadFromElement(element);
                    defaultStructuredPropertyAccess.appendChild(child);
                    break;
                }
                case 3: {
                    DefaultStructuredPropertyAccess child = new DefaultStructuredPropertyAccess(TEXT);
                    String value = childNode.getNodeValue();
                    child.put(TEXT, value);
                    defaultStructuredPropertyAccess.appendChild(child);
                    break;
                }
                case 8: {
                    break;
                }
            }
            ++i2;
        }
        return defaultStructuredPropertyAccess;
    }

    final class 1
    extends IteratorFilter {
        private final /* synthetic */ String v$name;
        final /* synthetic */ DefaultStructuredPropertyAccess this$0;

        protected boolean isValid(Object o) {
            StructuredPropertyAccess child = (StructuredPropertyAccess)o;
            return this.v$name.equals(child.getName());
        }

        public 1(DefaultStructuredPropertyAccess defaultStructuredPropertyAccess, Iterator iterator, String string) {
            this.v$name = string;
            this.this$0 = defaultStructuredPropertyAccess;
            super(iterator);
        }
    }
}

