/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

public class BitField {
    private static final int FIELD_SIZE = 32;
    private int bits;
    private int size;

    private void $init$() {
        this.size = 0;
    }

    public BitField() {
        this.$init$();
        this.bits = 0;
    }

    public BitField(int bits) {
        this.$init$();
        this.setField(bits);
    }

    public int getSize() {
        return this.size;
    }

    public void set(int bitIndex) {
        BitField.checkIndex(bitIndex);
        this.bits |= BitField.bitmask(bitIndex);
        this.determineSize();
    }

    public void unset(int bitIndex) {
        BitField.checkIndex(bitIndex);
        this.bits &= ~BitField.bitmask(bitIndex);
        this.determineSize();
    }

    public void clear(int bitIndex) {
        this.unset(bitIndex);
    }

    public void toggle(int bitIndex) {
        BitField.checkIndex(bitIndex);
        this.bits ^= BitField.bitmask(bitIndex);
        this.determineSize();
    }

    public boolean isSet(int bitIndex) {
        BitField.checkIndex(bitIndex);
        int msk = BitField.bitmask(bitIndex);
        return (this.bits & msk) == msk;
    }

    public int get(int bitIndex) {
        BitField.checkIndex(bitIndex);
        return this.bits & BitField.bitmask(bitIndex);
    }

    public int getField() {
        return this.bits;
    }

    public void setField(int bits) {
        this.bits = bits;
        this.determineSize();
    }

    public static boolean isSet(int bits, int mask) {
        return mask != 0 ? (bits & mask) == mask : false;
    }

    public static int set(int bits, int mask) {
        return bits | mask;
    }

    public static int unset(int bits, int mask) {
        return bits & ~mask;
    }

    public static int toggle(int bits, int mask) {
        return bits ^ mask;
    }

    private void determineSize() {
        this.size = 0;
        int i = 0;
        while (i < 32) {
            if (this.isSet(i)) {
                this.size = i + 1;
            }
            ++i;
        }
    }

    private static int bitmask(int bitIndex) {
        return 1 << bitIndex;
    }

    private static void checkIndex(int bitIndex) {
        if (bitIndex < 0 || bitIndex >= 32) {
            throw new IndexOutOfBoundsException(Integer.toString(bitIndex));
        }
    }
}

