/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.todo;

import java.net.URL;
import java.util.Date;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.net.URLFileSystem;
import oracle.ide.todo.ToDoItem;
import oracle.ide.util.ModelUtil;

public abstract class AbstractToDoItem
extends ChangeEventSource
implements ToDoItem {
    private String _text;
    private int _priorityId;
    private int _line;
    private int _column;
    protected URL _url;
    private boolean _done;
    private Date _date;
    private Object _userData;

    public AbstractToDoItem() {
    }

    public AbstractToDoItem(String text, int priorityId, int line, int column, URL url, boolean done, Date date) {
        this._text = text;
        this._priorityId = priorityId;
        this._line = line;
        this._column = column;
        this._url = url;
        this._done = done;
        this._date = date;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
    }

    public String getTooltip() {
        return this._text;
    }

    public int getPriorityId() {
        return this._priorityId;
    }

    public void setPriorityId(int priorityId) {
        this._priorityId = priorityId;
    }

    public int getLine() {
        return this._line;
    }

    public void setLine(int line) {
        this._line = line;
    }

    public int getColumn() {
        return this._column;
    }

    public void setColumn(int column) {
        this._column = column;
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
        this._url = url;
    }

    public boolean isDone() {
        return this._done;
    }

    public void setDone(boolean done) {
        this._done = done;
    }

    public Date getDate() {
        return this._date;
    }

    public void setDate(Date date) {
        this._date = date;
    }

    public Object getUserData() {
        return this._userData;
    }

    public void setUserData(Object userData) {
        this._userData = userData;
    }

    public boolean isEditable() {
        return true;
    }

    public boolean shouldPersist() {
        return true;
    }

    public String toString() {
        return " Text: " + (this._text != null ? this._text : "<notext>") + " PriorityId: " + this._priorityId + " Line: " + this._line + " Column: " + this._column + " URL: " + (this._url != null ? this._url.toString() : "<noURL>") + " Done: " + this._done + " Date: " + (this._date != null ? this._date.toString() : "<noDate>");
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractToDoItem) {
            AbstractToDoItem item1 = (AbstractToDoItem)object;
            if (!(item1.getText() == null && this._text == null || ModelUtil.areEqual((Object)item1.getText(), (Object)this._text))) {
                return false;
            }
            if (item1.getPriorityId() != this._priorityId) {
                return false;
            }
            if (!(item1.getDate() == null && this._date == null || ModelUtil.areEqual((Object)item1.getDate(), (Object)this._date))) {
                return false;
            }
            if (item1.isDone() != this._done) {
                return false;
            }
            if (!(item1.getURL() == null && this._url == null || URLFileSystem.equals((URL)item1.getURL(), (URL)this._url))) {
                return false;
            }
            if (item1.getLine() != this._line) {
                return false;
            }
            if (item1.getColumn() != this._column) {
                return false;
            }
            return item1.getUserData() == null && this._userData == null || !ModelUtil.areEqual((Object)item1.getUserData(), (Object)this._userData);
        }
        return false;
    }

    public boolean canGoTo() {
        return this._url != null;
    }

    public abstract void goTo();

    public abstract void dispose();

    public abstract void stateChanged();
}

