/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import java.util.Iterator;
import oracle.ide.persistence.BPageCache;
import oracle.ide.persistence.DataPage;
import oracle.ide.persistence.FreePageMap;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.PackedNameSpace;
import oracle.ide.persistence.Page;
import oracle.ide.util.IntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StorageFile {
    private static final int MAJORVERSION = 0;
    private static final int MINORVERSION = 1;
    static final int BLKSIZE = 1024;
    private static final byte PAGE_TYPE_FREEPAGEMAP = 1;
    private static final byte PAGE_TYPE_FREEBITSET = 2;
    static final byte PAGE_TYPE_DATAPAGE = 3;
    private static final int FILEHEADERSIZE = 26;
    private static final byte[] MAGIC = new byte[]{75, 82, 54, 52, 77, 82, 54, 53};
    private String _fname;
    private RandomAccessFile _file;
    private int _endPage;
    private FreePageMap _freeMap;
    private int[] _freeMapStorage;
    private BPageCache _pc;
    private int _nsBIndex;
    private int _nsBpindex;
    private int _firstNS;
    private IntHashMap _openTrans;
    private IntHashMap _groupLocks;
    private Object _fileLock;
    private Exception _closedBy;
    private static byte[] NULL_BYTES = new byte[0];

    private void $init$() {
        this._fileLock = new Object();
    }

    StorageFile(String fname) {
        this.$init$();
        this._fname = fname;
    }

    long getmsize() {
        return this._endPage;
    }

    void dumpFile() {
        try {
            int cp = 1;
            byte[] cbuff = new byte[1024];
            while (cp < this._endPage) {
                this.readBytesFromOffset(cbuff, 0, 1, cp * 1024);
                if (!this._freeMap.isFree(cp)) {
                    switch (cbuff[0]) {
                        case 1: {
                            System.out.print("Page " + cp + " ");
                            System.out.println("Free Pages Map Indexes");
                            this.readBytesFromOffset(cbuff, 0, 4 * this._freeMapStorage.length, 1 + cp * 1024);
                            int ccp = 0;
                            int i = 0;
                            while (i < this._freeMapStorage.length) {
                                System.out.print(StorageFile.intFromArray(cbuff, ccp) + ",");
                                if ((ccp += 4) % 80 == 0) {
                                    System.out.println();
                                }
                                ++i;
                            }
                            System.out.println();
                            break;
                        }
                        case 2: {
                            System.out.print("Page " + cp + " ");
                            System.out.println("Freepage Bitset");
                            this.readBytesFromOffset(cbuff, 0, 1023, 1 + cp * 1024);
                            int i = 0;
                            while (i < 1023) {
                                int v = cbuff[i] & 0xFF;
                                System.out.print(Integer.toHexString(v + 256).substring(1).toUpperCase());
                                if (i % 64 == 63) {
                                    System.out.println();
                                }
                                ++i;
                            }
                            System.out.println();
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            System.out.println("UNKNOWN TYPE " + cbuff[0]);
                        }
                    }
                }
                ++cp;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    boolean open() throws IOException {
        if (this._file == null) {
            File file = new File(this._fname + ".stf");
            if ((file = file.getParentFile()) != null) {
                file.mkdirs();
            }
            if (!this.openFile()) {
                return false;
            }
            this.initDataStructures();
            return true;
        }
        return false;
    }

    private boolean openFile() throws IOException {
        this._file = new RandomAccessFile(this._fname + ".stf", "rw");
        return this._file.getChannel().tryLock() != null;
    }

    boolean readBytesFromOffset(byte[] buff, int offset) throws IOException {
        return this.readBytesFromOffset(buff, 0, buff.length, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readBytesFromOffset(byte[] buff, int pos, int len, int offset) throws IOException {
        try {
            Object object = this._fileLock;
            synchronized (object) {
                this.seek(offset);
                this._file.readFully(buff, pos, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (EOFException ex) {
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBytesFromOffset(byte[] buff, int offset) throws IOException {
        Object object = this._fileLock;
        synchronized (object) {
            this.seek(offset);
            this._file.write(buff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBytesFromOffset(byte[] buff, int pos, int len, int offset) throws IOException {
        Object object = this._fileLock;
        synchronized (object) {
            this.seek(offset);
            this._file.write(buff, pos, len);
        }
    }

    private void seek(int offset) throws IOException {
        if (this._file == null) {
            throw new IllegalStateException("Storage file " + this._fname + ".stf is closed", this._closedBy);
        }
        try {
            this._file.seek(offset);
        }
        catch (IOException e) {
            if (!this.openFile()) {
                throw new IOException("Unable to reopen storage file " + this._fname + ".stf");
            }
            this._file.seek(offset);
        }
    }

    static int intFromArray(byte[] buff, int off) {
        return ((buff[off++] & 0xFF) << 24) + ((buff[off++] & 0xFF) << 16) + ((buff[off++] & 0xFF) << 8) + (buff[off] & 0xFF);
    }

    static long longFromArray(byte[] buff, int off) {
        return ((long)StorageFile.intFromArray(buff, off) << 32) + ((long)StorageFile.intFromArray(buff, off + 4) & (long)-1);
    }

    static void intToArray(int v, byte[] buff, int off) {
        buff[off++] = (byte)(v >>> 24 & 0xFF);
        buff[off++] = (byte)(v >>> 16 & 0xFF);
        buff[off++] = (byte)(v >>> 8 & 0xFF);
        buff[off++] = (byte)(v & 0xFF);
    }

    static void longToArray(long v, byte[] buff, int off) {
        buff[off++] = (byte)(v >>> 56 & 0xFFL);
        buff[off++] = (byte)(v >>> 48 & 0xFFL);
        buff[off++] = (byte)(v >>> 40 & 0xFFL);
        buff[off++] = (byte)(v >>> 32 & 0xFFL);
        buff[off++] = (byte)(v >>> 24 & 0xFFL);
        buff[off++] = (byte)(v >>> 16 & 0xFFL);
        buff[off++] = (byte)(v >>> 8 & 0xFFL);
        buff[off++] = (byte)(v & 0xFFL);
    }

    void flushFreePages(boolean force) throws IOException {
        boolean needsIndexFlush = force;
        byte[] tag = new byte[]{2};
        int pts = this._freeMap.getDirtyIndex();
        while (pts != -1) {
            int fsindex = this._freeMapStorage[pts];
            if (fsindex == 0) {
                this._freeMapStorage[pts] = this.getFreePage();
                needsIndexFlush = true;
            } else {
                this.writeBytesFromOffset(tag, fsindex * 1024);
                this.writeBytesFromOffset(this._freeMap.getPageDatas(pts), 1 + fsindex * 1024);
                this._freeMap.clearDirty(pts);
            }
            pts = this._freeMap.getDirtyIndex();
        }
        if (needsIndexFlush) {
            tag = new byte[1024];
            tag[0] = 1;
            int p = 1;
            int i = 0;
            while (i < this._freeMapStorage.length) {
                StorageFile.intToArray(this._freeMapStorage[i], tag, p);
                p += 4;
                ++i;
            }
            this.writeBytesFromOffset(tag, 1024);
        }
    }

    void loadFreePages(int startpage) throws IOException {
        this._freeMap = new FreePageMap();
        this._freeMapStorage = new int[255];
        byte[] mbuff = new byte[1024];
        byte[] bmap = new byte[1024];
        this.readBytesFromOffset(mbuff, startpage * 1024);
        if (mbuff[0] != 1) {
            throw new IOException("wrong FreePageMap page tag");
        }
        int pos = 1;
        int cp = 0;
        int fpindex = StorageFile.intFromArray(mbuff, pos);
        pos += 4;
        while (fpindex != 0) {
            this._freeMapStorage[cp] = fpindex;
            this.readBytesFromOffset(bmap, fpindex * 1024);
            if (bmap[0] != 2) {
                throw new IOException("wrong FreePage BitSet page tag");
            }
            this._freeMap.setPageDatas(cp, bmap, 1, 1023);
            ++cp;
            fpindex = StorageFile.intFromArray(mbuff, pos);
            pos += 4;
        }
    }

    void initDataStructures() throws IOException {
        boolean isOK;
        block8: {
            isOK = true;
            try {
                this._pc = new BPageCache(this);
                this._openTrans = new IntHashMap();
                this._groupLocks = new IntHashMap();
                byte[] header = new byte[26];
                if (this.readBytesFromOffset(header, 0)) {
                    int i = 0;
                    int j = 0;
                    while (j < MAGIC.length) {
                        if (header[i++] != MAGIC[j]) {
                            isOK = false;
                        }
                        ++j;
                    }
                    if (!isOK) break block8;
                    ++i;
                    ++i;
                    int firstFreePage = StorageFile.intFromArray(header, i += 4);
                    this._nsBIndex = StorageFile.intFromArray(header, i += 4);
                    this._firstNS = StorageFile.intFromArray(header, i += 4);
                    i += 4;
                    this.loadFreePages(firstFreePage);
                    try {
                        this._endPage = (int)((this._file.length() + 1023L & 0xFFFFFFFFFFFFFC00L) / 1024L);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.checkNameSpaces();
                    new NsPageDesc(this._nsBIndex);
                    break block8;
                }
                isOK = false;
            }
            catch (IOException e) {
                isOK = false;
            }
        }
        if (!isOK) {
            this._endPage = 2;
            this._freeMap = new FreePageMap();
            this._freeMapStorage = new int[255];
            this._firstNS = 0;
            this.flushFreePages(true);
            this._nsBIndex = this.createTreeIndex("$$root$$");
            this.saveHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getGroupLock(int group) {
        IntHashMap intHashMap = this._groupLocks;
        synchronized (intHashMap) {
            Object res = this._groupLocks.get(group);
            if (res == null) {
                res = new Object();
                this._groupLocks.put(group, res);
            }
            Object v = res;
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanGroup(int group) throws IOException {
        int cp = 1;
        this._pc.cleanGroup(group);
        IntHashMap intHashMap = this._groupLocks;
        synchronized (intHashMap) {
            this._groupLocks.remove(group);
        }
        byte[] cbuff = new byte[1024];
        while (cp < this._endPage) {
            this.readBytesFromOffset(cbuff, 0, 1, cp * 1024);
            if (!this._freeMap.isFree(cp)) {
                switch (cbuff[0]) {
                    case 3: {
                        this.readBytesFromOffset(cbuff, cp * 1024);
                        int ntag = StorageFile.intFromArray(cbuff, 2);
                        if (group != ntag) break;
                        this.releasePage(cp);
                        break;
                    }
                }
            }
            ++cp;
        }
        this.flush();
    }

    private boolean checkNameSpace(int nsIndex) throws IOException {
        NsPageDesc pd = new NsPageDesc(nsIndex);
        if (!pd._clean) {
            this.cleanGroup(nsIndex);
            this._pc.startTrans();
            pd._rootpage = this._pc.getNewPage(nsIndex);
            this._pc.flush(nsIndex);
            this._pc.endTrans();
            pd.save(false);
            this.flush();
        }
        return pd._clean;
    }

    private void checkNameSpaces() throws IOException {
        int curNS;
        if (!this.checkNameSpace(this._nsBIndex)) {
            NsPageDesc rpd = new NsPageDesc(this._nsBIndex);
            this._nsBpindex = rpd._rootpage;
            curNS = this._firstNS;
            this._pc.startTrans();
            while (curNS != 0) {
                NsPageDesc pd = new NsPageDesc(curNS);
                Page.addEntry(this._pc, this._nsBIndex, rpd._rootpage, pd._name, pd._addr);
                curNS = pd._next;
            }
            this._pc.flush(this._nsBIndex);
            this._pc.endTrans();
            this.flush();
            rpd._clean = true;
            rpd.save(false);
            this.flush();
        } else {
            NsPageDesc rpd = new NsPageDesc(this._nsBIndex);
            this._nsBpindex = rpd._rootpage;
        }
        curNS = this._firstNS;
        while (curNS != 0) {
            NsPageDesc pd = new NsPageDesc(curNS);
            this.checkNameSpace(curNS);
            curNS = pd._next;
        }
    }

    synchronized void deleteNameSpace(NameSpace ns) throws IOException {
        NsPageDesc pd = new NsPageDesc(ns._pindex);
        pd._clean = false;
        pd.save(false);
        this.cleanGroup(ns._pindex);
        NsPageDesc pdi = new NsPageDesc(this._nsBIndex);
        pdi._clean = false;
        pdi.save(false);
        this.flush();
        this._pc.startTrans();
        Page.removeString(this._pc, this._nsBIndex, this._nsBpindex, pd._name);
        this._pc.flush(this._nsBIndex);
        this._pc.endTrans();
        if (pd._next != 0) {
            NsPageDesc np = new NsPageDesc(pd._next);
            np._prev = pd._prev;
            np.save(false);
        }
        if (pd._prev != 0) {
            NsPageDesc np = new NsPageDesc(pd._prev);
            np._next = pd._next;
            np.save(false);
        } else {
            this._firstNS = pd._next;
        }
        this.saveHeader();
        this.deleteBlob(pd._addr);
        pdi._clean = true;
        pdi.save(false);
        this.flush();
    }

    Iterator<String> getNameSpaceIterator(String name, boolean ignorecase) {
        return new nsIterator(name, this._nsBIndex, this._nsBpindex, ignorecase);
    }

    Iterator<String> getKeyIterator(int group, int root, String keyStart, boolean ignorecase) {
        return new nsIterator(keyStart, group, root, ignorecase);
    }

    Iterator<String> getReverseNameSpaceIterator(String name, boolean ignorecase) {
        return new nsReverseIterator(name, this._nsBIndex, this._nsBpindex, ignorecase);
    }

    Iterator<String> getReverseKeyIterator(int group, int root, String keyStart, boolean ignorecase) {
        return new nsReverseIterator(keyStart, group, root, ignorecase);
    }

    synchronized NameSpace getNameSpace(String name, int type) throws IOException {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Invalid NameSpace type");
        }
        this._pc.startTrans();
        int ref = Page.getEntry(this._pc, this._nsBIndex, this._nsBpindex, name);
        this._pc.endTrans();
        if (ref == -1) {
            NsPageDesc pd = new NsPageDesc();
            ref = pd._addr = this.getFreePage();
            pd._name = name;
            pd._clean = true;
            NsPageDesc pdi = new NsPageDesc(this._nsBIndex);
            pdi._clean = false;
            pdi.save(false);
            this.flush();
            this._pc.startTrans();
            pd._rootpage = this._pc.getNewPage(pd._addr);
            Page.addEntry(this._pc, this._nsBIndex, this._nsBpindex, name, pd._addr);
            this._pc.flush(this._nsBIndex);
            this._pc.endTrans();
            if (this._firstNS != 0) {
                NsPageDesc oldp = new NsPageDesc(this._firstNS);
                oldp._prev = pd._addr;
                oldp.save(false);
            }
            pd._next = this._firstNS;
            this._firstNS = pd._addr;
            this.saveHeader();
            pd.save(true);
            pdi._clean = true;
            pdi.save(false);
            this.flush();
        }
        NsPageDesc p = new NsPageDesc(ref);
        if (type == 1) {
            return new PackedNameSpace(p._addr, p._rootpage);
        }
        return new NameSpace(p._addr, p._rootpage);
    }

    private int createTreeIndex(String name) throws IOException {
        int res = this.getFreePage();
        this._pc.startTrans();
        int rootpage = this._pc.getNewPage(res);
        DataOutputStream os = null;
        try {
            os = new DataOutputStream(this.getNewOSFromRec(res, 0));
            os.writeBoolean(true);
            os.writeInt(0);
            os.writeInt(0);
            os.writeInt(rootpage);
            this._nsBpindex = rootpage;
            os.writeUTF(name);
        }
        catch (Throwable throwable) {
            this.closeIgnoringException(os);
            throw throwable;
        }
        this.closeIgnoringException(os);
        this._pc.flush(res);
        this._pc.endTrans();
        this.flush();
        return res;
    }

    private void closeIgnoringException(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveHeader() throws IOException {
        byte[] header = new byte[26];
        int i = 0;
        System.arraycopy(MAGIC, 0, header, 0, MAGIC.length);
        i += 8;
        header[i++] = 0;
        header[i++] = 1;
        StorageFile.intToArray(1024, header, i);
        StorageFile.intToArray(1, header, i += 4);
        StorageFile.intToArray(this._nsBIndex, header, i += 4);
        StorageFile.intToArray(this._firstNS, header, i += 4);
        this.writeBytesFromOffset(header, 0);
    }

    boolean close() {
        if (this._file != null) {
            try {
                this.flushFreePages(false);
                this._file.close();
                this._file = null;
                this._closedBy = new RuntimeException("Closed by:");
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    byte[] getFullPage(int idx) throws IOException {
        byte[] datas = new byte[1024];
        this.readBytesFromOffset(datas, idx * 1024);
        return datas;
    }

    int getFreePage() {
        int res = this._freeMap.getFreePos();
        if (res == -1) {
            res = this._endPage++;
        }
        return res;
    }

    void releasePage(int index) {
        this._freeMap.setFree(index);
    }

    OutputStream getOSFromRec(int addr, int group) throws IOException {
        return DataPage.updatePageGroup(this, group, addr);
    }

    OutputStream getNewOSFromRec(int addr, int group) {
        return DataPage.newPageGroup(this, group, addr);
    }

    InputStream getISFromRec(int addr) throws IOException {
        return DataPage.readPageGroup(this, addr);
    }

    synchronized void incDirty(int group) throws IOException {
        Integer dirtlevel = (Integer)this._openTrans.get(group);
        if (dirtlevel == null) {
            NsPageDesc pd = new NsPageDesc(group);
            pd._clean = false;
            pd.save(false);
            this.flush();
            this._openTrans.put(group, 1);
        } else {
            this._openTrans.put(group, dirtlevel + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void decDirty(int group) throws IOException {
        Object object = this.getGroupLock(group);
        synchronized (object) {
            Integer dirtlevel = (Integer)this._openTrans.get(group);
            if (dirtlevel != null) {
                if (dirtlevel <= 1) {
                    NsPageDesc pd = new NsPageDesc(group);
                    pd._clean = true;
                    this._pc.flush(group);
                    pd.save(false);
                    this.flush();
                    this._openTrans.remove(group);
                } else {
                    this._openTrans.put(group, dirtlevel - 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getISFromKey(int group, int root, String key) throws IOException {
        Object object = this.getGroupLock(group);
        synchronized (object) {
            this._pc.startTrans();
            int ref = Page.getEntry(this._pc, group, root, key);
            this._pc.endTrans();
            if (ref == -1) {
                InputStream inputStream = null;
                return inputStream;
            }
            InputStream inputStream = this.getISFromRec(ref);
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFromKey(int group, int root, String key) throws IOException {
        Object object = this.getGroupLock(group);
        synchronized (object) {
            this._pc.startTrans();
            int ref = Page.getEntry(this._pc, group, root, key);
            this._pc.endTrans();
            if (ref == -1) {
                return;
            }
            this._pc.startTrans();
            Page.removeString(this._pc, group, root, key);
            this._pc.endTrans();
            if (ref != 0) {
                this.deleteBlob(ref);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getISBytesFromKey(int group, int root, String key) throws IOException {
        Object object = this.getGroupLock(group);
        synchronized (object) {
            this._pc.startTrans();
            int ref = Page.getEntry(this._pc, group, root, key);
            this._pc.endTrans();
            if (ref == 0) {
                byte[] byArray = NULL_BYTES;
                return byArray;
            }
            if (ref == -1) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = DataPage.readFullPageGroup(this, ref);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getNextKey(int group, int root, String key) throws IOException {
        Object object = this.getGroupLock(group);
        synchronized (object) {
            this._pc.startTrans();
            String res = Page.getNextEntry(this._pc, group, root, key);
            this._pc.endTrans();
            String string = res;
            return string;
        }
    }

    void checkTree(String mess, int group, int root) throws IOException {
        this._pc.startTrans();
        Page.checkPage(mess, this._pc, group, root, null, true);
        this._pc.endTrans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream getOSFromKey(int group, int root, String key) throws IOException {
        OutputStream res;
        Object object = this.getGroupLock(group);
        synchronized (object) {
            this._pc.startTrans();
            int ref = Page.getEntry(this._pc, group, root, key);
            if (ref == -1) {
                ref = this.getFreePage();
                res = this.getNewOSFromRec(ref, group);
                Page.addEntry(this._pc, group, root, key, ref);
            } else if (ref == 0) {
                ref = this.getFreePage();
                res = this.getNewOSFromRec(ref, group);
                Page.updateEntry(this._pc, group, root, key, ref);
            } else {
                res = this.getOSFromRec(ref, group);
            }
            this._pc.endTrans();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateEmptyKey(int group, int root, String key) throws IOException {
        Object object = this.getGroupLock(group);
        synchronized (object) {
            this._pc.startTrans();
            int ref = Page.getEntry(this._pc, group, root, key);
            if (ref == -1) {
                Page.addEntry(this._pc, group, root, key, 0);
            } else if (ref != 0) {
                this.deleteBlob(ref);
                Page.updateEntry(this._pc, group, root, key, ref);
            }
            this._pc.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkKey(int group, int root, String key) throws IOException {
        int ref;
        Object object = this.getGroupLock(group);
        synchronized (object) {
            this._pc.startTrans();
            ref = Page.getEntry(this._pc, group, root, key);
            this._pc.endTrans();
        }
        return ref != -1;
    }

    int addBlob(byte[] data, int group) throws IOException {
        int res = this.getFreePage();
        OutputStream blob = DataPage.newPageGroup(this, group, res);
        try {
            blob.write(data);
        }
        finally {
            this.closeIgnoringException(blob);
        }
        return res;
    }

    void updateBlob(byte[] data, int addr, int group) throws IOException {
        OutputStream blob = DataPage.updatePageGroup(this, group, addr);
        try {
            blob.write(data);
        }
        finally {
            this.closeIgnoringException(blob);
        }
    }

    void deleteBlob(int addr) throws IOException {
        DataPage.deletePageGroup(this, addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() throws IOException {
        this.flushFreePages(false);
        Object object = this._fileLock;
        synchronized (object) {
            try {
                this._file.getFD().sync();
            }
            catch (SyncFailedException syncFailedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printTreePages(int group, int root) {
        Object object = this.getGroupLock(group);
        synchronized (object) {
            try {
                this._pc.startTrans();
                Page.printAllPages(this._pc, group, root);
                this._pc.endTrans();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static void mav$closeIgnoringException(StorageFile storageFile, Closeable closeable) {
        storageFile.closeIgnoringException(closeable);
    }

    static BPageCache ra$_pc(StorageFile storageFile) {
        return storageFile._pc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SingleWrite
    implements Comparable {
        int _offset;
        byte[] _buff;

        public SingleWrite(int off, byte[] buff) {
            this._offset = off;
            this._buff = buff;
        }

        public int compareTo(Object o) {
            SingleWrite sr = (SingleWrite)o;
            return sr._offset - this._offset;
        }
    }

    class NsPageDesc {
        int _addr;
        boolean _clean;
        int _next;
        int _prev;
        int _rootpage;
        String _name;

        NsPageDesc(int addr) throws IOException {
            this._addr = addr;
            DataInputStream is = null;
            try {
                is = new DataInputStream(StorageFile.this.getISFromRec(this._addr));
                this._clean = is.readBoolean();
                this._next = is.readInt();
                this._prev = is.readInt();
                this._rootpage = is.readInt();
                this._name = is.readUTF();
            }
            catch (Throwable throwable) {
                StorageFile.mav$closeIgnoringException(StorageFile.this, is);
                throw throwable;
            }
            StorageFile.mav$closeIgnoringException(StorageFile.this, is);
        }

        NsPageDesc() {
        }

        void save(boolean isNew) throws IOException {
            DataOutputStream os = null;
            try {
                os = isNew ? new DataOutputStream(StorageFile.this.getNewOSFromRec(this._addr, 0)) : new DataOutputStream(StorageFile.this.getOSFromRec(this._addr, 0));
                os.writeBoolean(this._clean);
                os.writeInt(this._next);
                os.writeInt(this._prev);
                os.writeInt(this._rootpage);
                os.writeUTF(this._name);
            }
            catch (Throwable throwable) {
                StorageFile.mav$closeIgnoringException(StorageFile.this, os);
                throw throwable;
            }
            StorageFile.mav$closeIgnoringException(StorageFile.this, os);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class nsIterator
    implements Iterator<String> {
        private String _prefix;
        private String _curkey;
        private String _last;
        private int _group;
        private int _root;
        private boolean _ignoreCase;

        nsIterator(String start, int group, int root, boolean ignoreCase) {
            this(start, start, group, root, ignoreCase);
        }

        nsIterator(String start, String curk, int group, int root, boolean ignoreCase) {
            this._prefix = start;
            this._curkey = curk;
            this._group = group;
            this._root = root;
            this._ignoreCase = ignoreCase;
            if (ignoreCase) {
                StorageFile.ra$_pc(StorageFile.this).startTrans();
                this._last = this.getNextIgnoreCase(StorageFile.ra$_pc(StorageFile.this), this._group, this._root, this._curkey);
                StorageFile.ra$_pc(StorageFile.this).endTrans();
                if (this.keyBad(this._last)) {
                    this._last = null;
                }
            }
        }

        protected String getNext(BPageCache pc, int group, int pindex, String k) {
            try {
                String string = Page.getNextEntry(pc, group, pindex, k);
                return string;
            }
            catch (IOException ex) {
                String string = null;
                return string;
            }
        }

        protected String getNextIgnoreCase(BPageCache pc, int group, int pindex, String k) {
            try {
                String string = Page.getNextEntryIgnoreCase(pc, group, pindex, k);
                return string;
            }
            catch (IOException ex) {
                String string = null;
                return string;
            }
        }

        private boolean keyBad(String key) {
            return this._ignoreCase ? key != null && (this._prefix.length() > key.length() || this._prefix.compareToIgnoreCase(key.substring(0, this._prefix.length())) != 0) : key != null && !key.startsWith(this._prefix);
        }

        @Override
        public boolean hasNext() {
            if (this._curkey == null) {
                return false;
            }
            StorageFile.ra$_pc(StorageFile.this).startTrans();
            this._last = this.getNext(StorageFile.ra$_pc(StorageFile.this), this._group, this._root, this._curkey);
            StorageFile.ra$_pc(StorageFile.this).endTrans();
            if (this.keyBad(this._last)) {
                this._last = null;
            }
            return this._last != null;
        }

        @Override
        public String next() {
            if (this._curkey == null) {
                return null;
            }
            if (this._last != null) {
                this._curkey = this._last;
            } else {
                StorageFile.ra$_pc(StorageFile.this).startTrans();
                this._curkey = this.getNext(StorageFile.ra$_pc(StorageFile.this), this._group, this._root, this._curkey);
                StorageFile.ra$_pc(StorageFile.this).endTrans();
            }
            this._last = null;
            if (this.keyBad(this._curkey)) {
                this._curkey = null;
            }
            return this._curkey;
        }

        @Override
        public void remove() {
        }
    }

    class nsReverseIterator
    extends nsIterator {
        nsReverseIterator(String start, int group, int root, boolean ignoreCase) {
            super(start, start + "\u20000", group, root, ignoreCase);
        }

        protected String getNext(BPageCache pc, int group, int pindex, String k) {
            try {
                String string = Page.getPreviousEntry(pc, group, pindex, k);
                return string;
            }
            catch (IOException ex) {
                String string = null;
                return string;
            }
        }

        protected String getNextIgnoreCase(BPageCache pc, int group, int pindex, String k) {
            try {
                String string = Page.getPreviousEntryIgnoreCase(pc, group, pindex, k);
                return string;
            }
            catch (IOException ex) {
                String string = null;
                return string;
            }
        }
    }
}

