/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TimerTask;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.persistence.PersistenceLogger;
import oracle.ide.persistence.StorageFile;
import oracle.javatools.util.NamedTimer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameSpace {
    public static final int NSTYPE_NORMAL = 0;
    public static final int NSTYPE_PACKED = 1;
    private static final HashMap<String, StorageFile> STORAGE_FILES = new HashMap();
    private static final String DEFSTOREDIR = "oracle.javatools.cache";
    private static final String DEFSTORENAME = "anspersist";
    private static final int MAX_RETRIES = 5;
    private static final Iterator<String> EMPTY_ITERATOR = new 1();
    private static NamedTimer _flushTimer;
    int _pindex;
    int _btreeindex;
    private String _name;
    private boolean _dirty;
    private long _autoDelay;
    private TimerTask _flushTask;
    private long _timeLimit;
    private StorageFile _store;

    private static StorageFile open(String s) {
        try {
            int i = 0;
            while (i < 5) {
                StorageFile sf = new StorageFile(s + "_" + i);
                if (sf.open()) {
                    StorageFile storageFile = sf;
                    return storageFile;
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected StorageFile getStore() {
        return this._store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StorageFile getStorageFile(String location) {
        HashMap<String, StorageFile> hashMap = STORAGE_FILES;
        synchronized (hashMap) {
            StorageFile sf = STORAGE_FILES.get(location);
            if (sf == null) {
                sf = NameSpace.open(location + File.separator + DEFSTORENAME);
                STORAGE_FILES.put(location, sf);
            }
            StorageFile storageFile = sf;
            return storageFile;
        }
    }

    private static String getDefaultLocation() {
        String persistenceDirectory = System.getProperty("persistence.directory");
        if (persistenceDirectory == null) {
            persistenceDirectory = Ide.getSystemDirectory();
        }
        return persistenceDirectory + DEFSTOREDIR;
    }

    public static Iterator<String> getNameSpaceIterator() {
        return NameSpace.getNameSpaceIterator("", false);
    }

    public static Iterator<String> getReverseNameSpaceIterator() {
        return NameSpace.getReverseNameSpaceIterator("", false);
    }

    public static Iterator<String> getNameSpaceIterator(String prefix) {
        return NameSpace.getNameSpaceIterator(prefix, false);
    }

    public static Iterator<String> getReverseNameSpaceIterator(String prefix) {
        return NameSpace.getReverseNameSpaceIterator(prefix, false);
    }

    public static Iterator<String> getNameSpaceIterator(String prefix, boolean ignorecase) {
        return NameSpace.getLocalNameSpaceIterator(NameSpace.getDefaultLocation(), prefix, ignorecase);
    }

    public static Iterator<String> getReverseNameSpaceIterator(String prefix, boolean ignorecase) {
        return NameSpace.getLocalReverseNameSpaceIterator(NameSpace.getDefaultLocation(), prefix, ignorecase);
    }

    public static Iterator<String> getLocalNameSpaceIterator(String location, String prefix, boolean ignorecase) {
        StorageFile sf = NameSpace.getStorageFile(location);
        if (sf != null) {
            return sf.getNameSpaceIterator(prefix, ignorecase);
        }
        return EMPTY_ITERATOR;
    }

    public static Iterator<String> getLocalReverseNameSpaceIterator(String location, String prefix, boolean ignorecase) {
        StorageFile sf = NameSpace.getStorageFile(location);
        if (sf != null) {
            return sf.getReverseNameSpaceIterator(prefix, ignorecase);
        }
        return EMPTY_ITERATOR;
    }

    public static NameSpace getNameSpace(String name) {
        return NameSpace.getNameSpace(name, 0);
    }

    public static NameSpace getNameSpace(String name, int type) {
        return NameSpace.getLocalNameSpace(NameSpace.getDefaultLocation(), name, type);
    }

    public static NameSpace getLocalNameSpace(String location, String name) {
        return NameSpace.getLocalNameSpace(location, name, 0);
    }

    public static NameSpace getLocalNameSpace(String location, String name, int type) {
        NameSpace ns = null;
        StorageFile sf = NameSpace.getStorageFile(location);
        if (sf != null) {
            try {
                ns = sf.getNameSpace(name, type);
                ns._store = sf;
                ns._name = name;
                NameSpace nameSpace = ns;
                return nameSpace;
            }
            catch (IOException ex) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to get namespace " + name + " from " + location, ex);
            }
        }
        return ns;
    }

    public static void clearStorage(String location) {
        NameSpace.closeStorage(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeStorage(String location) {
        HashMap<String, StorageFile> hashMap = STORAGE_FILES;
        synchronized (hashMap) {
            StorageFile sf = STORAGE_FILES.get(location);
            if (sf != null) {
                sf.close();
                STORAGE_FILES.remove(location);
            }
        }
    }

    NameSpace(int pindex, int rindex) {
        this._pindex = pindex;
        this._btreeindex = rindex;
        this._dirty = false;
    }

    public static void deleteNameSpace(String name) {
        NameSpace.deleteLocalNameSpace(NameSpace.getDefaultLocation(), name);
    }

    public static void deleteLocalNameSpace(String location, String name) {
        StorageFile sf = NameSpace.getStorageFile(location);
        if (sf != null) {
            try {
                NameSpace ns = sf.getNameSpace(name, 0);
                sf.deleteNameSpace(ns);
            }
            catch (IOException ex) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to delete namespace " + name, ex);
            }
        }
    }

    public InputStream getRecordStream(String key) {
        try {
            InputStream inputStream = this._store.getISFromKey(this._pindex, this._btreeindex, key);
            return inputStream;
        }
        catch (IOException ex) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to read record " + key, ex);
            InputStream inputStream = null;
            return inputStream;
        }
    }

    public static synchronized NamedTimer getFlushTimer() {
        if (_flushTimer == null) {
            _flushTimer = new NamedTimer("Persistence Auto Flusher", 5, true);
        }
        return _flushTimer;
    }

    public synchronized void setAutoFlush(long delay) {
        this._autoDelay = delay;
    }

    public synchronized void cancelAutoFlush() {
        if (this._flushTask != null) {
            this._flushTask.cancel();
            this._flushTask = null;
            this._autoDelay = 0L;
        }
    }

    public byte[] getRecord(String key) {
        try {
            byte[] res;
            byte[] byArray = res = this._store.getISBytesFromKey(this._pindex, this._btreeindex, key);
            return byArray;
        }
        catch (IOException ex) {
            byte[] byArray = null;
            return byArray;
        }
    }

    private synchronized void checkDirty() {
        if (this._dirty) {
            if (this._flushTask != null) {
                this._timeLimit = System.currentTimeMillis() + this._autoDelay;
            }
            return;
        }
        if (this._autoDelay != 0L) {
            this._timeLimit = System.currentTimeMillis() + this._autoDelay;
            this._flushTask = new AutoFlusher();
            NameSpace.getFlushTimer().scheduleAtFixedRate(this._flushTask, this._autoDelay, 1000L);
        }
        try {
            this._store.incDirty(this._pindex);
        }
        catch (IOException ex) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to mark namespace dirty", ex);
        }
        this._dirty = true;
    }

    public synchronized void flush() {
        if (this._dirty) {
            try {
                this._store.decDirty(this._pindex);
            }
            catch (IOException ex) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to mark namespace clean", ex);
            }
        }
        this._flushTask = null;
        this._dirty = false;
    }

    public void close() {
        this.flush();
    }

    public void delRecord(String key) {
        this.checkDirty();
        try {
            this._store.deleteFromKey(this._pindex, this._btreeindex, key);
        }
        catch (IOException ex) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to delete record " + key, ex);
        }
    }

    public OutputStream putRecordStream(String key) {
        return this.putRecordStreamInternal(key);
    }

    private OutputStream putRecordStreamInternal(String key) {
        this.checkDirty();
        try {
            OutputStream outputStream = this._store.getOSFromKey(this._pindex, this._btreeindex, key);
            return outputStream;
        }
        catch (IOException ex) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to write record " + key, ex);
            OutputStream outputStream = null;
            return outputStream;
        }
    }

    public boolean checkRecord(String key) {
        try {
            boolean bl = this._store.checkKey(this._pindex, this._btreeindex, key);
            return bl;
        }
        catch (IOException ex) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to check record " + key, ex);
            boolean bl = false;
            return bl;
        }
    }

    public void putRecord(String key, byte[] data) {
        if (data != null && data.length != 0) {
            OutputStream os = this.putRecordStreamInternal(key);
            try {
                os.write(data);
                os.close();
            }
            catch (Exception ex) {}
        } else {
            this.checkDirty();
            try {
                this._store.updateEmptyKey(this._pindex, this._btreeindex, key);
            }
            catch (IOException ex) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to put record " + key, ex);
            }
        }
    }

    public Iterator<String> getKeyIterator() {
        return this.getKeyIterator("", false);
    }

    public Iterator<String> getReverseKeyIterator() {
        return this.getReverseKeyIterator("", false);
    }

    public Iterator<String> getKeyIterator(String prefix) {
        return this.getKeyIterator(prefix, false);
    }

    public Iterator<String> getReverseKeyIterator(String prefix) {
        return this.getReverseKeyIterator(prefix, false);
    }

    public Iterator<String> getKeyIterator(String prefix, boolean ignorecase) {
        return this._store.getKeyIterator(this._pindex, this._btreeindex, prefix, ignorecase);
    }

    public Iterator<String> getReverseKeyIterator(String prefix, boolean ignorecase) {
        return this._store.getReverseKeyIterator(this._pindex, this._btreeindex, prefix, ignorecase);
    }

    void checkTree(String mess) throws IOException {
        this._store.checkTree(mess, this._pindex, this._btreeindex);
    }

    void printTree() {
        this._store.printTreePages(this._pindex, this._btreeindex);
    }

    public String getName() {
        return this._name;
    }

    static long ra$_timeLimit(NameSpace nameSpace) {
        return nameSpace._timeLimit;
    }

    static final class 1
    implements Iterator {
        public boolean hasNext() {
            return false;
        }

        public String next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    class AutoFlusher
    extends TimerTask {
        public void run() {
            if (System.currentTimeMillis() > NameSpace.ra$_timeLimit(NameSpace.this)) {
                NameSpace.this.flush();
                this.cancel();
            }
        }

        AutoFlusher() {
        }
    }
}

